/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

public interface AgentState {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$lsst$ccs$bus$states$PhaseState;

    public static boolean isLegal(StateBundle bundle) {
        AlertState alertState = (AlertState)bundle.getState(AlertState.class);
        OperationalState operationalState = (OperationalState)bundle.getState(OperationalState.class);
        ConfigurationState configurationState = (ConfigurationState)bundle.getState(ConfigurationState.class);
        if (alertState == AlertState.ALARM && operationalState != OperationalState.ENGINEERING_FAULT) {
            return false;
        }
        return operationalState != OperationalState.NORMAL || configurationState != ConfigurationState.DIRTY;
    }

    public static boolean isLegal(StateBundle before, StateBundle after) {
        PhaseState phaseAfter;
        if (!AgentState.isLegal(after)) {
            return false;
        }
        OperationalState operationalBefore = (OperationalState)before.getState(OperationalState.class);
        OperationalState operationalAfter = (OperationalState)after.getState(OperationalState.class);
        PhaseState phaseBefore = (PhaseState)before.getState(PhaseState.class);
        if (phaseBefore != (phaseAfter = (PhaseState)after.getState(PhaseState.class))) {
            if (phaseBefore == null) {
                if (phaseAfter != PhaseState.INITIALIZING) {
                    return false;
                }
            } else {
                switch (phaseBefore) {
                    case OFF_LINE: {
                        return false;
                    }
                    case INITIALIZING: {
                        if (phaseAfter == PhaseState.OPERATIONAL || phaseAfter == PhaseState.CLOSING) break;
                        return false;
                    }
                    case OPERATIONAL: {
                        if (phaseAfter == PhaseState.CLOSING) break;
                        return false;
                    }
                    case CLOSING: {
                        if (phaseAfter == PhaseState.OFF_LINE) break;
                        return false;
                    }
                }
            }
        }
        return operationalBefore == operationalAfter || operationalBefore != null && operationalBefore != OperationalState.ENGINEERING_FAULT || operationalAfter != OperationalState.NORMAL;
    }
}

