/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;

public final class RaisedAlertHistory
implements Serializable {
    private static final long serialVersionUID = 883621057372902934L;
    private final Alert originalAlert;
    private final List<RaisedAlertInstance> instances;
    private AlertState highestSeverity = AlertState.NOMINAL;

    public RaisedAlertHistory(Alert alert) {
        this.instances = new ArrayList<RaisedAlertInstance>();
        this.originalAlert = new Alert(alert.getAlertId(), alert.getDescription());
    }

    public Alert getAlert() {
        return this.originalAlert;
    }

    public void addAlertInstance(AlertState severity, long timestamp) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
        }
        this.instances.add(new RaisedAlertInstance(severity, timestamp));
    }

    public void addAlertInstance(AlertState severity) {
        this.addAlertInstance(severity, System.currentTimeMillis());
    }

    public int getNumberOfInstances() {
        return this.instances.size();
    }

    public AlertState getLatestAlertState() {
        switch (this.getNumberOfInstances()) {
            case 0: {
                return AlertState.NOMINAL;
            }
        }
        return this.instances.get(this.getNumberOfInstances() - 1).getAlertState();
    }

    public long getLatestAlertTimestamp() {
        switch (this.getNumberOfInstances()) {
            case 0: {
                return -1L;
            }
        }
        return this.instances.get(this.getNumberOfInstances() - 1).getTimestamp();
    }

    public AlertState getHighestAlertState() {
        return this.highestSeverity;
    }

    public List<RaisedAlertInstance> getRaisedAlertInstancesList() {
        return Collections.unmodifiableList(this.instances);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Raised Alarms for id ").append(this.getAlert().getAlertId()).append("\n");
        sb.append("Overall Severity: ").append(this.getHighestAlertState());
        return sb.toString();
    }
}

