/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;

@Table(name="ASubsystemDescription", uniqueConstraints={@UniqueConstraint(columnNames={"subsystemName", "tag"})})
@Entity
@Immutable
public class ASubsystemDescription
extends SubsystemDescription
implements Cloneable {
    private static final long serialVersionUID = 7518445583831244327L;
    @Id
    @GeneratedValue
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    protected Map<String, AParameterDescription> paramDescriptions = new HashMap<String, AParameterDescription>();
    @Transient
    private Map<String, AParameterDescription> unModifiableParams = Collections.unmodifiableMap(this.paramDescriptions);
    @Transient
    private Set<String> categorySet = new HashSet<String>();

    ASubsystemDescription() {
    }

    public ASubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour) {
        super(subsystemName, tag, user, version, configurationData, dataFlavour);
    }

    public ASubsystemDescription(SubsystemDescription other) {
        super(other);
        for (ParameterDescription parameterDescription : other.getParamDescriptionSet().values()) {
            this.addParameterDescriptions(new AParameterDescription(parameterDescription));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    void setId(long id) {
        this.id = id;
    }

    @Override
    public Map<String, ? extends ParameterDescription> getParamDescriptionSet() {
        if (this.unModifiableParams.size() != this.paramDescriptions.size()) {
            this.unModifiableParams = Collections.unmodifiableMap(this.paramDescriptions);
        }
        return this.unModifiableParams;
    }

    @Override
    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.categorySet);
    }

    @Override
    public long getStartTimestamp() {
        return super.getStartTimestamp();
    }

    Collection<AParameterDescription> getParamDescriptions() {
        return this.paramDescriptions.values();
    }

    void setParamDescriptions(Map<String, AParameterDescription> paramDescriptions) {
        this.paramDescriptions = paramDescriptions;
        this.unModifiableParams = Collections.unmodifiableMap(this.paramDescriptions);
    }

    public ASubsystemDescription clone() {
        ASubsystemDescription res = null;
        try {
            res = (ASubsystemDescription)super.clone();
            HashMap<String, AParameterDescription> newMap = new HashMap<String, AParameterDescription>();
            for (AParameterDescription description : this.paramDescriptions.values()) {
                newMap.put(description.getPath().toString(), description.clone());
            }
            res.setParamDescriptions(newMap);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return res;
    }

    @Override
    public void addParameterDescriptions(ParameterDescription ... descriptions) {
        this.addParameterDescriptions(this.buildSafeArray(descriptions));
    }

    @Override
    public void addParameterDescriptions(Collection<ParameterDescription> descriptions) {
        for (ParameterDescription parm : descriptions) {
            if (!(parm instanceof AParameterDescription)) {
                this.addParameterDescriptions(new AParameterDescription(parm));
                continue;
            }
            this.addParameterDescriptions((AParameterDescription)parm);
        }
    }

    private AParameterDescription[] buildSafeArray(ParameterDescription ... descriptions) {
        List<ParameterDescription> list = Arrays.asList(descriptions);
        AParameterDescription[] parms = new AParameterDescription[descriptions.length];
        int ix = 0;
        for (ParameterDescription description : list) {
            parms[ix] = !(description instanceof AParameterDescription) ? new AParameterDescription(description) : (AParameterDescription)description;
            ++ix;
        }
        return parms;
    }

    public void addParameterDescriptions(AParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        AParameterDescription[] aParameterDescriptionArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            AParameterDescription description = aParameterDescriptionArray[n2];
            this.paramDescriptions.put(description.getPath().toString(), description);
            this.categorySet.add(description.getCategory());
            ++n2;
        }
    }

    @Override
    public void removeParameterDescriptions(ParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        ParameterDescription[] parameterDescriptionArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterDescription description = parameterDescriptionArray[n2];
            this.paramDescriptions.remove(description);
            ++n2;
        }
    }
}

