/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.FIleBasedDAO;
import org.lsst.ccs.config.remote.ConfigurationServerModule;
import org.lsst.ccs.config.remote.ConfigurationServiceImpl;
import org.lsst.ccs.framework.BasicModularSubSystem;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ConfigurationServerSystem
extends BasicModularSubSystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    private final StatusMessageListener bootStatusListener = s -> s.getOriginAgentInfo().getName();

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer");
        this.facade = facade;
        this.service = new ConfigurationServiceImpl(facade);
        this.addModule(new ConfigurationServerModule(this.service));
        this.getMessagingAccess().addStatusMessageListener(this.bootStatusListener);
    }

    public static void main(String[] args) throws Exception {
        ConfigurationFacade facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false");
        if ("true".equals(testContext.toLowerCase())) {
            facade = new ConfigurationFacade(new FIleBasedDAO());
        } else {
            String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
            DBInterface dao = (DBInterface)Class.forName(clazzName).newInstance();
            facade = new ConfigurationFacade(dao);
        }
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
        system.stayAlive();
    }
}

