/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class JythonScriptExecutor {
    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {
        Options shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");
        shellOptions.addOption("jhost", "jythonHost", true, "The host of the JythonInterpreterConsole");
        shellOptions.addOption("jport", "jythonPort", true, "The port of the JythonInterpreterConsole");
        shellOptions.addOption("submit", false, "Submit the script to a JythonInterpreterConsole");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(shellOptions, args, true);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "ScriptExecutor", "", shellOptions, "", true);
        } else {
            List script = line.getArgList();
            if (script.size() != 1) {
                throw new IllegalArgumentException("Invalid arguments " + script + " It should be the script to submit.");
            }
            String scriptPath = (String)script.get(0);
            InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
            boolean submit = line.hasOption("submit");
            if (submit) {
                int port = 4444;
                if (line.hasOption("jythonPort")) {
                    port = Integer.parseInt(line.getOptionValue("jythonPort"));
                }
                String host = "localhost";
                if (line.hasOption("jythonHost")) {
                    host = line.getOptionValue("jythonHost");
                }
                JythonConsoleSocketConnection jythonConsoleSocketConnection = new JythonConsoleSocketConnection("ScriptSubmission_" + System.currentTimeMillis(), port, host);
                jythonConsoleSocketConnection.setPrintStream(System.out);
                jythonConsoleSocketConnection.synchFileExecution(is);
                jythonConsoleSocketConnection.close();
            } else {
                JythonScriptExecutorUtils.executeScript(is);
            }
        }
        System.exit(0);
    }
}

