/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.lsst.ccs.bus.messages.BusMessage;

public abstract class BusMessageFilter
implements Predicate<BusMessage> {
    private final List<BusMessageFilter> ors = new ArrayList<BusMessageFilter>();
    private final List<BusMessageFilter> ands = new ArrayList<BusMessageFilter>();
    private boolean is = true;

    public static BusMessageFilter messageOrigin(String origin) {
        return new OriginBusMessageFilter(origin);
    }

    public static BusMessageFilter messageClass(Class clazz) {
        return new ClassBusMessageFilter(clazz);
    }

    public static BusMessageFilter messageSummary(String summary) {
        return new SummaryBusMessageFilter(summary);
    }

    public BusMessageFilter negate() {
        try {
            BusMessageFilter r = (BusMessageFilter)this.clone();
            r.is = false;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public BusMessageFilter or(BusMessageFilter filter) {
        try {
            BusMessageFilter r = (BusMessageFilter)this.clone();
            r.addOr(filter);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public BusMessageFilter and(BusMessageFilter filter) {
        try {
            BusMessageFilter r = (BusMessageFilter)this.clone();
            r.addAnd(filter);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addOr(BusMessageFilter filter) {
        this.ors.add(filter);
    }

    protected void addAnd(BusMessageFilter filter) {
        this.ands.add(filter);
    }

    public boolean accept(BusMessage busMessage) {
        boolean result = this.internalAccept(busMessage);
        if (!this.is) {
            result = !result;
        }
        for (BusMessageFilter or : this.ors) {
            boolean bl = result = result || or.accept(busMessage);
        }
        for (BusMessageFilter and : this.ands) {
            boolean bl = result = result && and.accept(busMessage);
        }
        return result;
    }

    @Override
    public boolean test(BusMessage busMessage) {
        return this.accept(busMessage);
    }

    protected abstract boolean internalAccept(BusMessage var1);

    protected abstract String internalToString();

    protected abstract BusMessageFilter internalClone();

    protected void updateClone(BusMessageFilter f) {
        for (BusMessageFilter or : this.ors) {
            f.addOr(or);
        }
        for (BusMessageFilter and : this.ands) {
            f.addAnd(and);
        }
        f.is = this.is;
    }

    protected Object clone() throws CloneNotSupportedException {
        BusMessageFilter f = this.internalClone();
        this.updateClone(f);
        return f;
    }

    public String toString() {
        String result = "(" + this.internalToString() + ")";
        if (!this.is) {
            result = "( !" + result + " )";
        }
        for (BusMessageFilter or : this.ors) {
            result = String.valueOf(result) + "||" + or.toString();
        }
        for (BusMessageFilter and : this.ands) {
            result = String.valueOf(result) + "&&" + and.toString();
        }
        return result;
    }

    private static class ClassBusMessageFilter
    extends BusMessageFilter {
        private final Class clazz;

        ClassBusMessageFilter(Class clazz) {
            this.clazz = clazz;
        }

        ClassBusMessageFilter(String clazz) {
            try {
                this.clazz = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not properly initialize BusMessage class filter", e);
            }
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            return this.clazz.isInstance(busMessage);
        }

        @Override
        protected String internalToString() {
            return " class instanceof " + this.clazz.getCanonicalName() + " ";
        }

        @Override
        protected BusMessageFilter internalClone() {
            return new ClassBusMessageFilter(this.clazz);
        }
    }

    private static class OriginBusMessageFilter
    extends BusMessageFilter {
        private final String origin;

        OriginBusMessageFilter(String origin) {
            this.origin = origin;
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            if (this.origin == null || "".equals(this.origin)) {
                return true;
            }
            return busMessage.getOriginAgentInfo().getName().equals(this.origin);
        }

        @Override
        protected String internalToString() {
            return " origin = " + this.origin + " ";
        }

        @Override
        protected BusMessageFilter internalClone() {
            return new OriginBusMessageFilter(this.origin);
        }
    }

    private static class SummaryBusMessageFilter
    extends BusMessageFilter {
        private final String summary;

        SummaryBusMessageFilter(String summary) {
            this.summary = summary;
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            if (this.summary == null || "".equals(this.summary)) {
                return true;
            }
            return busMessage.getSummary().contains(this.summary);
        }

        @Override
        protected String internalToString() {
            return " summary.contains(\"" + this.summary + "\") ";
        }

        @Override
        protected BusMessageFilter internalClone() {
            return new SummaryBusMessageFilter(this.summary);
        }
    }
}

