/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CCSVersions;
import org.lsst.ccs.bus.messages.DistributionInfo;
import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentPresenceManager
implements StatusMessageListener {
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    private final Map<AgentInfo, TimeoutTask> mapAgents = new HashMap<AgentInfo, TimeoutTask>();
    private final Map<String, DistributionInfo> distInfoMap = new HashMap<String, DistributionInfo>();
    private final Map<String, AgentInfo.AgentType> mapAgentsPDI = new HashMap<String, AgentInfo.AgentType>();
    private static final int SUSPICION_LENGTH = 3;
    private final Timer timer;
    private final boolean providesDisconnectionInformation;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.messaging.agentpresencemanager");

    public AgentPresenceManager(boolean providesDisconnectionInformation) {
        this.providesDisconnectionInformation = providesDisconnectionInformation;
        this.timer = !this.providesDisconnectionInformation ? new Timer(true) : null;
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (this.distInfoMap.get(a.getName()) == null && s instanceof HeartBeatStatus) {
            this.distInfoMap.put(a.getName(), ((HeartBeatStatus)s).getDistributionInfo());
        }
        if (this.providesDisconnectionInformation) {
            this.addAgent(a);
        } else if (s.getState().isInState((Enum)PhaseState.OFF_LINE)) {
            log.debug((Object)"remove agent on status end");
            this.removeAgent(a);
        } else if (a != null) {
            int broadCastPeriod = s instanceof HeartBeatStatus ? ((HeartBeatStatus)s).getStatusBroadcastPeriod() : -1;
            this.updateAgent(a, broadCastPeriod);
        }
    }

    private synchronized void updateAgent(AgentInfo a, int tempBroadcastPeriod) {
        int statusBroadcastPeriod;
        TimeoutTask task = this.mapAgents.get(a);
        if (task != null) {
            task.cancel();
            statusBroadcastPeriod = tempBroadcastPeriod == -1 ? task.getBroadcastPeriod() : tempBroadcastPeriod;
            task = new TimeoutTask(a, statusBroadcastPeriod);
            this.addAgent(a, task, false);
        } else {
            statusBroadcastPeriod = tempBroadcastPeriod == -1 ? 10 : tempBroadcastPeriod;
            task = new TimeoutTask(a, statusBroadcastPeriod);
            this.addAgent(a, task, true);
        }
        log.debug((Object)("resetting timer for agent " + a.getName() + " to " + statusBroadcastPeriod));
        this.timer.schedule((TimerTask)task, 3000 * statusBroadcastPeriod);
    }

    private synchronized void removeAgent(AgentInfo agent) {
        log.debug((Object)("removing agent " + agent.getName()));
        TimeoutTask t = this.mapAgents.remove(agent);
        this.distInfoMap.remove(agent.getName());
        if (t != null) {
            t.cancel();
            this.disconnecting(agent);
        } else {
            log.debug((Object)"removing agent with null timer");
        }
    }

    private synchronized void removeAgent(String agentName) {
        log.debug((Object)("removing agent " + agentName));
        AgentInfo.AgentType agentType = this.mapAgentsPDI.remove(agentName);
        this.distInfoMap.remove(agentName);
        if (agentType != null) {
            this.disconnecting(new AgentInfo(agentName, agentType));
        }
    }

    private synchronized void addAgent(AgentInfo agent, TimeoutTask task, boolean isNewAgent) {
        this.mapAgents.put(agent, task);
        if (isNewAgent) {
            this.connecting(agent);
        }
    }

    private synchronized void addAgent(AgentInfo a) {
        if (a != null && this.mapAgentsPDI.get(a.getName()) == null) {
            log.fine((Object)("adding " + a + " to the apm agent list"));
            this.mapAgentsPDI.put(a.getName(), a.getType());
            this.connecting(a);
        }
    }

    public List<AgentInfo> listAgents() {
        return this.listAgents(0);
    }

    public List<AgentInfo> listAgents(int timeout) {
        if (this.providesDisconnectionInformation) {
            ArrayList<AgentInfo> list = new ArrayList<AgentInfo>();
            Set<Map.Entry<String, AgentInfo.AgentType>> set = this.mapAgentsPDI.entrySet();
            for (Map.Entry<String, AgentInfo.AgentType> e : set) {
                list.add(new AgentInfo(e.getKey(), e.getValue()));
            }
            return list;
        }
        return new ArrayList<AgentInfo>(this.mapAgents.keySet());
    }

    private void connecting(AgentInfo agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.connecting(agent);
        }
    }

    private void disconnecting(AgentInfo agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.disconnecting(agent);
        }
    }

    void disconnecting(String agentName) {
        if (this.providesDisconnectionInformation) {
            this.removeAgent(agentName);
        }
    }

    public void anormalEvent(Exception exc) {
    }

    public void addAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.add(l);
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public boolean agentExists(String agentName) {
        for (AgentInfo a : this.listAgents()) {
            if (!a.getName().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    public DistributionInfo getAgentDistributionInfo(String agentName) {
        return this.distInfoMap.get(agentName);
    }

    public CCSVersions getCCSVersions() {
        CCSVersions ccsVersions = new CCSVersions();
        List<AgentInfo> agents = this.listAgents();
        for (AgentInfo a : agents) {
            DistributionInfo d = this.getAgentDistributionInfo(a.getName());
            if (d == null) continue;
            ccsVersions.add(a, d);
        }
        return ccsVersions;
    }

    class TimeoutTask
    extends TimerTask {
        private final AgentInfo agent;
        private final int broadcastPeriod;

        TimeoutTask(AgentInfo agent, int broadcastPeriod) {
            this.agent = agent;
            this.broadcastPeriod = broadcastPeriod;
        }

        int getBroadcastPeriod() {
            return this.broadcastPeriod;
        }

        @Override
        public void run() {
            AgentPresenceManager.this.removeAgent(this.agent);
        }
    }
}

