/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.startup.MainDescriptiveNode;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.ccs.utilities.tracers.Tracer;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.EffectiveNode;
import org.lsst.gruth.nodes.ComponentFactory;
import org.lsst.gruth.nodes.Utils;

public class BootUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !BootUtils.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", BootUtils.class, (String)"org-lsst-ccs-startup")) {
            throw new AssertionError();
        }
    }

    public static DescriptiveNode getDescriptiveNode(String pathName) throws Exception {
        InputStream is;
        DescriptiveNode componentNode = null;
        if (!pathName.endsWith(".ser") && System.getProperty("org.lsst.ccs.newfilenaming", "false").equals("true")) {
            pathName = String.valueOf(pathName) + ".groo";
            try {
                is = CommonResources.getInput(BootUtils.class, (String)pathName);
            }
            catch (IOException iOException) {
                pathName = String.valueOf(pathName) + "vy";
                is = CommonResources.getInput(BootUtils.class, (String)pathName);
            }
        } else {
            is = CommonResources.getInput(BootUtils.class, (String)pathName);
        }
        if (is == null) {
            throw new IOException(String.valueOf(pathName) + " not found through CommonResources");
        }
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (DescriptiveNode)ois.readObject();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
        }
        return componentNode;
    }

    public static EffectiveNode getEffectiveNode(DescriptiveNode descriptionNode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ComponentFactory fact = new ComponentFactory(descriptionNode);
        EffectiveNode top = fact.build();
        top.doCallsFromTop();
        return top;
    }

    public static EffectiveNode getEffectiveNodeFromFile(String pathName) throws Exception {
        DescriptiveNode descriptiveNode = BootUtils.getDescriptiveNode(pathName);
        return BootUtils.getEffectiveNode(descriptiveNode);
    }

    public static Subsystem getSubsystemFromFile(String pathName) throws Exception {
        return BootUtils.getSubsystemFromFile(pathName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName) throws Exception {
        return BootUtils.getSubsystemFromFile(pathName, propertiesFileName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName, String subsystemAlias) throws Exception {
        return new LocalBootObject(pathName, propertiesFileName, subsystemAlias).getSubsystem();
    }

    public static void saveInCache(DescriptiveNode node, String subsystemName, String configName, String tag) {
    }

    public static DescriptiveNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static void checkStaticCompatibleConfiguration(ConfigProfile profile) throws Exception {
        LocalConfigurationProxy configurationProxy = new LocalConfigurationProxy(profile);
        DescriptiveNode node = configurationProxy.getModifiedConfigurationData();
        BootUtils.getEffectiveNode(node);
    }

    public static class LocalBootObject {
        DescriptiveNode descriptiveNode;
        DescriptiveNode modifiedDescriptiveNode;
        ConfigurableSubsystem subsystem;
        private final String subsystemName;
        private final String[] taggedCategories;
        private final String tagName;

        public LocalBootObject(String pathName) throws Exception {
            this(pathName, "");
        }

        public LocalBootObject(String pathName, String config) throws Exception {
            this(pathName, config, null);
        }

        public LocalBootObject(String pathName, String config, String subsystemAlias) throws Exception {
            System.setProperty("org.lsst.ccs.newfilenaming", String.valueOf(!pathName.contains(".")).toLowerCase());
            if (config == null) {
                config = "";
            }
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            NamesAndTag namesAndTag = ConfigUtils.namesFromPaths((String)pathName, (String)config);
            if (System.getProperty("org.lsst.ccs.newfilenaming", "false").equals("false")) {
                this.subsystemName = namesAndTag.getSubsystemName();
            } else if (this.descriptiveNode instanceof MainDescriptiveNode) {
                this.subsystemName = subsystemAlias == null ? ((MainDescriptiveNode)this.descriptiveNode).getSubsystemName() : subsystemAlias;
            } else {
                throw new RuntimeException("decriptive node is not an instance of MainDescriptiveNode");
            }
            this.taggedCategories = namesAndTag.getConfigName().split(",");
            this.tagName = namesAndTag.getTag();
            CCSCst.LOG_TODO.fine((Object)"TODO: Configuration proxy should also be able to interact with remote database (switch between local and remote?)");
            this.subsystem = NodeModularSubsystem.rawSubsystemFromDescriptionNode(this.descriptiveNode, this.subsystemName, this.tagName, this.taggedCategories);
        }

        public DescriptiveNode getDescriptiveNode() {
            return this.descriptiveNode;
        }

        public DescriptiveNode getModifiedDescriptiveNode() {
            return this.modifiedDescriptiveNode;
        }

        public EffectiveNode getEffectiveNode() {
            return ((NodeModularSubsystem)this.subsystem).getEffectiveNode();
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Object getRunningObject(String key) {
            return this.getEffectiveNode().getIndirect((Object)key);
        }
    }
}

