/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting.jython;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.util.ClasspathUtilities;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.pattern.PatternUtils;
import org.python.core.PyCode;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonScriptExecutorUtils {
    public static InputStream getScriptInputStream(String script) throws FileNotFoundException {
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)script);
        if (is == null) {
            is = new FileInputStream(script);
        }
        return is;
    }

    public static void executeScript(String scriptPath) throws IOException {
        InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
        JythonScriptExecutorUtils.executeScript(is);
    }

    public static void executeScript(String scriptPath, OutputStream out) throws IOException {
        InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
        JythonScriptExecutorUtils.executeScript(is, out);
    }

    public static void executeScript(InputStream is) throws IOException {
        JythonScriptExecutorUtils.executeScript(is, (OutputStream)System.out);
    }

    public static void executeScript(InputStream is, OutputStream out) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(line).append("\n");
        }
        Properties sysProps = System.getProperties();
        sysProps.setProperty("python.packages.paths", "full.java.class.path,sun.boot.class.path,app.class.path");
        sysProps.setProperty("python.cachedir", PatternUtils.resolvePattern((String)BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.console.jython.cachedir", "%W/cachedir")));
        ClasspathUtilities.setFullSystemClasspathInSystemProperty((String)"full.java.class.path");
        PySystemState state = new PySystemState();
        PythonInterpreter pyInterpreter = new PythonInterpreter(null, state);
        pyInterpreter.setOut(out);
        pyInterpreter.setErr(out);
        try {
            PyCode code = pyInterpreter.compile(stringBuffer.toString());
            pyInterpreter.exec(code);
        }
        catch (Exception executionException) {
            throw new RuntimeException(executionException);
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JythonScriptExecutorUtils.executeScript("org/lsst/ccs/scripting/jython/sendingCommands.py", (OutputStream)out);
        System.out.println(out.toString());
    }
}

