/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.util.Arrays;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ConfigurationProxy;

public abstract class ConfigurableSubsystem
extends Subsystem {
    private ConfigurationProxy configurationProxy;

    public ConfigurableSubsystem(String name, AgentInfo.AgentType type, ConfigurationProxy configProxy) {
        super(name, type);
        this.configurationProxy = configProxy;
    }

    public String getConfiguration() {
        return this.configurationProxy.getConfigurationName();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
    }

    @Deprecated
    @Command(description="will create a new context for modifying parameters (engineering mode)", type=Command.CommandType.ACTION)
    public final synchronized void newConfigurationContext() {
    }

    @Command(description="Saves a new configuration with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveConfiguration(String ... taggedCategories) throws IOException {
        this.configurationProxy.registerConfiguration(taggedCategories);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveCategories(String ... taggedCategories) throws IOException {
        this.configurationProxy.registerCategories(taggedCategories);
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() throws Exception {
        this.getConfigurationProxy().dropUnsavedChanges();
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) throws Exception {
        this.configurationProxy.dropUnsavedChangesForCategories(Arrays.asList(categories));
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) throws Exception {
        this.configurationProxy.loadConfiguration(taggedCategories);
    }

    @Command(description="apply the configuration for the specified categories to the current configuration", type=Command.CommandType.CONFIGURATION)
    public void applyConfiguration(String ... taggedCategories) throws Exception {
        if (taggedCategories.length == 0) {
            return;
        }
        this.configurationProxy.applyConfiguration(taggedCategories);
    }
}

