/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.lsst.ccs.ActionCommandStillRunning;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.ClosingStateException;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.Alarm;
import org.lsst.ccs.bus.messages.AlarmClear;
import org.lsst.ccs.bus.messages.EncodedDataStatus;
import org.lsst.ccs.bus.messages.KVList;
import org.lsst.ccs.bus.messages.MetadataStatus;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlarmState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent {
    protected volatile boolean forceShutdown = false;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem");

    public Subsystem(String name, AgentInfo.AgentType type) {
        super(name, type);
    }

    public Logger getLogger() {
        return log;
    }

    public ThreadGroup getAncillaryGroup() {
        return this.ancillaryGroup;
    }

    @Override
    protected final boolean startAgent() {
        this.doStart();
        try {
            this.checkHardware();
            this.initialisationEndPhase(true);
        }
        catch (HardwareException e) {
            log.error((Object)"check hardware problem ", (Throwable)((Object)e));
            this.initialisationError(StackTraceFormats.toString((Throwable)((Object)e)));
            return false;
        }
        return true;
    }

    public void initialisationEndPhase(boolean checkHardwareOK) throws HardwareException {
        boolean stayAlive;
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
        }
        this.postStart();
        this.switchToNormalReady();
        if (checkHardwareOK) {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "IDLE"));
        }
        if (stayAlive = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.stayAlive", "false").toUpperCase())) {
            this.stayAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stayAlive() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.initThread) {
            log.warn((Object)(" trying to block the initialisation thread from a different thread" + currentThread + "!=  init thread :" + this.initThread));
            return;
        }
        Object object = this.initThreadMonitor;
        synchronized (object) {
            try {
                this.initThreadMonitor.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialization() throws SystemStateException, HardwareException {
        if (!this.isAgentInState((Enum)PhaseState.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.initialisationEndPhase(false);
    }

    public void postStart() throws HardwareException {
    }

    public void checkHardware() throws HardwareException {
    }

    public void checkAllHardwareStarted() throws HardwareException {
    }

    public void checkAllHardwareStopped() throws HardwareException {
    }

    @Override
    protected final void shutdownAgent() throws Exception {
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.raiseAlarm("some hardware are not stopped");
            log.error((Object)"some hardware are not stopped", (Throwable)((Object)exc));
            throw exc;
        }
        log.info((Object)"all hardware are stopped");
        this.doShutdown();
    }

    public void doStart() {
    }

    public void doShutdown() {
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.ABORT)
    public synchronized void forceShutdown() {
        this.forceShutdown = true;
        this.interruptAllRunningCommands();
        this.interruptAncillaryThreads(".*");
        this.notifyAll();
    }

    @Command(description="halt hardware", type=Command.CommandType.ABORT)
    public void abort() {
        log.info((Object)("Subsystem " + this.getName() + " halt requested"));
    }

    @Command(description="halt hardware with expected max delay", type=Command.CommandType.ABORT)
    public void abort(long expectedMaxDelay) {
        log.info((Object)("Subsystem " + this.getName() + " halt requested"));
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        log.info((Object)("Subsystem " + this.getName() + " stop requested"));
    }

    synchronized void initialisationError(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        this.updateAgentState(message, new Enum[]{OperationalState.ENGINEERING_FAULT, AlarmState.ALARM});
    }

    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public synchronized boolean switchToEngineeringMode() {
        if (this.isAgentInState((Enum)OperationalState.NORMAL)) {
            this.updateAgentState(null, new Enum[]{OperationalState.ENGINEERING_OK});
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public synchronized void switchToNormalMode() throws SystemStateException {
        if (this.getAgentState(AlarmState.class).compareTo(AlarmState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        this.updateAgentState(null, new Enum[]{CommandState.READY, OperationalState.NORMAL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateAgentState(message, new Enum[]{OperationalState.ENGINEERING_FAULT, AlarmState.ALARM});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void warning(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateAgentState(message, new Enum[]{AlarmState.WARNING});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="clear alarms", type=Command.CommandType.QUERY)
    public synchronized void clearAlarms(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateAgentState(message, new Enum[]{OperationalState.ENGINEERING_OK, AlarmState.NOMINAL});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="tries to switch to READY ", type=Command.CommandType.QUERY)
    public synchronized void tryReadyState(String message) throws SystemStateException {
        if (this.getCurrentActionThread() != null) {
            throw new ActionCommandStillRunning();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        if (this.getAgentState(PhaseState.class).compareTo(PhaseState.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        this.updateAgentState(null, new Enum[]{CommandState.READY});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(description="tries to wait until READY ", type=Command.CommandType.QUERY)
    public synchronized boolean waitForReadyState() throws ClosingStateException {
        while (this.getCurrentActionThread() != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            while (this.listSignalThreads.size() != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        if (this.getAgentState(PhaseState.class).compareTo(PhaseState.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        this.updateAgentState(null, new Enum[]{CommandState.READY});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForCommandExecution(long timeOut) {
        Object object = this.commandMonitor;
        synchronized (object) {
            while (this.waitingForCommandTermination) {
                try {
                    this.commandMonitor.wait(timeOut);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }

    public void registerAsBusMaster() {
    }

    public void publishMetaData(String dataname, String metadataname, String value) {
        MetadataStatus mst = new MetadataStatus(dataname, metadataname, value);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)mst);
    }

    protected void publishStatusData(EncodedDataStatus dataStatus) {
        StatusMessage status = this.fillStatus((StatusMessage)dataStatus);
        this.getMessagingAccess().sendStatusMessage(status);
    }

    public void publishStatus(long timestamp, String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(timestamp, key, value));
    }

    public void publishStatus(String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(key, value));
    }

    public void publishStatus(long timestamp, KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(timestamp, kvlist));
    }

    public void publishStatus(KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(kvlist));
    }

    public void publishStatus(String key, long[] timestamps, Object[] objects) {
        if (timestamps.length != objects.length) {
            throw new IllegalArgumentException("arrays in parameter do not have same size");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("empty publication request (empty array)");
        }
        int length = timestamps.length;
        EncodedDataStatus res = null;
        EncodedDataStatus current = null;
        int ix = length - 1;
        while (ix >= 0) {
            res = new EncodedDataStatus(timestamps[ix], key, objects[ix]);
            res.setNext(current);
            current = res;
            --ix;
        }
        this.publishStatusData(res);
    }

    public void sendRawStatus(StatusMessage status) {
        this.fillStatus(status);
        this.getMessagingAccess().sendStatusMessage(status);
    }

    @Command(description="set the level of the BusLogHandler", type=Command.CommandType.QUERY)
    public void setBusLogHandlerLevel(String levelName) {
        if (this.logBusHandler != null) {
            Level level = Level.parse(levelName);
            this.logBusHandler.setLevel(level);
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY)
    public void setLogHandlerLevel(String handler, String level) {
        if (handler.equals("LogBusHandler")) {
            if (this.logBusHandler != null) {
                Level newLevel = Level.parse(level);
                this.logBusHandler.setLevel(newLevel);
            }
        } else {
            Handler[] handlers;
            java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
            Handler[] handlerArray = handlers = rootLogger.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h.getClass().getSimpleName().equals(handler)) {
                    Level newLevel = Level.parse(level);
                    h.setLevel(newLevel);
                    break;
                }
                ++n2;
            }
        }
    }

    @Command(description="tries to stop the panic state of logmanagement", type=Command.CommandType.QUERY)
    public void removeLogPanicState() {
        if (this.logBusHandler != null) {
            this.logBusHandler.setPanicState(false);
        }
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        int res = this.activeThreads.get();
        return res - 1;
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Object[] threads = new Thread[this.commandGroup.activeCount()];
        this.commandGroup.enumerate((Thread[])threads);
        return Arrays.toString(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt for all command threads (behaviour of commands are implementation dependent)", type=Command.CommandType.ABORT)
    public synchronized void interruptAllRunningCommands() {
        Thread currentThread = Thread.currentThread();
        Object object = this.actionMonitor;
        synchronized (object) {
            Object object2 = this.signalsMonitor;
            synchronized (object2) {
                Thread[] threads = new Thread[this.commandGroup.activeCount()];
                this.commandGroup.enumerate(threads);
                Thread[] threadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    if (thread.isAlive() && !thread.equals(currentThread)) {
                        try {
                            thread.interrupt();
                        }
                        catch (Exception exc) {
                            log.warn((Object)(exc + "thrown during interruption"));
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    @Command(description="sends an interrupt to a running ACTION thread", type=Command.CommandType.ABORT)
    public synchronized void interruptActionThread() {
        log.debug((Object)"interrupting action thread");
        Thread thread = this.getCurrentActionThread();
        try {
            thread.interrupt();
        }
        catch (Exception exc) {
            log.warn((Object)(exc + "thrown during interruption"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt to all running SIGNAL  threads", type=Command.CommandType.ABORT)
    public synchronized void interruptAllSignalThreads() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            for (Agent.SignalThread signalThread : this.signalThreadsIterable) {
                if (signalThread == Thread.currentThread()) continue;
                try {
                    signalThread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"));
                }
            }
        }
    }

    @Command(description="sends an interrupt to any 'ancillary' thread whose name matches the regular expression passed as argument", type=Command.CommandType.ABORT)
    public void interruptAncillaryThreads(String expReg) {
        Thread[] threads = new Thread[this.ancillaryGroup.activeCount()];
        this.ancillaryGroup.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            String name = thread.getName();
            if (name.matches(expReg) && thread.isAlive()) {
                try {
                    thread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"));
                }
            }
            ++n2;
        }
    }

    @Command(description="sends an interrupt to the initialization thread", type=Command.CommandType.ABORT)
    public synchronized void interruptInitThread() {
        if (this.initThread != null && this.initThread.isAlive()) {
            try {
                this.initThread.interrupt();
            }
            catch (Exception exc) {
                log.warn((Object)(exc + "thrown during interruption"));
            }
        }
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        this.broadcastStatus(this.getStatusBroadcastPeriod());
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.getMessagingAccess().getAgentPresenceManager();
    }
}

