/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.AlarmOnStateChange;
import org.lsst.ccs.bus.messages.CCSVersions;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.DistributionInfo;
import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.bus.messages.StateChangeNotification;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlarmState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.LogBusHandler;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.network.NetworkUtils;
import org.lsst.ccs.utilities.tracers.Names;

public class Agent
implements CommandExecutor {
    private final AgentInfo agentInfo;
    private final String name;
    private static final Logger log;
    private InnerAgentMessagingLayer messagingAccess;
    private static volatile AgentMessagingLayer environmentAgentMessagingLayer;
    private final HashMap<String, CommandSet> commandSetMap = new HashMap();
    protected final AtomicInteger activeThreads = new AtomicInteger(0);
    protected boolean startInEngineeringMode = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.startInEngineeringMode", "false").toUpperCase());
    protected Thread currentActionThread;
    public static final ThreadLocal<CurrentCommandContext> LOCAL_EXECUTION_INFO;
    protected Thread initThread;
    protected ThreadGroup ancillaryGroup;
    protected Object initThreadMonitor = new Object();
    protected final Object signalsMonitor = new Object();
    protected final Object actionMonitor = new Object();
    protected final Object commandMonitor = new Object();
    private StateBundle innerState = new StateBundle(new Enum[0]);
    private final Object innerStateLock = new Object();
    private volatile int statusBroadcastPeriod = 5;
    private volatile Thread statusBroadcasterThread = null;
    private final Object statusBroadcasterLock = new Object();
    ArrayList<SignalThread> listSignalThreads = new ArrayList();
    protected LogBusHandler logBusHandler;
    protected ThreadGroup commandGroup;
    protected volatile boolean waitingForCommandTermination;
    protected Iterable<SignalThread> signalThreadsIterable = new Iterable<SignalThread>(){

        @Override
        public Iterator<SignalThread> iterator() {
            return new Iterator(){
                Iterator<SignalThread> inIterator;
                SignalThread nextThread;
                {
                    this.inIterator = (this).Agent.this.listSignalThreads.iterator();
                    this.nextThread = this.getNext();
                }

                @Override
                public boolean hasNext() {
                    return this.nextThread != null;
                }

                public SignalThread next() {
                    SignalThread res = this.nextThread;
                    this.nextThread = this.getNext();
                    return res;
                }

                SignalThread getNext() {
                    if (this.inIterator.hasNext()) {
                        SignalThread coming = this.inIterator.next();
                        if (!coming.isAlive()) {
                            this.inIterator.remove();
                            (this).Agent.this.activeThreads.getAndDecrement();
                            return this.getNext();
                        }
                        return coming;
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    };

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs");
        environmentAgentMessagingLayer = null;
        LOCAL_EXECUTION_INFO = new ThreadLocal();
    }

    public Agent(String name, AgentInfo.AgentType agentType) {
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_", "BUILD"));
        switch (agentType) {
            case LISTENER: 
            case CONSOLE: {
                name = Names.almostUniqueAgentName((String)name);
                break;
            }
        }
        this.agentInfo = new AgentInfo(name, agentType);
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + name, "BUS CONNECTIONS"));
        this.name = name;
        this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
        this.commandGroup = new ThreadGroup(name){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error((Object)("uncaught exception on command thread: " + t.getName() + "{" + e + "}"), e);
            }
        };
    }

    private synchronized void setEnvironmentMessagingAccess(AgentMessagingLayer layer) {
        if (environmentAgentMessagingLayer == null) {
            environmentAgentMessagingLayer = layer;
        } else if (BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false").equals("false")) {
            throw new RuntimeException("*** Should not have two agents running in same JVM");
        }
    }

    public static AgentMessagingLayer getEnvironmentMessagingAccess() {
        if (environmentAgentMessagingLayer == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgentMessagingLayer;
    }

    private void connectToTheBuses() {
        if (this.messagingAccess == null) {
            this.messagingAccess = new InnerAgentMessagingLayer(this.agentInfo);
            this.setEnvironmentMessagingAccess(this.messagingAccess);
            this.initLogBusHandler();
        }
    }

    public String getName() {
        return this.name;
    }

    public AgentMessagingLayer getMessagingAccess() {
        if (this.messagingAccess == null) {
            this.connectToTheBuses();
        }
        return this.messagingAccess;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    protected void initLogBusHandler() {
        if (this.logBusHandler == null) {
            java.util.logging.Logger generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
            this.logBusHandler = new LogBusHandler((AgentMessagingLayer)this.messagingAccess);
            generalLogger.addHandler((Handler)this.logBusHandler);
        }
    }

    public void start() {
        log.info((Object)("running on MAC " + NetworkUtils.getEthHardAddress()));
        this.addCommandSet("", new CommandSetBuilder().buildCommandSet((Object)this));
        this.connectToTheBuses();
        ((InnerAgentMessagingLayer)this.getMessagingAccess()).innerSetCommandExecutor(this);
        this.updateAgentState("Starting the subsystem", new Enum[]{PhaseState.INITIALIZING, CommandState.READY, OperationalState.ENGINEERING_OK, AlarmState.NOMINAL});
        this.startStatusBroadcasting();
        this.initThread = Thread.currentThread();
        this.ancillaryGroup = new ThreadGroup(this.initThread.getThreadGroup(), String.valueOf(this.getName()) + "'s ancillary");
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "INITIALIZATION"));
        boolean startupOk = this.startAgent();
        if (startupOk) {
            this.switchToNormalReady();
        }
    }

    protected boolean startAgent() {
        return true;
    }

    public boolean isStartedInEngineeringMode() {
        return this.startInEngineeringMode;
    }

    protected void switchToNormalReady() {
        this.waitForSignalThreads(-1);
        if (!this.isStartedInEngineeringMode()) {
            this.updateAgentState(null, new Enum[]{PhaseState.OPERATIONAL, CommandState.READY, OperationalState.NORMAL, AlarmState.NOMINAL});
        } else {
            this.updateAgentState(null, new Enum[]{PhaseState.OPERATIONAL, CommandState.READY, AlarmState.NOMINAL});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForSignalThreads(int maxTries) {
        Object object = this.signalsMonitor;
        synchronized (object) {
            int nbTries = 0;
            block5: while (this.listSignalThreads.size() > 0) {
                if (maxTries - nbTries++ <= 0) break;
                long currentTime = System.currentTimeMillis();
                for (SignalThread interruptThread : this.signalThreadsIterable) {
                    if (interruptThread.getMaxDueTime() <= currentTime) continue;
                    try {
                        this.signalsMonitor.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue block5;
                    }
                }
            }
        }
    }

    public void addCommandSet(String name, CommandSet commandSet) {
        String tmpName = this.getName();
        if (name.isEmpty() || name.equals("main")) {
            name = tmpName;
            CompositeCommandSet cmdSet = this.commandSetMap.containsKey(name) ? (CompositeCommandSet)this.commandSetMap.get(name) : new CompositeCommandSet();
            cmdSet.add(commandSet);
            commandSet = cmdSet;
        } else {
            name = String.valueOf(tmpName) + "/" + name.replace("main/", "");
        }
        this.commandSetMap.put(name, commandSet);
    }

    protected CommandSet getCommandSet(String name) {
        return this.commandSetMap.get(name);
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public HashMap<String, Dictionary> getSystemDictionary() {
        HashMap<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
        for (String name : this.commandSetMap.keySet()) {
            dictionaries.put(name, this.commandSetMap.get(name).getCommandDictionary());
        }
        return dictionaries;
    }

    @Command(description="Get the CCS Versions for the current CCS Environment", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public CCSVersions getCCSVersions() {
        CCSVersions versions = this.getMessagingAccess().getAgentPresenceManager().getCCSVersions();
        versions.add(this.getAgentInfo(), new DistributionInfo());
        return versions;
    }

    protected boolean isAgentInState(Enum state) {
        return this.innerState.isInState(state);
    }

    protected boolean isAgentInState(StateBundle state) {
        return this.innerState.isInState(state);
    }

    protected Enum getAgentState(Class stateClass) {
        return this.innerState.getState(stateClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAgentState(String extraInfo, Enum ... stateChanges) {
        Object object = this.innerStateLock;
        synchronized (object) {
            StateBundle newState = this.innerState.mergeState(new StateBundle(stateChanges));
            this.publishStateChange(extraInfo, this.innerState, newState);
            this.innerState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusMessage fillStatus(StatusMessage s) {
        Object object = this.innerStateLock;
        synchronized (object) {
            s.setState(this.innerState.clone());
            return s;
        }
    }

    private HeartBeatStatus createHeartBeat() {
        HeartBeatStatus s = new HeartBeatStatus(this.statusBroadcastPeriod);
        this.updateHeartBeat(s);
        return s;
    }

    protected void updateHeartBeat(HeartBeatStatus s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (statusBroadcastPeriod < 1) {
                this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
                log.info((Object)("broadcast period should be 1 or above. set to " + this.getDefaultBroadcastingPeriod()));
            } else {
                this.statusBroadcastPeriod = statusBroadcastPeriod;
            }
            this.startStatusBroadcasting();
        }
    }

    protected int getDefaultBroadcastingPeriod() {
        if (this.agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            return 1;
        }
        return 5;
    }

    public int getStatusBroadcastPeriod() {
        return this.statusBroadcastPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (this.statusBroadcasterThread == null) {
                StatusBroadcaster run = new StatusBroadcaster();
                this.statusBroadcasterThread = new Thread((Runnable)run, String.valueOf(this.name) + "-broadcast");
                this.statusBroadcasterThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            while (true) {
                if (this.statusBroadcasterThread == null) {
                    return;
                }
                if (this.statusBroadcasterThread != null) {
                    this.statusBroadcasterThread.interrupt();
                }
                try {
                    this.statusBroadcasterLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void broadcastStatus(int statusBroadcastPeriod) {
        HeartBeatStatus s = this.createHeartBeat();
        this.fillStatus((StatusMessage)s);
        this.messagingAccess.sendStatusMessage((StatusMessage)s);
    }

    protected void publishStateChange(String extraInfo, StateBundle before, StateBundle after) {
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StateChangeNotification(before, after));
        Enum alarm = after.getState(AlarmState.class);
        if (alarm != null && alarm.compareTo(AlarmState.WARNING) >= 0) {
            AlarmOnStateChange alarmOnStateChange = new AlarmOnStateChange(before, after);
            alarmOnStateChange.setSummary(extraInfo);
            this.getMessagingAccess().sendStatusMessage((StatusMessage)alarmOnStateChange);
        }
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInEngineeringMode() {
        Enum em = this.getAgentState(OperationalState.class);
        return em != null && em.compareTo(OperationalState.ENGINEERING_OK) >= 0;
    }

    @Command(description="shutdown", type=Command.CommandType.ACTION)
    public final Object shutdown() throws Exception {
        log.info((Object)("Agent " + this.getName() + " shutdown starting"));
        this.updateAgentState(null, new Enum[]{PhaseState.CLOSING});
        this.shutdownAgent();
        final Thread shutdownCommandThread = Thread.currentThread();
        final boolean createShutdownThreadAndJoinOnCurrentThread = shutdownCommandThread.getThreadGroup() == this.commandGroup;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + Agent.this.getName(), "END PHASE"));
                log.info((Object)"shutdown background thread started");
                if (createShutdownThreadAndJoinOnCurrentThread) {
                    try {
                        shutdownCommandThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn((Object)("Subsystem " + Agent.this.getName() + " shutdown interrupt"));
                    }
                }
                log.info((Object)"shutdown background thread is active :the initial shutdown command completed");
                log.info((Object)("Subsystem " + Agent.this.getName() + " shutdown completed [bus access going to close]"));
                if (Agent.this.logBusHandler != null) {
                    Agent.this.logBusHandler.close();
                }
                if (Agent.this.initThread != null && Agent.this.initThread.isAlive()) {
                    Object object = Agent.this.initThreadMonitor;
                    synchronized (object) {
                        Agent.this.initThreadMonitor.notifyAll();
                    }
                }
                Agent.this.terminateShutdown();
            }
        };
        if (createShutdownThreadAndJoinOnCurrentThread) {
            Thread endThread = new Thread(this.commandGroup, runnable, "EndThread");
            endThread.start();
        } else {
            runnable.run();
        }
        return "OK";
    }

    private void terminateShutdown() {
        this.stopStatusBroadcasting();
        this.updateAgentState(null, new Enum[]{PhaseState.OFF_LINE});
        this.messagingAccess.innerShutdownBusAccess();
    }

    protected void shutdownAgent() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommandRequest(final CommandRequest m) {
        Object objDestination;
        boolean notTopCommand;
        log.debug((Object)("Agent got command " + m));
        if (this.isAgentInState((Enum)PhaseState.OFF_LINE)) {
            CommandNack ack = new CommandNack(m, (Object)"can't accept command : state is Off", m.getCommandOriginatorId());
            log.debug((Object)("sending nack " + ack));
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            return;
        }
        boolean bl = notTopCommand = !m.getDestination().endsWith("/main") && m.getDestination().contains("/");
        if (notTopCommand && this.getAgentState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
            CommandNack ack = new CommandNack(m, (Object)"can't access lower level component (not named \"main\") if not in ENGINEERING MODE", m.getCommandOriginatorId());
            log.debug((Object)("sending nack " + ack));
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            return;
        }
        DictionaryCommand dictionaryCommand = null;
        Exception ex = null;
        try {
            dictionaryCommand = this.getCommandSet(m.getDestination()).getCommandDictionary().findCommand(m.getBasicCommand());
        }
        catch (Exception exc) {
            dictionaryCommand = null;
            ex = exc;
        }
        if (dictionaryCommand == null) {
            if (ex == null) {
                ex = new RuntimeException("Could Not find command " + m.getBasicCommand());
            }
            CommandNack ack = new CommandNack(m, (Object)ex.toString(), m.getCommandOriginatorId());
            log.debug((Object)("sending nack on third " + ack));
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            throw new RuntimeException(ex);
        }
        Object object = objDestination = this instanceof CCSProxy ? ((CCSProxy)((Object)this)).getDelegate() : this;
        if (objDestination instanceof Configurable) {
            objDestination = ((Configurable)objDestination).getEnvironment().getRelevantObject();
        }
        final Command.CommandType type = dictionaryCommand.getType();
        final CurrentCommandContext execInfo = new CurrentCommandContext(m.getOriginAgentInfo().getName(), m.getBasicCommand().getCommand(), type, m.getBasicCommand().getArguments());
        switch (type) {
            case QUERY: {
                CommandAck ack = new CommandAck(m, m.getCommandOriginatorId());
                log.debug((Object)(" QUERY: sending ack " + ack));
                this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf(type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        block2: {
                            LOCAL_EXECUTION_INFO.set(execInfo);
                            result = null;
                            Agent.this.getCommandSet(m.getDestination());
                            try {
                                result = Agent.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                            }
                            catch (Throwable e) {
                                Throwable th;
                                log.debug((Object)("QUERY exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e);
                                result = e;
                                if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                result = th;
                            }
                        }
                        Agent.this.endOfCommand();
                        CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                        log.debug((Object)("QUERY reply will be sent  " + reply));
                        Agent.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                    }
                };
                Thread queryThread = this.createThread(m, runnable, threadName);
                this.activeThreads.getAndIncrement();
                queryThread.start();
                break;
            }
            case CONFIGURATION: {
                if (this.getAgentState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                    CommandNack nack = new CommandNack(m, (Object)"Configuration commands are accepted only in active ENGINEERING mode", m.getCommandOriginatorId());
                    log.debug((Object)("sending nack " + nack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
            }
            case ACTION: {
                if (!this.isAgentInState((Enum)CommandState.READY)) {
                    CommandNack nack = null;
                    Thread thread = this.getCurrentActionThread();
                    if (thread != null) {
                        nack = new CommandNack(m, (Object)(String.valueOf(thread.getName()) + " still running"), m.getCommandOriginatorId());
                    }
                    if (nack == null) {
                        Object runnable = this.signalsMonitor;
                        synchronized (runnable) {
                            if (this.listSignalThreads.size() != 0) {
                                nack = new CommandNack(m, (Object)(String.valueOf(m.getBasicCommand().getCommand()) + " Action or Configuration commands are accepted only if no interruption is running -> " + this.listSignalThreads), m.getCommandOriginatorId());
                            }
                        }
                        if (nack == null) {
                            nack = new CommandNack(m, (Object)(String.valueOf(m.getBasicCommand().getCommand()) + " Action or Configuration commands are accepted only if CommandState is READY"), m.getCommandOriginatorId());
                        }
                    }
                    log.debug((Object)(type + " sending nack " + nack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                Object nack = this.actionMonitor;
                synchronized (nack) {
                    if (!this.testAndSetReadyToActive()) {
                        CommandNack nack2 = new CommandNack(m, (Object)" not ready", m.getCommandOriginatorId());
                        log.debug((Object)(type + " sending nack " + nack2));
                        this.getMessagingAccess().sendCommandReply((CommandReply)nack2);
                        return;
                    }
                    CommandAck ack = new CommandAck(m, (Object)this.getAgentInfo(), m.getCommandOriginatorId());
                    log.debug((Object)(type + " sending ack " + ack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                    String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf(type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object result;
                            block5: {
                                LOCAL_EXECUTION_INFO.set(execInfo);
                                result = null;
                                try {
                                    result = Agent.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                                }
                                catch (Throwable e) {
                                    Throwable th;
                                    log.debug((Object)(type + " exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e);
                                    result = e;
                                    if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block5;
                                    result = th;
                                }
                            }
                            Object e = Agent.this.actionMonitor;
                            synchronized (e) {
                                Agent.this.currentActionThread = null;
                                Agent.this.backToReadyFromActive();
                                Agent.this.endOfCommand();
                            }
                            CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                            log.debug((Object)(type + " reply will be sent  " + reply));
                            Agent.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                        }
                    };
                    Thread actionThread = this.createThread(m, runnable, threadName);
                    this.activeThreads.getAndIncrement();
                    this.currentActionThread = actionThread;
                    actionThread.start();
                    break;
                }
            }
            case ABORT: {
                Object expectedMaxDelay;
                long dueTime;
                long currentTime = dueTime = System.currentTimeMillis();
                DictionaryArgument[] arguments = dictionaryCommand.getArguments();
                if (arguments.length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                    String argAsString = String.valueOf(m.getBasicCommand().getArguments()[0]);
                    expectedMaxDelay = new Long(argAsString);
                    dueTime = currentTime + (Long)expectedMaxDelay;
                }
                boolean timeOverdue = false;
                expectedMaxDelay = this.signalsMonitor;
                synchronized (expectedMaxDelay) {
                    long registeredDueTime = Long.MAX_VALUE;
                    for (SignalThread interruptThread : this.signalThreadsIterable) {
                        long max = interruptThread.getMaxDueTime();
                        if (max >= registeredDueTime) continue;
                        registeredDueTime = max;
                    }
                    if (dueTime > registeredDueTime) {
                        timeOverdue = true;
                    }
                }
                if (timeOverdue) {
                    CommandNack nack = new CommandNack(m, (Object)" interruption with shorter time span running", m.getCommandOriginatorId());
                    log.debug((Object)(type + " sending nack " + nack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                Object object2 = this.signalsMonitor;
                synchronized (object2) {
                    this.switchToRunningSignalsState();
                    CommandAck ack = new CommandAck(m, (Object)this.getAgentInfo(), m.getCommandOriginatorId());
                    log.debug((Object)(type + " sending ack " + ack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                    String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf(type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Object result;
                            block2: {
                                LOCAL_EXECUTION_INFO.set(execInfo);
                                result = null;
                                try {
                                    result = Agent.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                                }
                                catch (Throwable e) {
                                    Throwable th;
                                    log.debug((Object)(type + " exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e);
                                    result = e;
                                    if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                    result = th;
                                }
                            }
                            Agent.this.backFromRunningSignal(Thread.currentThread());
                            Agent.this.endOfCommand();
                            CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                            log.debug((Object)(type + "  reply will be sent  " + reply));
                            Agent.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                        }
                    };
                    SignalThread signalThread = new SignalThread(this.commandGroup, runnable, threadName, dueTime);
                    this.activeThreads.getAndIncrement();
                    this.listSignalThreads.add(signalThread);
                    signalThread.start();
                    break;
                }
            }
            default: {
                assert (false) : "command with unlikely type :" + type;
                break;
            }
        }
    }

    private String nameThread(String commandOriginator, String correlID, String commandType, String commandName, Object[] parameters) {
        String threadName = String.format("%s [%s] -> %s: %s %s", commandOriginator, correlID, commandType, commandName, Arrays.toString(parameters));
        return threadName;
    }

    private Thread createThread(final CommandRequest cmd, Runnable runnable, String threadName) {
        Thread res = new Thread(this.commandGroup, runnable, threadName);
        res.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CommandError reply = new CommandError(cmd, e, cmd.getCommandOriginatorId());
                try {
                    Agent.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                }
                catch (Throwable th) {
                    log.error((Object)("uncaught exception Handler of " + cmd + "can't reply"), th);
                }
            }
        });
        return res;
    }

    private synchronized boolean switchToRunningSignalsState() {
        if (this.isAgentInState((Enum)CommandState.READY)) {
            this.updateAgentState(null, new Enum[]{CommandState.ACTIVE});
            return true;
        }
        return this.isAgentInState((Enum)CommandState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean backFromRunningSignal(Thread thread) {
        if (this.isAgentInState((Enum)CommandState.ACTIVE)) {
            Object object = this.signalsMonitor;
            synchronized (object) {
                block7: {
                    this.listSignalThreads.remove(thread);
                    CommandState cmdState = null;
                    if (this.listSignalThreads.size() != 0) break block7;
                    cmdState = CommandState.READY;
                    if (this.getCurrentActionThread() != null) {
                        cmdState = CommandState.ACTIVE;
                    }
                    if (!this.isAgentInState((Enum)cmdState)) {
                        this.updateAgentState(null, new Enum[]{cmdState});
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean backToReadyFromActive() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            block4: {
                if (this.listSignalThreads.size() != 0) break block4;
                this.updateAgentState(null, new Enum[]{CommandState.READY});
                return true;
            }
            log.warn((Object)"signals running : unable to go back to READY");
            return false;
        }
    }

    private synchronized boolean testAndSetReadyToActive() {
        if (this.isAgentInState((Enum)CommandState.READY)) {
            this.updateAgentState(null, new Enum[]{CommandState.ACTIVE});
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOfCommand() {
        this.activeThreads.getAndDecrement();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.commandMonitor;
        synchronized (object) {
            this.waitingForCommandTermination = false;
            this.commandMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Thread getCurrentActionThread() {
        Object object = this.actionMonitor;
        synchronized (object) {
            if (this.currentActionThread != null && !this.currentActionThread.isAlive()) {
                this.currentActionThread = null;
                this.activeThreads.getAndDecrement();
            }
        }
        return this.currentActionThread;
    }

    class InnerAgentMessagingLayer
    extends AgentMessagingLayer {
        InnerAgentMessagingLayer(AgentInfo agentInfo) {
            super(agentInfo);
        }

        void innerShutdownBusAccess() {
            super.shutdownBusAccess();
        }

        synchronized void innerSetCommandExecutor(CommandExecutor executor) {
            super.setCommandExecutor(executor);
        }
    }

    public static class SignalThread
    extends Thread {
        long maxDueTime;

        public SignalThread(ThreadGroup group, Runnable target, final String name, long maxDueTime) {
            super(group, target, name);
            this.maxDueTime = maxDueTime;
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.error((Object)(String.valueOf(name) + " signal Thread"), e);
                }
            });
        }

        public long getMaxDueTime() {
            return this.maxDueTime;
        }

        public void extendDuration(long millis) {
            this.maxDueTime = this.maxDueTime < Long.MAX_VALUE - millis ? (this.maxDueTime += millis) : Long.MAX_VALUE;
        }
    }

    protected class StatusBroadcaster
    implements Runnable {
        protected StatusBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + Agent.this.name, "STATUS BROADCASTING"));
            try {
                try {
                    while (true) {
                        Agent.this.broadcastStatus(Agent.this.statusBroadcastPeriod);
                        int period = Agent.this.statusBroadcastPeriod;
                        Thread.sleep(1000L * (long)period);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = Agent.this.statusBroadcasterLock;
                    synchronized (object) {
                        Agent.this.statusBroadcasterThread = null;
                        Agent.this.statusBroadcasterLock.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = Agent.this.statusBroadcasterLock;
                synchronized (object) {
                    Agent.this.statusBroadcasterThread = null;
                    Agent.this.statusBroadcasterLock.notifyAll();
                }
                throw throwable;
            }
        }
    }
}

