/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

public class RuntimeInfo
implements Serializable {
    public final int nThreads;
    public final long maxMemory = Runtime.getRuntime().maxMemory();
    public final long totalMemory;
    public final long freeMemory;
    public final double processCpuLoad;
    public final double systemCpuLoad;
    public static OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    public static Runtime runtime = Runtime.getRuntime();

    public RuntimeInfo() {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public int hashCode() {
        int hash = 5;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeInfo other = (RuntimeInfo)obj;
        if (this.nThreads != other.nThreads) {
            return false;
        }
        if (this.maxMemory != other.maxMemory) {
            return false;
        }
        if (this.totalMemory != other.totalMemory) {
            return false;
        }
        if (this.freeMemory != other.freeMemory) {
            return false;
        }
        if (Double.doubleToLongBits(this.processCpuLoad) != Double.doubleToLongBits(other.processCpuLoad)) {
            return false;
        }
        return Double.doubleToLongBits(this.systemCpuLoad) == Double.doubleToLongBits(other.systemCpuLoad);
    }
}

