/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationState;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.MemoryDAO;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.RollBackException;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.functions.Cocoon;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.types.TypeUtils;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    static int level = 10;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final ASubsystemDescription subsystemDescription;
    private final String subsystemName;
    private final String tagName;
    private ConfigurationState configState;
    private final Map<String, AConfigProfile> configProfileMap = new HashMap<String, AConfigProfile>();
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");
    private ComponentLookupService lookup;
    private WriterProvider writerProvider = new WriterProvider(){

        @Override
        public PrintWriter getPrintWriter(String baseName) throws IOException {
            String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)baseName);
            if (pathInBootstrap == null) {
                String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
                if (topMostUserDirectory == null) {
                    String workdir = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.workdir", "");
                    if (!workdir.isEmpty() && !workdir.endsWith(FILE_SEPARATOR)) {
                        workdir = String.valueOf(workdir) + FILE_SEPARATOR;
                    }
                    baseName = String.valueOf(workdir) + baseName;
                } else {
                    baseName = String.valueOf(topMostUserDirectory) + baseName;
                }
            } else {
                baseName = pathInBootstrap;
            }
            if (!baseName.endsWith(".properties")) {
                baseName = String.valueOf(baseName) + ".properties";
            }
            LocalConfigurationProxy.this.logger.info((Object)("Saving configuration  to " + baseName));
            return new PrintWriter(baseName, "ISO-8859-1");
        }

        @Override
        public Properties getConfigurationProperties(String configFileName) throws IOException {
            if (!configFileName.endsWith(".properties")) {
                configFileName = String.valueOf(configFileName) + ".properties";
            }
            Properties configProps = new Properties();
            InputStream propsIs = null;
            propsIs = BootstrapResourceUtils.getBootstrapResource((String)configFileName);
            if (propsIs == null) {
                throw new IllegalArgumentException("Could not find configuration file : " + configFileName);
            }
            configProps.load(propsIs);
            return configProps;
        }
    };

    public LocalConfigurationProxy(SubsystemDescription subsystemDesc) {
        this.subsystemDescription = (ASubsystemDescription)subsystemDesc;
        this.subsystemName = this.subsystemDescription.getSubsystemName();
        this.tagName = this.subsystemDescription.getTag();
        if (System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")) {
            this.writerProvider = InMemoryWriterProvider.getInstance();
        }
    }

    public LocalConfigurationProxy(ConfigProfile configProfile) {
        this(configProfile.getSubsystemDescription());
        this.configProfileMap.put(configProfile.getCategoryName(), (AConfigProfile)configProfile);
    }

    public DescriptiveNode initializeConfigProfile(String ... taggedCategories) {
        DescriptiveNode modifiedDescriptiveNode = this.subsystemDescription.getTopComponentNode();
        CCSCst.LOG_TODO.fine((Object)"TODO: DAO at creation of SubsystemDescription should also be able to interact with remote database (switch between local and remote?)");
        MemoryDAO dao = new MemoryDAO();
        dao.saveAbstractDescription(this.subsystemDescription);
        this.configState = new ConfigurationState(this.subsystemName, this.tagName, this.subsystemDescription.getCategorySet()).mergeWith(taggedCategories);
        for (Map.Entry<String, String> entry : this.configState.getTags().entrySet()) {
            AConfigProfile newConfigProfile = new AConfigProfile(this.subsystemDescription, this.subsystemDescription.getUser(), 10, entry.getKey(), entry.getValue());
            Properties configProps = this.loadPropertiesForCat(entry.getKey(), entry.getValue());
            if (configProps != null) {
                try {
                    this.readPropertiesAndMerge(configProps, newConfigProfile);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    List<String> messages = newConfigProfile.reportFailures();
                    throw new IllegalArgumentException(" configuration errors :" + messages);
                }
            }
            this.configProfileMap.put(newConfigProfile.getCategoryName(), newConfigProfile);
        }
        modifiedDescriptiveNode = this.getModifiedConfigurationData();
        return modifiedDescriptiveNode;
    }

    public void setLookup(ComponentLookupService lookup) {
        this.lookup = lookup;
    }

    public synchronized String getConfigurationName() {
        return this.configState.getTagsString();
    }

    public synchronized String getTagName() {
        return this.subsystemDescription.getTag();
    }

    @Deprecated
    public synchronized void startNewConfigurationContext() {
    }

    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        if (parameterDescription == null) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.subsystemName);
        }
        if (parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
        Object res = parameterDescription.checkValue(strValue);
        return new ViewValue(strValue, res);
    }

    public synchronized void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), value, true);
        this.configState.setCatChanged(category);
    }

    public synchronized void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), strValue, false);
        this.configState.setCatChanged(category);
    }

    public synchronized void registerConfiguration(String ... taggedCategories) throws IOException {
        this.configState.mergeWith(taggedCategories);
        this.registerCategories(this.configState.getTagsAsArray());
    }

    public synchronized void registerCategories(String ... taggedCategories) throws IOException {
        Map<String, String> categoryMap = ConfigurationState.parseConfigurationString(this.subsystemDescription.getCategorySet(), taggedCategories);
        this.saveModifications(taggedCategories);
        for (Map.Entry<String, String> taggedCategory : categoryMap.entrySet()) {
            PrintWriter printWriter = this.writerProvider.getPrintWriter(ConfigUtils.baseNameFromNames(this.subsystemName, taggedCategory.getValue(), this.tagName, taggedCategory.getKey()));
            for (ParameterConfiguration parameterConfiguration : this.configProfileMap.get(taggedCategory.getKey()).getModifiedParameters()) {
                boolean commentOut = parameterConfiguration.getValue().equals(parameterConfiguration.getDescription().getDefaultValue());
                printWriter.println(parameterConfiguration.getDescription().toPropertyString(parameterConfiguration.getValue(), commentOut));
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    private synchronized void saveModifications(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        this.configState.mergeWith(taggedCategories);
        Map<String, String> categories = ConfigurationState.parseConfigurationString(this.subsystemDescription.getCategorySet(), taggedCategories);
        for (Map.Entry<String, String> entry : categories.entrySet()) {
            AConfigProfile oldProfile = this.configProfileMap.get(entry.getKey());
            AConfigProfile newProfile = new AConfigProfile(oldProfile, "", 10, false, entry.getValue());
            this.configProfileMap.put(entry.getKey(), newProfile);
            this.configState.setCatUnchanged(entry.getKey());
        }
    }

    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName();
        Object res = Constraints.check(type, strValue, null);
        return res;
    }

    private synchronized Properties loadPropertiesForCat(String categoryName, String configName) {
        Properties props;
        block3: {
            props = new Properties();
            try {
                props.putAll((Map<?, ?>)this.writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames(this.subsystemName, configName, this.tagName, categoryName)));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (configName.equals("")) break block3;
                throw ex;
            }
        }
        return props;
    }

    public void setWriterProvider(WriterProvider writerProvider) {
        this.writerProvider = writerProvider;
    }

    public WriterProvider getWriterProvider() {
        return this.writerProvider;
    }

    public void loadConfiguration(String ... taggedCategories) throws Exception {
        this.configState = new ConfigurationState(this.subsystemName, this.tagName, this.subsystemDescription.getCategorySet()).mergeWith(taggedCategories);
        for (Map.Entry<String, String> entry : this.configState.getTags().entrySet()) {
            Properties configProps = this.loadPropertiesForCat(entry.getKey(), entry.getValue());
            AConfigProfile newConfigProfile = new AConfigProfile(this.subsystemDescription, this.subsystemDescription.getUser(), 10, entry.getKey(), entry.getValue());
            if (configProps != null) {
                try {
                    this.readPropertiesAndMerge(configProps, newConfigProfile);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    List<String> messages = newConfigProfile.reportFailures();
                    throw new IllegalArgumentException(" configuration errors :" + messages);
                }
            }
            this.switchConfiguration(this.configProfileMap.get(entry.getKey()), newConfigProfile);
            this.configProfileMap.put(newConfigProfile.getCategoryName(), newConfigProfile);
        }
        this.saveModifications(this.configState.getTagsAsArray());
    }

    public void applyConfiguration(String ... taggedCategories) throws Exception {
        if (taggedCategories.length == 0) {
            return;
        }
        Map<String, String> taggedCategoriesMap = ConfigurationState.parseConfigurationString(this.subsystemDescription.getCategorySet(), taggedCategories);
        for (Map.Entry<String, String> entry : taggedCategoriesMap.entrySet()) {
            Properties configProps = this.loadPropertiesForCat(entry.getKey(), entry.getValue());
            AConfigProfile newConfigProfile = new AConfigProfile(this.subsystemDescription, this.subsystemDescription.getUser(), 10, entry.getKey(), entry.getValue());
            if (configProps != null) {
                try {
                    this.readPropertiesAndMerge(configProps, newConfigProfile);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    List<String> messages = newConfigProfile.reportFailures();
                    throw new IllegalArgumentException(" configuration errors :" + messages);
                }
            }
            this.switchConfiguration(this.configProfileMap.get(entry.getKey()), newConfigProfile);
            this.configProfileMap.put(newConfigProfile.getCategoryName(), newConfigProfile);
        }
        this.saveModifications(taggedCategories);
    }

    public void dropUnsavedChanges() throws Exception {
        this.dropUnsavedChangesForCategories(this.subsystemDescription.getCategorySet());
    }

    public void dropUnsavedChangesForCategories(Collection<String> categories) throws Exception {
        if (categories.isEmpty()) {
            return;
        }
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        Map<String, List<ParameterConfiguration>> oldMap = this.getConfigurationMapForCat(new HashSet<String>(categories));
        mainModule.proceduralWalk(null, Cocoon.consumer(configurable -> {
            String name = configurable.getName();
            List<ParameterConfiguration> oldList = (List<ParameterConfiguration>)oldMap.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            for (ParameterConfiguration parmConfig : oldList) {
                if (!categories.contains(parmConfig.getDescription().getCategory())) continue;
                ParameterPath path = parmConfig.getPath();
                String parameterName = path.getParameterName();
                String value = parmConfig.getValue();
                if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                    throw new IllegalArgumentException(path + "not modifiable at runtime");
                }
                configurable.change(parameterName, (Object)value);
            }
        }));
        ArrayList<String> taggedCategories = new ArrayList<String>();
        for (String cat : categories) {
            String tagForCat = this.configState.getTagForCat(cat);
            taggedCategories.add(cat.isEmpty() ? "" : String.valueOf(cat) + ":" + tagForCat);
        }
        this.saveModifications(taggedCategories.toArray(new String[0]));
    }

    public void switchConfiguration(ConfigProfile oldProfile, ConfigProfile newProfile) throws Exception {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        Map<String, List<ParameterConfiguration>> newChanges = newProfile.getConfigurationMap();
        Map<String, List<ParameterConfiguration>> oldMap = oldProfile.getConfigurationMap();
        ArrayList changedValues = new ArrayList();
        mainModule.proceduralWalk(null, Cocoon.consumer(arg_0 -> this.lambda$1(newChanges, oldMap, oldProfile, changedValues, arg_0)));
    }

    private void readPropertiesAndMerge(Properties props, ConfigProfile configProfile) {
        boolean exceptionThrown = false;
        Map<String, ParameterDescription> map = this.subsystemDescription.generateDescriptionMapForCat(new HashSet<String>(Arrays.asList(configProfile.getCategoryName())));
        for (String name : props.stringPropertyNames()) {
            ParameterDescription description = map.get(name);
            if (description != null) {
                String value = props.getProperty(name);
                try {
                    configProfile.updateParameterConfiguration(description, value);
                }
                catch (Exception exception) {
                    exceptionThrown = true;
                }
                continue;
            }
            this.logger.warn((Object)("The property " + name + " does not belong to the category specified by the property file name"));
        }
        if (exceptionThrown) {
            throw new IllegalArgumentException("Some parameters were not modifiable, invoke getReConfigurationFailures");
        }
    }

    public ConfigProfile getProfileForCat(String categoryName) {
        return this.configProfileMap.get(categoryName);
    }

    private Map<String, List<ParameterConfiguration>> getConfigurationMapForCat(Set<String> categories) {
        HashMap<String, List<ParameterConfiguration>> res = new HashMap<String, List<ParameterConfiguration>>();
        for (ParameterConfiguration parameterConfiguration : this.getParameterConfigurationsForCat(categories)) {
            ParameterPath path = parameterConfiguration.getPath();
            String component = path.getComponentName();
            ArrayList<ParameterConfiguration> presentList = (ArrayList<ParameterConfiguration>)res.get(component);
            if (presentList == null) {
                presentList = new ArrayList<ParameterConfiguration>();
                res.put(component, presentList);
            }
            presentList.add(parameterConfiguration);
        }
        return res;
    }

    private Set<AParameterConfiguration> getParameterConfigurationsForCat(Set<String> categories) {
        HashSet<AParameterConfiguration> res = new HashSet<AParameterConfiguration>();
        for (String category : categories) {
            res.addAll(this.getParameterConfigurationsForCat(category));
        }
        return res;
    }

    private Set<AParameterConfiguration> getParameterConfigurationsForCat(String category) {
        return this.configProfileMap.get(category).getParameterConfigurations();
    }

    public DescriptiveNode getModifiedConfigurationData() {
        DescriptiveNode res = null;
        DescriptiveNode componentNode = this.subsystemDescription.getTopComponentNode();
        componentNode = componentNode.clone();
        for (AParameterConfiguration parameterConfiguration : this.getParameterConfigurationsForCat(this.subsystemDescription.getCategorySet())) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode)componentNode.getNodeByName(componentName);
            if (goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName);
            }
            Map mapAttributes = goalComponent.getAttributes();
            if (mapAttributes == null) {
                throw new IllegalArgumentException("incompatible attribute list for component/parameter " + componentName + "/" + parameterName);
            }
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked((Object)parameterConfiguration.getValue());
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        res = componentNode;
        return res;
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$1(Map var1_1, Map var2_2, ConfigProfile var3_3, List var4_4, Configurable configurable) throws Exception {
        block11: {
            name = configurable.getName();
            newList = (List)var1_1.get(name);
            oldList = (List<T>)var2_2.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            try {
                if (newList != null) {
                    for (ParameterConfiguration parmConfig : newList) {
                        oldList.remove(parmConfig);
                        path = parmConfig.getPath();
                        parameterName = path.getParameterName();
                        value = parmConfig.getValue();
                        oldValue = var3_3.getValueAt(path, PackCst.STILL_VALID);
                        if (oldValue.equals(value)) continue;
                        if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                            throw new IllegalArgumentException(path + "not modifiable at runtime");
                        }
                        histElement = new String[]{name, parameterName, oldValue};
                        configurable.change(parameterName, (Object)value);
                        var4_4.add(0, histElement);
                    }
                }
                for (ParameterConfiguration parmConfig : oldList) {
                    path = parmConfig.getPath();
                    parameterName = path.getParameterName();
                    defaultValue = parmConfig.getDescription().getDefaultValue();
                    oldValue = var3_3.getValueAt(path, PackCst.STILL_VALID);
                    if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                        throw new IllegalArgumentException(path + "not modifiable at runtime");
                    }
                    histElement = new String[]{name, parameterName, oldValue};
                    configurable.change(parameterName, (Object)defaultValue);
                    var4_4.add(0, histElement);
                }
                break block11;
            }
            catch (Exception exc) {
                ** for (historyElement : var4_4)
            }
lbl-1000:
            // 1 sources

            {
                cpName = historyElement[0];
                parmName = historyElement[1];
                histValue = historyElement[2];
                try {
                    cp = (Configurable)this.lookup.getComponentByName(cpName);
                    cp.change(parmName, (Object)histValue);
                    continue;
                }
                catch (Exception rollbackExc) {
                    throw new RollBackException(rollbackExc, cpName, parmName, histValue);
                }
            }
lbl45:
            // 1 sources

            throw exc;
        }
    }

    public static interface WriterProvider {
        public PrintWriter getPrintWriter(String var1) throws IOException;

        public Properties getConfigurationProperties(String var1) throws IOException;
    }
}

