/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigurationState
implements Serializable {
    private final Set<String> categories = new HashSet<String>();
    private final String subsystemName;
    private final String tagName;
    private final Map<String, String> tags = new HashMap<String, String>();
    private final Map<String, Boolean> changes = new HashMap<String, Boolean>();

    public ConfigurationState(String subsystemName, String tagName, Set<String> categories) {
        this.categories.addAll(categories);
        this.subsystemName = subsystemName;
        this.tagName = tagName;
        for (String cat : categories) {
            this.tags.put(cat, "");
            this.changes.put(cat, false);
        }
    }

    public ConfigurationState(ConfigurationState configState) {
        this(configState.subsystemName, configState.tagName, configState.categories);
        this.tags.putAll(configState.tags);
    }

    public String getTagForCat(String cat) {
        return this.tags.get(cat);
    }

    public ConfigurationState mergeWith(String ... configInput) {
        this.tags.putAll(ConfigurationState.parseConfigurationString(this.categories, configInput));
        return this;
    }

    public void mergeWith(ConfigurationState state) {
        this.tags.putAll(state.getTags());
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public String toString() {
        String res = String.valueOf(this.tagName) + "[";
        res = String.valueOf(res) + this.getTagsString() + "]";
        return res;
    }

    public String getTagsString() {
        String res = "";
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            boolean hasChanges = this.changes.get(entry.getKey());
            res = String.valueOf(res) + (entry.getKey().isEmpty() ? "" : String.valueOf(entry.getKey()) + ":") + entry.getValue() + (hasChanges ? "*" : "") + ",";
        }
        if (!res.isEmpty()) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public String[] getTagsAsArray() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            res.add(String.valueOf(entry.getKey().isEmpty() ? "" : String.valueOf(entry.getKey()) + ":") + entry.getValue());
        }
        return res.toArray(new String[0]);
    }

    public static Map<String, String> parseConfigurationString(Set<String> categorySet, String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] stringArray = configNames;
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.isEmpty()) {
                res.put("", "");
            } else if (!s.contains(":")) {
                res.put("", s);
            } else {
                String[] keyVal = s.split(":", -1);
                if (keyVal.length != 2) {
                    throw new IllegalArgumentException("configuration " + keyVal.length);
                }
                if (!categorySet.contains(keyVal[0])) {
                    throw new IllegalArgumentException("unexisting category " + keyVal[0]);
                }
                res.put(keyVal[0], keyVal[1]);
            }
            ++n2;
        }
        return res;
    }

    public static Map<String, String> rawParseConfigurationString(String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] stringArray = configNames;
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.isEmpty()) {
                res.put("", "");
            } else if (!s.contains(":")) {
                res.put("", s);
            } else {
                String[] keyVal = s.split(":", -1);
                if (keyVal.length != 2) {
                    throw new IllegalArgumentException("configuration " + keyVal.length);
                }
                res.put(keyVal[0], keyVal[1]);
            }
            ++n2;
        }
        return res;
    }

    public void setCatChanged(String cat) {
        this.changes.put(cat, true);
    }

    public void setCatUnchanged(String cat) {
        this.changes.put(cat, false);
    }

    public boolean hasChanges() {
        for (boolean b : this.changes.values()) {
            if (!b) continue;
            return true;
        }
        return false;
    }
}

