<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0" xml:space="preserve">
	<xsl:template match="modules">
		<beans xmlns="http://www.springframework.org/schema/beans"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
			xmlns:context="http://www.springframework.org/schema/context"
			xsi:schemaLocation="
http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd			
http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context-2.5.xsd
"
			default-init-method="init">
			
			<context:annotation-config/>  
			
			<bean name="context" id="context" class="org.lsst.ccs.framework.Context">
				<property name="subsystemName" value="{@name}" />
			</bean>
						 
			<bean name="guard" id="guard" class="org.lsst.ccs.framework.ConstraintAspect">
				<property name="context">
				<ref bean="context" />
			</property>
			
			</bean>
			 
			<xsl:apply-templates />
						
			
		</beans>
	</xsl:template>
	<xsl:template match="module">
		<bean name="{@name}" id="{@name}" class="{@class}">
			<xsl:apply-templates select="property" />
			<property name="observables">
				<list>
					<xsl:apply-templates select="listens" />
				</list>
			</property>
			<property name="context">
				<ref bean="context" />
			</property>
		</bean>
	</xsl:template>
	
	<xsl:template match="bean">
		<xsl:copy-of select="." />
	</xsl:template>
	
	
	<xsl:template match="listens">
		<ref bean="{@source}" />

<!-- value><xsl:value-of select="@source"/></value> -->
	</xsl:template>
	<xsl:template match="property">
		<xsl:copy-of select="." />
	</xsl:template>
</xsl:stylesheet>