/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.logging.LogPropertiesLoader;
import org.lsst.ccs.utilities.tracers.Tracer;

public class Logger {
    private java.util.logging.Logger julDelegate;
    protected ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread res = new Thread(r, "LoggerDelayedExecutor");
            res.setDaemon(true);
            return res;
        }
    });
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !Logger.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version("$Rev$", Logger.class, "org-lsst-ccs-utilities")) {
            throw new AssertionError();
        }
        LogPropertiesLoader.getSystemLoaderLogManager();
    }

    private Logger(java.util.logging.Logger delegate) {
        this.julDelegate = delegate;
        Optional<LogManager> optManager = LogPropertiesLoader.getSystemLoaderLogManager();
        if (optManager.isPresent()) {
            LogManager manager = optManager.get();
            manager.addLogger(delegate);
        }
    }

    public static Logger getLogger(String name) {
        java.util.logging.Logger realLogger = java.util.logging.Logger.getLogger(name);
        return new Logger(realLogger);
    }

    public static Logger getLogger(String name, String resourceBundleName) {
        java.util.logging.Logger realLogger = java.util.logging.Logger.getLogger(name, resourceBundleName);
        return new Logger(realLogger);
    }

    public String getName() {
        return this.julDelegate.getName();
    }

    public Level getLevel() {
        return this.julDelegate.getLevel();
    }

    public void setLevel(Level level) {
        this.julDelegate.setLevel(level);
    }

    protected java.util.logging.Logger getParent() {
        return this.julDelegate.getParent();
    }

    public LogRecord createLogRecord(Level level, String message) {
        StackTraceElement[] stackTraceElements;
        LogRecord res = new LogRecord(level, message);
        StackTraceElement[] stackTraceElementArray = stackTraceElements = Thread.currentThread().getStackTrace();
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName;
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String className = stackTraceElement.getClassName();
            if (!(className.startsWith("org.lsst.ccs.utilities.logging") || className.startsWith("org.apache.log4j") || className.contains(".logging.") || "getStackTrace".equals(methodName = stackTraceElement.getMethodName()))) {
                res.setSourceClassName(className);
                res.setSourceMethodName(methodName);
                break;
            }
            ++n2;
        }
        return res;
    }

    @Deprecated
    protected boolean logMessage(Level level, Object message, String ... concerns) {
        return this.logMessage(level, message);
    }

    protected boolean logMessage(Level level, Object message) {
        String msg = String.valueOf(message);
        LogRecord record = this.createLogRecord(level, msg);
        this.log(record);
        return true;
    }

    @Deprecated
    public boolean finest(Object message, String ... concerns) {
        return this.finest(message);
    }

    public boolean finest(Object message) {
        return this.logMessage(Level.FINEST, message);
    }

    @Deprecated
    public boolean trace(Object message, String ... concerns) {
        return this.trace(message);
    }

    public boolean trace(Object message) {
        return this.logMessage(Level.FINER, message);
    }

    @Deprecated
    public boolean finer(Object message, String ... concerns) {
        return this.finer(message);
    }

    public boolean finer(Object message) {
        return this.logMessage(Level.FINER, message);
    }

    @Deprecated
    public boolean debug(Object message, String ... concerns) {
        return this.debug(message);
    }

    public boolean debug(Object message) {
        return this.logMessage(Level.FINE, message);
    }

    @Deprecated
    public boolean fine(Object message, String ... concerns) {
        return this.fine(message);
    }

    public boolean fine(Object message) {
        return this.logMessage(Level.FINE, message);
    }

    @Deprecated
    public boolean info(Object message, String ... concerns) {
        return this.info(message);
    }

    public boolean info(Object message) {
        return this.logMessage(Level.INFO, message);
    }

    @Deprecated
    public boolean warn(Object message, String ... concerns) {
        return this.warn(message);
    }

    public boolean warn(Object message) {
        return this.logMessage(Level.WARNING, message);
    }

    @Deprecated
    public boolean warning(Object message, String ... concerns) {
        return this.warning(message);
    }

    public boolean warning(Object message) {
        return this.logMessage(Level.WARNING, message);
    }

    @Deprecated
    public void error(Object message, String ... concerns) {
        this.error(message);
    }

    public void error(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    @Deprecated
    public void fatal(Object message, String ... concerns) {
        this.fatal(message);
    }

    public void fatal(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    @Deprecated
    public void severe(Object message, String ... concerns) {
        this.severe(message);
    }

    public void severe(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    public boolean isDebugEnabled() {
        return this.julDelegate.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julDelegate.isLoggable(Level.INFO);
    }

    @Deprecated
    protected void logSimpleThrowable(Level level, Object message, Throwable throwable, String ... concerns) {
        this.logSimpleThrowable(level, message, throwable);
    }

    protected void logSimpleThrowable(Level level, Object message, Throwable throwable) {
        String msg = String.valueOf(message);
        LogRecord record = this.createLogRecord(level, msg);
        record.setThrown(throwable);
        this.log(record);
    }

    @Deprecated
    public void fatal(Object message, Throwable throwable, String ... concerns) {
        this.fatal(message, throwable);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    @Deprecated
    public void severe(Object message, Throwable throwable, String ... concerns) {
        this.severe(message, throwable);
    }

    public void severe(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    @Deprecated
    public void error(Object message, Throwable throwable, String ... concerns) {
        this.error(message, throwable);
    }

    public void error(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    @Deprecated
    public void warn(Object message, Throwable throwable, String ... concerns) {
        this.warn(message, throwable);
    }

    public void warn(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.WARNING, message, throwable);
    }

    @Deprecated
    public void warning(Object message, Throwable throwable, String ... concerns) {
        this.warning(message, throwable);
    }

    public void warning(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.WARNING, message, throwable);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable throwable) {
        this.julDelegate.throwing(sourceClass, sourceMethod, throwable);
    }

    @Deprecated
    public void info(Object message, Throwable throwable, String ... concerns) {
        this.info(message, throwable);
    }

    public void info(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.INFO, message, throwable);
    }

    @Deprecated
    public void debug(Object message, Throwable throwable, String ... concerns) {
        this.debug(message, throwable);
    }

    public void debug(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.FINE, message, throwable);
    }

    public boolean isLoggable(Level level) {
        return this.julDelegate.isLoggable(level);
    }

    @Deprecated
    public void log(LogRecord record, String ... concerns) {
        this.log(record);
    }

    public void log(LogRecord record) {
        record.setLoggerName(this.julDelegate.getName());
        this.julDelegate.log(record);
    }

    @Deprecated
    public void decoupledLog(long delay, LogRecord record, String ... concerns) {
        this.decoupledLog(delay, record);
    }

    public void decoupledLog(long delay, final LogRecord record) {
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                Logger.this.log(record);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public boolean log(Level level, String message, Object argument, String ... concerns) {
        return this.log(level, message, argument);
    }

    public boolean log(Level level, String message, Object argument) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(new Object[]{argument});
        this.log(record);
        return true;
    }

    @Deprecated
    public boolean decoupledLog(long delay, Level level, String message, Object argument, String ... concerns) {
        return this.decoupledLog(delay, level, message, argument);
    }

    public boolean decoupledLog(long delay, Level level, String message, Object argument) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(new Object[]{argument});
        this.decoupledLog(delay, record);
        return true;
    }

    @Deprecated
    public boolean log(Level level, String message, Object[] arguments, String ... concerns) {
        return this.log(level, message, arguments);
    }

    public boolean log(Level level, String message, Object[] arguments) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(arguments);
        this.log(record);
        return true;
    }

    @Deprecated
    public boolean decoupledLog(long delay, Level level, String message, Object[] arguments, String ... concerns) {
        return this.decoupledLog(delay, level, message, arguments);
    }

    public boolean decoupledLog(long delay, Level level, String message, Object[] arguments) {
        LogRecord record = this.createLogRecord(level, message);
        record.setParameters(arguments);
        this.decoupledLog(delay, record);
        return true;
    }

    @Deprecated
    public void log(Level level, String message, Throwable throwable, String ... concerns) {
        this.log(level, message, throwable);
    }

    public void log(Level level, String message, Throwable throwable) {
        LogRecord record = this.createLogRecord(level, message);
        record.setThrown(throwable);
        this.log(record);
    }

    @Deprecated
    public void decoupledLog(long delay, Level level, String message, Throwable throwable, String ... concerns) {
        this.decoupledLog(delay, level, message, throwable);
    }

    public void decoupledLog(long delay, Level level, String message, Throwable throwable) {
        LogRecord record = this.createLogRecord(level, message);
        record.setThrown(throwable);
        this.decoupledLog(delay, record);
    }
}

