/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;

@Entity
@Table(name="statdata")
public class StatData {
    static Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    private long id;
    private StatDesc descr;
    private long tstampFirst;
    private long tstampLast;
    private double data;
    private double sum2;
    private int n;
    private double min;
    private double max;

    public StatData() {
    }

    public StatData(StatDesc d) {
        this.descr = d;
    }

    public StatData(StatDesc d, RawData x) {
        log.info("new StatData from " + d + " and " + x);
        log.info(String.valueOf(x.getTstamp()) + " " + x.getDoubleData());
        this.descr = d;
        this.data = x.getDoubleData();
        this.sum2 = this.data * this.data;
        this.min = this.data;
        this.max = this.data;
        this.n = 1;
        this.tstampFirst = x.getTstamp();
        this.tstampLast = x.getTstamp();
    }

    @Transient
    public double getSum() {
        return this.getData() * (double)this.getN();
    }

    public void setSum(double s) {
        this.setData(s / (double)this.getN());
    }

    @Transient
    public double getRMS() {
        return Math.sqrt(this.getSum2() / (double)this.getN() - this.getData() * this.getData());
    }

    public void accumulate(RawData x) {
        double sum = this.getSum();
        double d = x.getDoubleData();
        sum += d;
        this.setSum2(this.getSum2() + d * d);
        if (this.getN() == 0 || d > this.max) {
            this.max = d;
        }
        if (this.getN() == 0 || d < this.min) {
            this.min = d;
        }
        this.setN(this.getN() + 1);
        this.setSum(sum);
        this.setTstampLast(x.getTstamp());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    public StatDesc getDescr() {
        return this.descr;
    }

    public void setDescr(StatDesc descr) {
        this.descr = descr;
    }

    @Column(name="tstampmills1")
    public long getTstampFirst() {
        return this.tstampFirst;
    }

    public void setTstampFirst(long tstampFirst) {
        this.tstampFirst = tstampFirst;
    }

    @Column(name="tstampmills2")
    public long getTstampLast() {
        return this.tstampLast;
    }

    public void setTstampLast(long tstampLast) {
        this.tstampLast = tstampLast;
    }

    public double getData() {
        return this.data;
    }

    public void setData(double data) {
        this.data = data;
    }

    public double getSum2() {
        return this.sum2;
    }

    public void setSum2(double sum2) {
        this.sum2 = sum2;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }
}

