/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationInfo
implements Serializable {
    private static final Pattern pattern = Pattern.compile("([a-zA-Z0-9-_]++)(\\[(.+)\\])?");
    private final String descriptionName;
    private final String tagName;
    private final String fullConfigurationName;
    private final boolean hasLocalChanges;
    private final Map<String, String> tags = new HashMap<String, String>();

    public ConfigurationInfo(String fullConfigurationName) {
        this.fullConfigurationName = fullConfigurationName;
        this.hasLocalChanges = fullConfigurationName.contains("*");
        Matcher m = pattern.matcher(fullConfigurationName);
        if (!m.matches()) {
            throw new IllegalArgumentException("Full Configuration Name " + fullConfigurationName + " does not match the conventional standard.");
        }
        this.descriptionName = m.group(1);
        String string = this.tagName = m.group(3) != null ? m.group(3) : "";
        if (!this.tagName.isEmpty()) {
            StringTokenizer st = new StringTokenizer(this.tagName, ",");
            while (st.hasMoreTokens()) {
                String tag = st.nextToken();
                if (!tag.contains(":")) {
                    tag = ":" + tag;
                }
                int index = tag.indexOf(":");
                this.tags.put(tag.substring(0, index), tag.substring(index + 1));
            }
        }
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getFullConfigurationName() {
        return this.fullConfigurationName;
    }

    public boolean hasLocalChanges() {
        return this.hasLocalChanges;
    }

    public String getTagForCategory(String category) {
        return this.tags.get(category);
    }

    public boolean hasCategory(String category) {
        return this.tags.containsKey(category);
    }

    public Set<String> getCategorySet() {
        return this.tags.keySet();
    }

    public String toString() {
        return "FullConfigurationName: " + this.getFullConfigurationName() + " Description " + this.getDescriptionName() + " Tag " + this.getTagName();
    }
}

