/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.utils;

import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRejectedException;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.utilities.dispatch.InvocationDispenser;
import org.lsst.ccs.utilities.dispatch.Invoker;

public class SynchronousCommandAgent {
    private InvocationDispenser dispenser = new InvocationDispenser();
    private final AgentMessagingLayer agentMessagingLayer;
    public static final Logger CURLOG = Logger.getLogger("org.lsst.ccs.core.bus.utils");
    Invoker dummyInvoker = new Invoker(){

        public Object invoke(Object ... args) throws Exception {
            return args[0];
        }
    };
    Invoker dumpInvoker = new Invoker(){

        public Object invoke(Object ... args) throws Exception {
            CURLOG.log(Level.INFO, " async command return " + Arrays.toString(args));
            return null;
        }
    };
    private boolean getAckOnly = false;

    private CommandOriginator generateCommandOriginator() {
        CommandOriginator commandOriginator = new CommandOriginator(){

            public void processError(CommandError error) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void processNack(CommandNack nack) {
                String correlId = nack.getCorrelId();
                CommandRejectedException rejection = new CommandRejectedException(nack);
                if (SynchronousCommandAgent.this.dispenser.isTokenUsed(correlId)) {
                    try {
                        SynchronousCommandAgent.this.dispenser.callBack(correlId, new Object[]{rejection});
                    }
                    catch (Exception e) {
                        CURLOG.log(Level.SEVERE, "", e);
                    }
                }
            }

            public void processResult(CommandResult result) {
                if (SynchronousCommandAgent.this.getAckOnly) {
                    return;
                }
                String correlId = result.getCorrelId();
                if (SynchronousCommandAgent.this.dispenser.isTokenUsed(correlId)) {
                    Object res = result.getReply();
                    try {
                        SynchronousCommandAgent.this.dispenser.callBack(correlId, new Object[]{res});
                    }
                    catch (Exception e) {
                        CURLOG.log(Level.SEVERE, "", e);
                    }
                }
            }

            public void processAck(CommandAck ack) {
                if (SynchronousCommandAgent.this.getAckOnly) {
                    String correlId = ack.getCorrelId();
                    if (SynchronousCommandAgent.this.dispenser.isTokenUsed(correlId)) {
                        try {
                            SynchronousCommandAgent.this.dispenser.callBack(correlId, new Object[]{ack});
                        }
                        catch (Exception e) {
                            CURLOG.log(Level.SEVERE, "", e);
                        }
                    }
                }
            }
        };
        return commandOriginator;
    }

    public SynchronousCommandAgent(AgentMessagingLayer fac) {
        this.agentMessagingLayer = fac;
    }

    public Object invoke(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(false, command, millisTimeout);
    }

    private Object invokeIt(boolean ackOnly, CommandRequest command, long millisTimeout) throws Exception {
        this.getAckOnly = ackOnly;
        String correlId = command.getCorrelId();
        Future future = this.dispenser.registerFuture(correlId, this.dummyInvoker);
        this.agentMessagingLayer.sendCommandRequest(command, this.generateCommandOriginator());
        Object res = null;
        try {
            res = future.get(millisTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exc) {
            this.dispenser.dumpTask(correlId);
            throw exc;
        }
        if (res instanceof Exception) {
            throw (Exception)res;
        }
        return res;
    }

    public Object getAckForCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(true, command, millisTimeout);
    }

    public Future<Object> invokeFuture(CommandRequest command) {
        String correlId = command.getCorrelId();
        Future future = this.dispenser.registerFuture(correlId, this.dummyInvoker);
        this.agentMessagingLayer.sendCommandRequest(command, this.generateCommandOriginator());
        return future;
    }

    public String invokeAsync(CommandRequest command) {
        String correlId = command.getCorrelId();
        this.dispenser.register(correlId, this.dumpInvoker);
        this.agentMessagingLayer.sendCommandRequest(command, this.generateCommandOriginator());
        return correlId;
    }
}

