/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Level;
import org.lsst.ccs.ActionCommandStillRunning;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.AlarmState;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.ClosingStateException;
import org.lsst.ccs.CommandState;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.InvocationListener;
import org.lsst.ccs.InvocationVetoException;
import org.lsst.ccs.Mode;
import org.lsst.ccs.Phase;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.Alarm;
import org.lsst.ccs.bus.messages.AlarmClear;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.EncodedDataStatus;
import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.bus.messages.KVList;
import org.lsst.ccs.bus.messages.MetadataStatus;
import org.lsst.ccs.bus.messages.PublishedState;
import org.lsst.ccs.bus.messages.StatusForEnd;
import org.lsst.ccs.bus.messages.StatusForStart;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent
implements CommandExecutor {
    static String revision = "$Rev: 34014 $";
    protected ThreadGroup commandGroup;
    protected ThreadGroup ancillaryGroup;
    AtomicInteger activeThreads = new AtomicInteger(0);
    Thread currentActionThread;
    protected final Object actionMonitor = new Object();
    protected final Object commandMonitor = new Object();
    protected volatile boolean waitingForCommandTermination;
    ArrayList<SignalThread> listSignalThreads = new ArrayList();
    Iterable<SignalThread> signalThreadsIterable = new Iterable<SignalThread>(){

        @Override
        public Iterator<SignalThread> iterator() {
            return new Iterator(){
                Iterator<SignalThread> inIterator;
                SignalThread nextThread;
                {
                    this.inIterator = (this).Subsystem.this.listSignalThreads.iterator();
                    this.nextThread = this.getNext();
                }

                @Override
                public boolean hasNext() {
                    return this.nextThread != null;
                }

                public SignalThread next() {
                    SignalThread res = this.nextThread;
                    this.nextThread = this.getNext();
                    return res;
                }

                SignalThread getNext() {
                    if (this.inIterator.hasNext()) {
                        SignalThread coming = this.inIterator.next();
                        if (!coming.isAlive()) {
                            this.inIterator.remove();
                            (this).Subsystem.this.activeThreads.getAndDecrement();
                            return this.getNext();
                        }
                        return coming;
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    };
    protected final Object signalsMonitor = new Object();
    protected Thread initThread;
    Object initThreadMonitor = new Object();
    protected volatile boolean forceShutdown = false;
    protected static Logger log;
    protected String commandBusSelector = null;
    protected String statusBusSelector = null;
    protected boolean inTestContext = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false").toUpperCase());
    protected boolean startInEngineeringMode = this.inTestContext && "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.startInEngineeringMode", "false").toUpperCase());
    protected ConfigurationProxy configurationProxy = ConfigurationProxy.NONE;
    String configuration = "";
    String tag = "";
    public static final ThreadLocal<CurrentCommandContext> LOCAL_EXECUTION_INFO;
    static MethodHandles.Lookup lookup;
    private final HashMap<String, CommandSet> commandSetMap = new HashMap();

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        LOCAL_EXECUTION_INFO = new ThreadLocal();
        lookup = MethodHandles.lookup();
    }

    public Subsystem(String name, AgentInfo.AgentType type) {
        super(name, type);
        this.configurationProxy.setSubsystem(this);
        this.commandGroup = new ThreadGroup(name){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error((Object)("uncaught exception on command thread: " + t.getName() + "{" + e + "}"), e, new String[]{"CMD"});
            }
        };
    }

    public static String getSoftwareRevision() {
        return revision;
    }

    public Agent.State getInnerState() {
        return this.innerState;
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInEngineeringMode() {
        return this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) >= 0;
    }

    public static String getEthHardAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                byte[] z;
                NetworkInterface itf = e.nextElement();
                if (!itf.isUp() || itf.isLoopback() || (z = itf.getHardwareAddress()) == null) continue;
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", z[0], z[1], z[2], z[3], z[4], z[5]);
            }
        }
        catch (SocketException e1) {
            log.error((Object)"cannot get hardware address", (Throwable)e1, new String[]{"INIT"});
        }
        return null;
    }

    public Logger getLogger() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getCurrentActionThread() {
        Object object = this.actionMonitor;
        synchronized (object) {
            if (this.currentActionThread != null && !this.currentActionThread.isAlive()) {
                this.currentActionThread = null;
                this.activeThreads.getAndDecrement();
            }
        }
        return this.currentActionThread;
    }

    public ThreadGroup getAncillaryGroup() {
        return this.ancillaryGroup;
    }

    @Command(description="is the system in test context", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInTestContext() {
        return this.inTestContext;
    }

    public boolean isStartedInEngineeringMode() {
        return this.startInEngineeringMode;
    }

    public String getConfiguration() {
        return this.configurationProxy.getConfigurationName();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
        this.configurationProxy.setSubsystem(this);
    }

    @Override
    public void start() {
        log.info((Object)("Subsystem " + this.getName() + " starting with revision " + Subsystem.getSoftwareRevision()), new String[]{"INIT"});
        log.info((Object)("running on MAC " + Subsystem.getEthHardAddress()), new String[]{"INIT"});
        this.initThread = Thread.currentThread();
        this.ancillaryGroup = new ThreadGroup(this.initThread.getThreadGroup(), String.valueOf(this.getName()) + "'s ancillary");
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "INITIALIZATION"));
        this.doStart();
        this.addCommandSet("", new CommandSetBuilder().buildCommandSet(this));
        this.markReadyForCommands();
        super.start();
        ((Agent.InnerAgentMessagingLayer)this.getMessagingAccess()).innerSetCommandExecutor(this);
        try {
            this.checkHardware();
            this.initialisationEndPhase(true);
        }
        catch (HardwareException e) {
            log.error((Object)"check hardware problem ", (Throwable)((Object)e), new String[]{"INIT"});
            this.initialisationError(StackTraceFormats.toString((Throwable)((Object)e)));
            return;
        }
    }

    public void initialisationEndPhase(boolean checkHardwareOK) throws HardwareException {
        boolean stayAlive;
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
        }
        this.postStart();
        this.switchToNormalReady();
        StatusForStart startMessage = new StatusForStart(this.configuration, this.tag);
        startMessage.setInTestContext(this.inTestContext);
        startMessage = (StatusForStart)this.fillStatus((StatusMessage)startMessage);
        log.debug((Object)("sending status " + startMessage), new String[0]);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)startMessage);
        log.info((Object)("Subsystem " + this.getName() + " started"), new String[]{"INIT"});
        if (checkHardwareOK) {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "IDLE"));
        }
        if (stayAlive = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.stayAlive", "false").toUpperCase())) {
            this.stayAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stayAlive() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.initThread) {
            log.warn((Object)(" trying to block the initialisation thread from a different thread" + currentThread + "!=  init thread :" + this.initThread), new String[0]);
            return;
        }
        Object object = this.initThreadMonitor;
        synchronized (object) {
            try {
                this.initThreadMonitor.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialisation() throws SystemStateException, HardwareException {
        if (!this.innerState.getPhase().equals((Object)Phase.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.initialisationEndPhase(false);
    }

    public void doStart() {
    }

    public void postStart() throws HardwareException {
    }

    public void checkHardware() throws HardwareException {
    }

    public void checkAllHardwareStarted() throws HardwareException {
    }

    public void checkAllHardwareStopped() throws HardwareException {
    }

    @Override
    @Command(description="shutdown", type=Command.CommandType.ACTION)
    public Object shutdown() throws HardwareException {
        log.info((Object)("Subsystem " + this.getName() + " shutdown starting"), new String[]{"SHUTDOWN"});
        this.switchToShutdownState();
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.raiseAlarm("some hardware are not stopped");
            log.error((Object)"some hardware are not stopped", (Throwable)((Object)exc), new String[]{"SHUTDOWN"});
            throw exc;
        }
        log.info((Object)"all hardware are stopped", new String[]{"SHUTDOWN"});
        this.doShutdown();
        final Thread shutdownCommandThread = Thread.currentThread();
        final boolean createShutdownThreadAndJoinOnCurrentThread = shutdownCommandThread.getThreadGroup() == this.commandGroup;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + Subsystem.this.getName(), "END PHASE"));
                log.info((Object)"shutdown background thread started", new String[]{"SHUTDOWN"});
                if (createShutdownThreadAndJoinOnCurrentThread) {
                    try {
                        shutdownCommandThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn((Object)("Subsystem " + Subsystem.this.getName() + " shutdown interrupt"), new String[]{"SHUTDOWN"});
                    }
                }
                log.info((Object)"shutdown background thread is active :the initial shutdown command completed", new String[]{"SHUTDOWN"});
                Subsystem.this.switchToOfflineState();
                Subsystem.this.broadcastStatus(Subsystem.this.getStatusBroadcastPeriod());
                StatusForEnd endMessage = new StatusForEnd(Subsystem.this.configuration, Subsystem.this.tag);
                endMessage.setInTestContext(Subsystem.this.inTestContext);
                endMessage = (StatusForEnd)Subsystem.this.fillStatus((StatusMessage)endMessage);
                log.debug((Object)("sending status " + endMessage), new String[0]);
                Subsystem.this.getMessagingAccess().sendStatusMessage((StatusMessage)endMessage);
                log.info((Object)("Subsystem " + Subsystem.this.getName() + " shutdown completed [bus access going to close]"), new String[]{"SHUTDOWN"});
                if (Subsystem.this.logBusHandler != null) {
                    Subsystem.this.logBusHandler.close();
                }
                try {
                    Subsystem.super.shutdown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (Subsystem.this.initThread != null && Subsystem.this.initThread.isAlive()) {
                    Object object = Subsystem.this.initThreadMonitor;
                    synchronized (object) {
                        Subsystem.this.initThreadMonitor.notifyAll();
                    }
                }
            }
        };
        if (createShutdownThreadAndJoinOnCurrentThread) {
            Thread endThread = new Thread(this.commandGroup, runnable, "EndThread");
            endThread.start();
        } else {
            runnable.run();
        }
        return "shutdown ok";
    }

    public void doShutdown() {
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.ABORT)
    public synchronized void forceShutdown() {
        this.forceShutdown = true;
        this.interruptAllRunningCommands();
        this.interruptAncillaryThreads(".*");
        this.notifyAll();
    }

    @Command(description="halt hardware", type=Command.CommandType.ABORT)
    public void abort() {
        log.info((Object)("Subsystem " + this.getName() + " halt requested"), new String[0]);
    }

    @Command(description="halt hardware with expected max delay", type=Command.CommandType.ABORT)
    public void abort(long expectedMaxDelay) {
        log.info((Object)("Subsystem " + this.getName() + " halt requested"), new String[0]);
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        log.info((Object)("Subsystem " + this.getName() + " stop requested"), new String[0]);
    }

    synchronized void markReadyForCommands() {
        this.updateState(null, CommandState.READY, null, null, null);
    }

    synchronized void switchToNormalReady() {
        this.waitForSignalThreads(-1);
        if (!this.isStartedInEngineeringMode()) {
            this.updateState(Phase.OPERATIONAL, CommandState.READY, Mode.NORMAL, AlarmState.NOMINAL, "");
        } else {
            this.updateState(Phase.OPERATIONAL, CommandState.READY, null, AlarmState.NOMINAL, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForSignalThreads(int maxTries) {
        Object object = this.signalsMonitor;
        synchronized (object) {
            int nbTries = 0;
            block5: while (this.listSignalThreads.size() > 0) {
                if (maxTries - nbTries++ <= 0) break;
                long currentTime = System.currentTimeMillis();
                for (SignalThread interruptThread : this.signalThreadsIterable) {
                    if (interruptThread.getMaxDueTime() <= currentTime) continue;
                    try {
                        this.signalsMonitor.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue block5;
                    }
                }
            }
        }
    }

    synchronized void initialisationError(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        this.updateState(null, null, Mode.ENGINEERING_FAULT, AlarmState.ALARM, message);
    }

    protected synchronized void switchToShutdownState() {
        if (this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
            this.updateState(Phase.CLOSING, null, Mode.ENGINEERING_OK, null, null);
        } else {
            this.updateState(Phase.CLOSING, null, null, null, null);
        }
    }

    synchronized void switchToOfflineState() {
        this.updateState(Phase.OFF_LINE, null, null, null, null);
    }

    synchronized boolean testAndSetReadyToActive() {
        if (this.innerState.getCommandProcessing().equals((Object)CommandState.READY)) {
            this.updateState(null, CommandState.ACTIVE, null, null, null);
            return true;
        }
        return false;
    }

    synchronized boolean switchToRunningSignalsState() {
        CommandState commandProcessing = this.innerState.getCommandProcessing();
        if (commandProcessing.equals((Object)CommandState.READY)) {
            this.updateState(null, CommandState.ACTIVE, null, null, null);
            return true;
        }
        return commandProcessing.equals((Object)CommandState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean backToReadyFromActive() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            block4: {
                if (this.listSignalThreads.size() != 0) break block4;
                this.updateState(null, CommandState.READY, null, null, null);
                return true;
            }
            log.warn((Object)"signals running : unable to go back to READY", new String[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean backFromRunningSignal(Thread thread) {
        if (this.innerState.getCommandProcessing().equals((Object)CommandState.ACTIVE)) {
            Object object = this.signalsMonitor;
            synchronized (object) {
                block7: {
                    this.listSignalThreads.remove(thread);
                    CommandState cmdState = null;
                    if (this.listSignalThreads.size() != 0) break block7;
                    cmdState = CommandState.READY;
                    if (this.getCurrentActionThread() != null) {
                        cmdState = CommandState.ACTIVE;
                    }
                    if (!this.innerState.getCommandProcessing().equals((Object)cmdState)) {
                        this.updateState(null, cmdState, null, null, null);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public synchronized boolean switchToEngineeringMode() {
        Mode mode = this.innerState.getMode();
        if (mode.equals((Object)Mode.NORMAL)) {
            this.updateState(null, null, Mode.ENGINEERING_OK, null, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public synchronized void switchToNormalMode() throws SystemStateException {
        if (this.innerState.getAlarmState().compareTo(AlarmState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        this.updateState(null, CommandState.READY, Mode.NORMAL, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateState(null, null, Mode.ENGINEERING_FAULT, AlarmState.ALARM, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void warning(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((StatusMessage)alrm);
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateState(null, null, null, AlarmState.WARNING, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="clear alarms", type=Command.CommandType.QUERY)
    public synchronized void clearAlarms(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            this.updateState(null, null, null, AlarmState.NOMINAL, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="tries to switch to READY ", type=Command.CommandType.QUERY)
    public synchronized void tryReadyState(String message) throws SystemStateException {
        if (this.getCurrentActionThread() != null) {
            throw new ActionCommandStillRunning();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        Phase phase = this.innerState.getProcessingState();
        if (phase.compareTo(Phase.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        this.updateState(null, CommandState.READY, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(description="tries to wait until READY ", type=Command.CommandType.QUERY)
    public synchronized boolean waitForReadyState() throws ClosingStateException {
        while (this.getCurrentActionThread() != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            while (this.listSignalThreads.size() != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        Phase phase = this.innerState.getProcessingState();
        if (phase.compareTo(Phase.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        this.updateState(null, CommandState.READY, null, null, null);
        return true;
    }

    public PublishedState getStateForPublication() {
        return new PublishedState((Serializable)this.innerState.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommandRequest(final CommandRequest m) {
        Object objDestination;
        boolean notTopCommand;
        log.debug((Object)("subsystem got command " + m), new String[]{"CMD"});
        if (this.innerState.getCommandProcessing().equals((Object)CommandState.OFF) || this.innerState.getPhase().equals((Object)Phase.OFF_LINE)) {
            CommandNack ack = new CommandNack(m, (Object)"can't accept command : state is Off", m.getCommandOriginatorId());
            log.debug((Object)("sending nack " + ack), new String[]{"CMD"});
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            return;
        }
        boolean bl = notTopCommand = !m.getDestination().endsWith("/main") && m.getDestination().contains("/");
        if (notTopCommand && this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
            CommandNack ack = new CommandNack(m, (Object)"can't access lower level component (not named \"main\") if not in ENGINEERING MODE", m.getCommandOriginatorId());
            log.debug((Object)("sending nack " + ack), new String[]{"CMD"});
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            return;
        }
        DictionaryCommand dictionaryCommand = null;
        Exception ex = null;
        try {
            dictionaryCommand = this.getCommandSet(m.getDestination()).getCommandDictionary().findCommand(m.getBasicCommand());
        }
        catch (Exception exc) {
            dictionaryCommand = null;
            ex = exc;
        }
        if (dictionaryCommand == null) {
            if (ex == null) {
                ex = new RuntimeException("Could Not find command " + m.getBasicCommand());
            }
            CommandNack ack = new CommandNack(m, (Object)ex.toString(), m.getCommandOriginatorId());
            log.debug((Object)("sending nack on third " + ack), new String[]{"CMD"});
            this.getMessagingAccess().sendCommandReply((CommandReply)ack);
            throw new RuntimeException(ex);
        }
        Object object = objDestination = this instanceof CCSProxy ? ((CCSProxy)((Object)this)).getDelegate() : this;
        if (objDestination instanceof Configurable) {
            objDestination = ((Configurable)objDestination).getEnvironment().getRelevantObject();
        }
        Subsystem realDestination = objDestination;
        final Command.CommandType type = dictionaryCommand.getType();
        final CurrentCommandContext execInfo = new CurrentCommandContext(m.getOriginAgentInfo().getName(), m.getBasicCommand().getCommand(), type, m.getBasicCommand().getArguments());
        switch (type) {
            case QUERY: {
                if (notTopCommand && !this.checkLevelRights(dictionaryCommand, m)) {
                    CommandNack ack = new CommandNack(m, (Object)"insufficient Level privilege", m.getCommandOriginatorId());
                    log.debug((Object)(" QUERY: sending nack " + ack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                    return;
                }
                if (this.isVetoed(m, realDestination, dictionaryCommand, m.getBasicCommand())) {
                    log.debug((Object)(" QUERY: vetoed  " + m), new String[]{"CMD"});
                    return;
                }
                CommandAck ack = new CommandAck(m, m.getCommandOriginatorId());
                log.debug((Object)(" QUERY: sending ack " + ack), new String[]{"CMD"});
                this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf((Object)type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        block2: {
                            LOCAL_EXECUTION_INFO.set(execInfo);
                            result = null;
                            Subsystem.this.getCommandSet(m.getDestination());
                            try {
                                result = Subsystem.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                            }
                            catch (Throwable e) {
                                Throwable th;
                                log.debug((Object)("QUERY exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e, new String[]{"CMD"});
                                result = e;
                                if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                result = th;
                            }
                        }
                        Subsystem.this.endOfCommand();
                        CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                        log.debug((Object)("QUERY reply will be sent  " + reply), new String[]{"CMD"});
                        Subsystem.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                    }
                };
                Thread queryThread = this.createThread(m, runnable, threadName);
                this.activeThreads.getAndIncrement();
                queryThread.start();
                break;
            }
            case CONFIGURATION: {
                if (this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
                    CommandNack nack = new CommandNack(m, (Object)"Configuration commands are accepted only in active ENGINEERING mode", m.getCommandOriginatorId());
                    log.debug((Object)("sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
            }
            case ACTION: {
                CommandState commandProcessing = this.innerState.getCommandProcessing();
                if (!commandProcessing.equals((Object)CommandState.READY)) {
                    CommandNack nack = null;
                    Thread thread = this.getCurrentActionThread();
                    if (thread != null) {
                        nack = new CommandNack(m, (Object)(String.valueOf(thread.getName()) + " still running"), m.getCommandOriginatorId());
                    }
                    if (nack == null) {
                        Object queryThread = this.signalsMonitor;
                        synchronized (queryThread) {
                            if (this.listSignalThreads.size() != 0) {
                                nack = new CommandNack(m, (Object)(String.valueOf(m.getBasicCommand().getCommand()) + " Action or Configuration commands are accepted only if no interruption is running -> " + this.listSignalThreads), m.getCommandOriginatorId());
                            }
                        }
                        if (nack == null) {
                            nack = new CommandNack(m, (Object)(String.valueOf(m.getBasicCommand().getCommand()) + " Action or Configuration commands are accepted only if CommandState is READY"), m.getCommandOriginatorId());
                        }
                    }
                    log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                if (notTopCommand && !this.checkLevelRights(dictionaryCommand, m)) {
                    CommandNack nack = new CommandNack(m, (Object)"insufficient Level privilege", m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                if (!this.checkLock(m)) {
                    CommandNack nack = new CommandNack(m, (Object)"lock : not owner", m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                if (this.isVetoed(m, realDestination, dictionaryCommand, m.getBasicCommand())) {
                    log.debug((Object)((Object)((Object)type) + " sending veto " + m), new String[]{"CMD"});
                    return;
                }
                Object nack = this.actionMonitor;
                synchronized (nack) {
                    if (!this.testAndSetReadyToActive()) {
                        CommandNack nack2 = new CommandNack(m, (Object)" not ready", m.getCommandOriginatorId());
                        log.debug((Object)((Object)((Object)type) + " sending nack " + nack2), new String[]{"CMD"});
                        this.getMessagingAccess().sendCommandReply((CommandReply)nack2);
                        return;
                    }
                    CommandAck ack = new CommandAck(m, (Object)this.getAgentInfo(), m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending ack " + ack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                    String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf((Object)type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object result;
                            block5: {
                                LOCAL_EXECUTION_INFO.set(execInfo);
                                result = null;
                                try {
                                    result = Subsystem.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                                }
                                catch (Throwable e) {
                                    Throwable th;
                                    log.debug((Object)((Object)((Object)type) + " exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e, new String[]{"CMD"});
                                    result = e;
                                    if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block5;
                                    result = th;
                                }
                            }
                            Object e = Subsystem.this.actionMonitor;
                            synchronized (e) {
                                Subsystem.this.currentActionThread = null;
                                Subsystem.this.backToReadyFromActive();
                                Subsystem.this.endOfCommand();
                            }
                            CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                            log.debug((Object)((Object)((Object)type) + " reply will be sent  " + reply), new String[]{"CMD"});
                            Subsystem.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                        }
                    };
                    Thread actionThread = this.createThread(m, runnable, threadName);
                    this.activeThreads.getAndIncrement();
                    this.currentActionThread = actionThread;
                    actionThread.start();
                    break;
                }
            }
            case ABORT: {
                CommandNack nack;
                Object expectedMaxDelay;
                long dueTime;
                long currentTime = dueTime = System.currentTimeMillis();
                DictionaryArgument[] arguments = dictionaryCommand.getArguments();
                if (arguments.length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                    String argAsString = String.valueOf(m.getBasicCommand().getArguments()[0]);
                    expectedMaxDelay = new Long(argAsString);
                    dueTime = currentTime + (Long)expectedMaxDelay;
                }
                boolean timeOverdue = false;
                expectedMaxDelay = this.signalsMonitor;
                synchronized (expectedMaxDelay) {
                    long registeredDueTime = Long.MAX_VALUE;
                    for (SignalThread interruptThread : this.signalThreadsIterable) {
                        long max = interruptThread.getMaxDueTime();
                        if (max >= registeredDueTime) continue;
                        registeredDueTime = max;
                    }
                    if (dueTime > registeredDueTime) {
                        timeOverdue = true;
                    }
                }
                if (timeOverdue) {
                    nack = new CommandNack(m, (Object)" interruption with shorter time span running", m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                if (notTopCommand && !this.checkLevelRights(dictionaryCommand, m)) {
                    nack = new CommandNack(m, (Object)"insufficient Level privilege", m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                if (this.isVetoed(m, realDestination, dictionaryCommand, m.getBasicCommand())) {
                    log.debug((Object)((Object)((Object)type) + " veto " + m), new String[]{"CMD"});
                    return;
                }
                Object object2 = this.signalsMonitor;
                synchronized (object2) {
                    this.switchToRunningSignalsState();
                    CommandAck ack = new CommandAck(m, (Object)this.getAgentInfo(), m.getCommandOriginatorId());
                    log.debug((Object)((Object)((Object)type) + " sending ack " + ack), new String[]{"CMD"});
                    this.getMessagingAccess().sendCommandReply((CommandReply)ack);
                    String threadName = this.nameThread(m.getOriginAgentInfo().getName(), m.getCorrelId(), String.valueOf((Object)type), m.getBasicCommand().getCommand(), m.getBasicCommand().getArguments());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Object result;
                            block2: {
                                LOCAL_EXECUTION_INFO.set(execInfo);
                                result = null;
                                try {
                                    result = Subsystem.this.getCommandSet(m.getDestination()).invoke(m.getBasicCommand());
                                }
                                catch (Throwable e) {
                                    Throwable th;
                                    log.debug((Object)((Object)((Object)type) + " exception:" + m.getBasicCommand().getCommand() + Arrays.toString(m.getBasicCommand().getArguments())), e, new String[]{"CMD"});
                                    result = e;
                                    if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                    result = th;
                                }
                            }
                            Subsystem.this.backFromRunningSignal(Thread.currentThread());
                            Subsystem.this.endOfCommand();
                            CommandResult reply = new CommandResult(m, result, m.getCommandOriginatorId());
                            log.debug((Object)((Object)((Object)type) + "  reply will be sent  " + reply), new String[]{"CMD"});
                            Subsystem.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                        }
                    };
                    SignalThread signalThread = new SignalThread(this.commandGroup, runnable, threadName, dueTime);
                    this.activeThreads.getAndIncrement();
                    this.listSignalThreads.add(signalThread);
                    signalThread.start();
                    break;
                }
            }
            default: {
                assert (false) : "command with unlikely type :" + (Object)((Object)type);
                break;
            }
        }
    }

    String nameThread(String commandOriginator, String correlID, String commandType, String commandName, Object[] parameters) {
        String threadName = String.format("%s [%s] -> %s: %s %s", commandOriginator, correlID, commandType, commandName, Arrays.toString(parameters));
        return threadName;
    }

    Thread createThread(final CommandRequest cmd, Runnable runnable, String threadName) {
        Thread res = new Thread(this.commandGroup, runnable, threadName);
        res.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CommandError reply = new CommandError(cmd, e, cmd.getCommandOriginatorId());
                try {
                    Subsystem.this.getMessagingAccess().sendCommandReply((CommandReply)reply);
                }
                catch (Throwable th) {
                    log.error((Object)("uncaught exception Handler of " + cmd + "can't reply"), th, new String[0]);
                }
            }
        });
        return res;
    }

    private boolean checkLevelRights(DictionaryCommand commandDescribed, CommandRequest command) {
        return true;
    }

    private boolean isVetoed(CommandRequest cmd, Object component, DictionaryCommand dictionaryCommand, BasicCommand basicCommand) {
        if (component instanceof InvocationListener) {
            InvocationListener vetoer = (InvocationListener)component;
            try {
                vetoer.beforeInvocation(cmd.getOriginAgentInfo().getName(), dictionaryCommand, basicCommand);
            }
            catch (InvocationVetoException ex) {
                CommandNack nack = new CommandNack(cmd, (Object)ex.toString(), cmd.getCommandOriginatorId());
                this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForCommandExecution(long timeOut) {
        Object object = this.commandMonitor;
        synchronized (object) {
            while (this.waitingForCommandTermination) {
                try {
                    this.commandMonitor.wait(timeOut);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOfCommand() {
        this.activeThreads.getAndDecrement();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.commandMonitor;
        synchronized (object) {
            this.waitingForCommandTermination = false;
            this.commandMonitor.notifyAll();
        }
    }

    private boolean checkLock(CommandRequest cmd) {
        return true;
    }

    public void addCommandSet(String name, CommandSet commandSet) {
        String tmpName = this.getName();
        if (name.isEmpty() || name.equals("main")) {
            name = tmpName;
            CompositeCommandSet cmdSet = this.commandSetMap.containsKey(name) ? (CompositeCommandSet)this.commandSetMap.get(name) : new CompositeCommandSet();
            cmdSet.add(commandSet);
            commandSet = cmdSet;
        } else {
            name = String.valueOf(tmpName) + "/" + name.replace("main/", "");
        }
        this.commandSetMap.put(name, commandSet);
    }

    private CommandSet getCommandSet(String name) {
        return this.commandSetMap.get(name);
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public HashMap<String, Dictionary> getSystemDictionary() {
        HashMap<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
        for (String name : this.commandSetMap.keySet()) {
            dictionaries.put(name, this.commandSetMap.get(name).getCommandDictionary());
        }
        return dictionaries;
    }

    public void registerAsBusMaster() {
    }

    public void publishMetaData(String dataname, String metadataname, String value) {
        MetadataStatus mst = new MetadataStatus(dataname, metadataname, value);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)mst);
    }

    protected void publishStatusData(EncodedDataStatus dataStatus) {
        StatusMessage status = this.fillStatus((StatusMessage)dataStatus);
        this.getMessagingAccess().sendStatusMessage(status);
    }

    public void publishStatus(long timestamp, String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(timestamp, key, value));
    }

    public void publishStatus(String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(key, value));
    }

    public void publishStatus(long timestamp, KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(timestamp, kvlist));
    }

    public void publishStatus(KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(kvlist));
    }

    public void publishStatus(String key, long[] timestamps, Object[] objects) {
        if (timestamps.length != objects.length) {
            throw new IllegalArgumentException("arrays in parameter do not have same size");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("empty publication request (empty array)");
        }
        int length = timestamps.length;
        EncodedDataStatus res = null;
        EncodedDataStatus current = null;
        int ix = length - 1;
        while (ix >= 0) {
            res = new EncodedDataStatus(timestamps[ix], key, objects[ix]);
            res.setNext(current);
            current = res;
            --ix;
        }
        this.publishStatusData(res);
    }

    public void sendRawStatus(StatusMessage status) {
        this.fillStatus(status);
        this.getMessagingAccess().sendStatusMessage(status);
    }

    @Command(description="set the level of the BusLogHandler", type=Command.CommandType.QUERY)
    public void setBusLogHandlerLevel(String levelName) {
        if (this.logBusHandler != null) {
            Level level = Level.parse(levelName);
            this.logBusHandler.setLevel(level);
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="tries to stop the panic state of logmanagement", type=Command.CommandType.QUERY)
    public void removeLogPanicState() {
        if (this.logBusHandler != null) {
            this.logBusHandler.setPanicState(false);
        }
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        int res = this.activeThreads.get();
        return res - 1;
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Object[] threads = new Thread[this.commandGroup.activeCount()];
        this.commandGroup.enumerate((Thread[])threads);
        return Arrays.toString(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt for all command threads (behaviour of commands are implementation dependent)", type=Command.CommandType.ABORT)
    public synchronized void interruptAllRunningCommands() {
        Thread currentThread = Thread.currentThread();
        Object object = this.actionMonitor;
        synchronized (object) {
            Object object2 = this.signalsMonitor;
            synchronized (object2) {
                Thread[] threads = new Thread[this.commandGroup.activeCount()];
                this.commandGroup.enumerate(threads);
                Thread[] threadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    if (thread.isAlive() && !thread.equals(currentThread)) {
                        try {
                            thread.interrupt();
                        }
                        catch (Exception exc) {
                            log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    @Command(description="sends an interrupt to a running ACTION thread", type=Command.CommandType.ABORT)
    public synchronized void interruptActionThread() {
        log.debug((Object)"interrupting action thread", new String[0]);
        Thread thread = this.getCurrentActionThread();
        try {
            thread.interrupt();
        }
        catch (Exception exc) {
            log.warn((Object)(exc + "thrown during interruption"), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt to all running SIGNAL  threads", type=Command.CommandType.ABORT)
    public synchronized void interruptAllSignalThreads() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            for (SignalThread signalThread : this.signalThreadsIterable) {
                if (signalThread == Thread.currentThread()) continue;
                try {
                    signalThread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                }
            }
        }
    }

    @Command(description="sends an interrupt to any 'ancillary' thread whose name matches the regular expression passed as argument", type=Command.CommandType.ABORT)
    public void interruptAncillaryThreads(String expReg) {
        Thread[] threads = new Thread[this.ancillaryGroup.activeCount()];
        this.ancillaryGroup.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            String name = thread.getName();
            if (name.matches(expReg) && thread.isAlive()) {
                try {
                    thread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                }
            }
            ++n2;
        }
    }

    @Command(description="sends an interrupt to the initialization thread", type=Command.CommandType.ABORT)
    public synchronized void interruptInitThread() {
        if (this.initThread != null && this.initThread.isAlive()) {
            try {
                this.initThread.interrupt();
            }
            catch (Exception exc) {
                log.warn((Object)(exc + "thrown during interruption"), new String[0]);
            }
        }
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        HeartBeatStatus status = new HeartBeatStatus(this.getStatusBroadcastPeriod());
        this.fillStatus((StatusMessage)status);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)status);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.getMessagingAccess().getAgentPresenceManager();
    }

    public static class SignalThread
    extends Thread {
        long maxDueTime;

        public SignalThread(ThreadGroup group, Runnable target, final String name, long maxDueTime) {
            super(group, target, name);
            this.maxDueTime = maxDueTime;
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.error((Object)(String.valueOf(name) + " signal Thread"), e, new String[]{"CMD"});
                }
            });
        }

        public long getMaxDueTime() {
            return this.maxDueTime;
        }

        public void extendDuration(long millis) {
            this.maxDueTime = this.maxDueTime < Long.MAX_VALUE - millis ? (this.maxDueTime += millis) : Long.MAX_VALUE;
        }
    }
}

