/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.util.logging.Level;
import org.lsst.ccs.AlarmState;
import org.lsst.ccs.CommandState;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Mode;
import org.lsst.ccs.Phase;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.AlarmOnStateChange;
import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.bus.messages.PublishedState;
import org.lsst.ccs.bus.messages.StateChangeNotification;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.utils.LogBusHandler;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;

public class Agent {
    private final AgentInfo agentInfo;
    private final String name;
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs");
    private InnerAgentMessagingLayer messagingAccess;
    private static volatile AgentMessagingLayer environmentAgentMessagingLayer = null;
    protected State innerState = new State();
    private volatile int statusBroadcastPeriod = 5;
    private volatile Thread statusBroadcasterThread = null;
    private volatile Object statusBroadcasterLock = new Object();
    protected LogBusHandler logBusHandler;

    public Agent(String name, AgentInfo.AgentType agentType) {
        Subsystem.LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_", "BUILD"));
        switch (agentType) {
            case LISTENER: 
            case CONSOLE: {
                name = Names.almostUniqueAgentName((String)name);
                break;
            }
        }
        this.agentInfo = new AgentInfo(name, agentType);
        Subsystem.LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + name, "BUS CONNECTIONS"));
        this.name = name;
        this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
    }

    private synchronized void setEnvironmentMessagingAccess(AgentMessagingLayer layer) {
        if (environmentAgentMessagingLayer == null) {
            environmentAgentMessagingLayer = layer;
        } else if (BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false").equals("false")) {
            throw new RuntimeException("*** Should not have two agents running in same JVM");
        }
    }

    public static AgentMessagingLayer getEnvironmentMessagingAccess() {
        if (environmentAgentMessagingLayer == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgentMessagingLayer;
    }

    private void connectToTheBuses() {
        if (this.messagingAccess == null) {
            this.messagingAccess = new InnerAgentMessagingLayer(this.agentInfo);
            this.setEnvironmentMessagingAccess(this.messagingAccess);
            this.initLogBusHandler();
        }
    }

    public String getName() {
        return this.name;
    }

    public AgentMessagingLayer getMessagingAccess() {
        if (this.messagingAccess == null) {
            this.connectToTheBuses();
        }
        return this.messagingAccess;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    protected void initLogBusHandler() {
        if (this.logBusHandler == null) {
            java.util.logging.Logger generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
            this.logBusHandler = new LogBusHandler(this.messagingAccess);
            generalLogger.addHandler(this.logBusHandler);
            if (!LogManagement.isConfigInitialized()) {
                generalLogger.setLevel(Level.WARNING);
            }
        }
    }

    public void start() {
        this.connectToTheBuses();
        this.startStatusBroadcasting();
    }

    protected synchronized StatusMessage fillStatus(StatusMessage s) {
        s.setState(new PublishedState((Serializable)this.innerState));
        s.setSummary(this.innerState.stateExtraInfo);
        return s;
    }

    public StatusMessage getStatus(int statusBroadcastPeriod) {
        HeartBeatStatus s = new HeartBeatStatus(statusBroadcastPeriod);
        return this.fillStatus((StatusMessage)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (statusBroadcastPeriod < 1) {
                this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
                log.info((Object)("broadcast period should be 1 or above. set to " + this.getDefaultBroadcastingPeriod()), new String[0]);
            } else {
                this.statusBroadcastPeriod = statusBroadcastPeriod;
            }
            Phase state = this.innerState.getProcessingState();
            if (state.compareTo(Phase.CLOSING) < 0) {
                this.startStatusBroadcasting();
            }
        }
    }

    protected int getDefaultBroadcastingPeriod() {
        if (this.agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            return 1;
        }
        return 5;
    }

    public int getStatusBroadcastPeriod() {
        return this.statusBroadcastPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (this.statusBroadcasterThread == null) {
                StatusBroadcaster run = new StatusBroadcaster();
                this.statusBroadcasterThread = new Thread((Runnable)run, String.valueOf(this.name) + "-broadcast");
                this.statusBroadcasterThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            while (true) {
                if (this.statusBroadcasterThread == null) {
                    return;
                }
                if (this.statusBroadcasterThread != null) {
                    this.statusBroadcasterThread.interrupt();
                }
                try {
                    this.statusBroadcasterLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void broadcastStatus(int statusBroadcastPeriod) {
        HeartBeatStatus s = new HeartBeatStatus(statusBroadcastPeriod);
        this.fillStatus((StatusMessage)s);
        this.messagingAccess.sendStatusMessage((StatusMessage)s);
    }

    protected void updateState(Phase phase, CommandState commandProcessing, Mode mode, AlarmState alarmState, String extraInfo) {
        State oldState = this.innerState;
        if (phase != null) {
            this.innerState.phase = phase;
        }
        if (commandProcessing != null) {
            this.innerState.commandProcessing = commandProcessing;
        }
        if (mode != null) {
            this.innerState.mode = mode;
        }
        if (alarmState != null) {
            this.innerState.alarmState = alarmState;
        }
        if (extraInfo != null) {
            this.innerState.stateExtraInfo = extraInfo;
        }
        this.publishStateChange(oldState, this.innerState);
    }

    protected void publishStateChange(State before, State after) {
        PublishedState pBefore = new PublishedState((Serializable)before.clone());
        PublishedState pAfter = new PublishedState((Serializable)after.clone());
        int comparison = after.alarmState.compareTo(AlarmState.WARNING);
        if (comparison >= 0) {
            AlarmOnStateChange alarmOnStateChange = new AlarmOnStateChange(pBefore, pAfter);
            alarmOnStateChange.setSummary(((State)pAfter.getState()).stateExtraInfo);
            this.getMessagingAccess().sendStatusMessage((StatusMessage)alarmOnStateChange);
        } else {
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StateChangeNotification(pBefore, pAfter));
        }
    }

    public static State createState(Phase phase, Mode mode, CommandState activity, AlarmState alarm) {
        State res = new State();
        res.phase = phase;
        res.mode = mode;
        res.commandProcessing = activity;
        res.alarmState = alarm;
        return res;
    }

    @Command(description="shutdown", type=Command.CommandType.ACTION)
    public Object shutdown() throws Exception {
        this.stopStatusBroadcasting();
        this.messagingAccess.innerShutdownBusAccess();
        return "OK";
    }

    class InnerAgentMessagingLayer
    extends AgentMessagingLayer {
        InnerAgentMessagingLayer(AgentInfo agentInfo) {
            super(agentInfo);
        }

        void innerShutdownBusAccess() {
            super.shutdownBusAccess();
        }

        synchronized void innerSetCommandExecutor(CommandExecutor executor) {
            super.setCommandExecutor(executor);
        }
    }

    public static class State
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -9205531738428213674L;
        private Mode mode = Mode.ENGINEERING_OK;
        private Phase phase = Phase.INITIALIZING;
        private CommandState commandProcessing = CommandState.OFF;
        private AlarmState alarmState = AlarmState.NOMINAL;
        private String stateExtraInfo;

        public Phase getProcessingState() {
            return this.phase;
        }

        public Mode getMode() {
            return this.mode;
        }

        public AlarmState getAlarmState() {
            return this.alarmState;
        }

        public Phase getPhase() {
            return this.phase;
        }

        public CommandState getCommandProcessing() {
            return this.commandProcessing;
        }

        public String getStateExtraInfo() {
            return this.stateExtraInfo;
        }

        public String toString() {
            return (Object)((Object)this.phase) + ":" + (Object)((Object)this.commandProcessing) + ":" + (Object)((Object)this.mode) + ":" + (Object)((Object)this.alarmState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            if (this.alarmState != state.alarmState) {
                return false;
            }
            if (this.commandProcessing != state.commandProcessing) {
                return false;
            }
            if (this.mode != state.mode) {
                return false;
            }
            return this.phase == state.phase;
        }

        public int hashCode() {
            int result = this.mode.hashCode();
            result = 31 * result + this.phase.hashCode();
            result = 31 * result + this.commandProcessing.hashCode();
            result = 31 * result + this.alarmState.hashCode();
            return result;
        }

        public State clone() {
            State res = null;
            try {
                res = (State)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            return res;
        }
    }

    protected class StatusBroadcaster
    implements Runnable {
        protected StatusBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Subsystem.LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + Agent.this.name, "STATUS BROADCASTING"));
            try {
                try {
                    while (true) {
                        Agent.this.broadcastStatus(Agent.this.statusBroadcastPeriod);
                        int period = Agent.this.statusBroadcastPeriod;
                        Thread.sleep(1000L * (long)period);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = Agent.this.statusBroadcasterLock;
                    synchronized (object) {
                        Agent.this.statusBroadcasterThread = null;
                        Agent.this.statusBroadcasterLock.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = Agent.this.statusBroadcasterLock;
                synchronized (object) {
                    Agent.this.statusBroadcasterThread = null;
                    Agent.this.statusBroadcasterLock.notifyAll();
                }
                throw throwable;
            }
        }
    }
}

