/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.util.UUID;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.ProvidesDisconnectionInformation;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.utilities.logging.Logger;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer,
ProvidesDisconnectionInformation {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs";
    private Properties jgroupsProperties;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private static final String propertyKeyForJGroups = "org.lsst.ccs.jgroups.";
    private static final String propertyKeyForAllBuses = "org.lsst.ccs.jgroups.ALL.";
    private static Logger logger = Logger.getLogger((String)"org.lsst.ccs.messaging.jgroups");
    private CopyOnWriteArrayList<AgentAddresses> namedAgentAddresses = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<AgentAddresses> anonymousAddresses = new CopyOnWriteArrayList();
    private Map<String, LocalAgentChannels> mapLocalChannels = new ConcurrentHashMap<String, LocalAgentChannels>();
    private View[] lastViews = new View[Bus.values().length];
    private volatile boolean closed;

    JGroupsBusMessagingLayer(String protocolString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            this.xmlConfigurationFile = String.format("/%s.xml", rawResource);
        }
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
    }

    int getNumberOfViewMembersForBus(String agentName, Bus bus) {
        LocalAgentChannels localChannels = this.mapLocalChannels.get(agentName);
        return localChannels.channels[bus.ordinal()].getView().getMembers().size();
    }

    @Override
    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
    }

    @Override
    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        HashSet<String> result = new HashSet<String>();
        for (String agentName : this.mapLocalChannels.keySet()) {
            LocalAgentChannels localAgentChannels = this.mapLocalChannels.get(agentName);
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
                if (receiver != null && !result.contains(agentName)) {
                    result.add(agentName);
                }
                ++n2;
            }
        }
        return result;
    }

    public static XmlConfigurator createXmlConfiguratorForBus(String xmlConfigurationFile, Properties properties, String bus) {
        String[] propertyKeys;
        InputStream xmlConfigurationFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)xmlConfigurationFile, JGroupsBusMessagingLayer.class);
        if (xmlConfigurationFileInputStream == null) {
            throw new IllegalArgumentException(String.valueOf(xmlConfigurationFile) + " not found as a resource");
        }
        XmlConfigurator configurator = null;
        try {
            configurator = XmlConfigurator.getInstance((InputStream)xmlConfigurationFileInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create JGroups xml configuration object for " + xmlConfigurationFile, ioe);
        }
        List protocolConfigurationList = configurator.getProtocolStack();
        String[] stringArray = propertyKeys = new String[]{propertyKeyForAllBuses, propertyKeyForJGroups + bus.toUpperCase() + "."};
        int n = propertyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyKey = stringArray[n2];
            Set keys = BootstrapResourceUtils.getAllKeysInProperties((Properties)properties);
            for (Object key : keys) {
                String property = (String)key;
                if (!property.startsWith(propertyKey)) continue;
                String shortProperty = property.replace(propertyKey, "");
                int divider = shortProperty.lastIndexOf(".");
                String protocolPropertyName = shortProperty.substring(divider + 1);
                String protocolName = shortProperty.substring(0, divider);
                String protocolPropertyValue = properties.getProperty(property);
                boolean found = false;
                for (ProtocolConfiguration protocolConfiguration : protocolConfigurationList) {
                    if (!protocolConfiguration.getProtocolName().equals(protocolName)) continue;
                    protocolConfiguration.getProperties().put(protocolPropertyName, protocolPropertyValue);
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put(protocolPropertyName, protocolPropertyValue);
                ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocolName, hash);
                protocolConfigurationList.add(newProtocol);
            }
            ++n2;
        }
        return configurator;
    }

    private boolean isDuplicate(View view, Address address) {
        for (Address a : view.getMembers()) {
            if (address.equals(a) || !a.toString().equals(address.toString())) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateMapAddressesFromView(MessagingAccessLayer.BusAccess busAccess, View view) {
        String name;
        Address address;
        Bus bus = busAccess.getBus();
        int index = bus.ordinal();
        View lastView = this.lastViews[index];
        Address[][] diffArray = View.diff((View)lastView, (View)view);
        this.lastViews[index] = view;
        Address[] addressArray = diffArray[0];
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            address = addressArray[n2];
            name = address.toString();
            if ("__".equals(name)) {
                AgentAddresses agentAddresses = new AgentAddresses();
                agentAddresses.agentName = "__";
                agentAddresses.busAddresses[index] = address;
                this.anonymousAddresses.add(agentAddresses);
                logger.info((Object)("adding anonymous ====== " + address + " to " + bus), new String[0]);
            } else {
                boolean found = false;
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(name)) continue;
                    agentAddresses.busAddresses[index] = address;
                    logger.info((Object)("updating ====== " + address + " on " + bus + " with code " + address.hashCode()), new String[0]);
                    found = true;
                    break;
                }
                if (!found) {
                    AgentAddresses agentAddresses;
                    agentAddresses = new AgentAddresses();
                    agentAddresses.agentName = name;
                    agentAddresses.busAddresses[index] = address;
                    this.namedAgentAddresses.add(agentAddresses);
                    logger.info((Object)("adding ====== " + address + " to " + bus + " with code " + address.hashCode()), new String[0]);
                }
            }
            ++n2;
        }
        addressArray = diffArray[1];
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            block10: {
                block9: {
                    address = addressArray[n2];
                    name = address.toString();
                    if (!"__".equals(name)) break block9;
                    Iterator<AgentAddresses> it = this.anonymousAddresses.iterator();
                    AgentAddresses agentAddressesToRemove = null;
                    while (it.hasNext()) {
                        AgentAddresses agentAddresses = it.next();
                        Address storedAddress = agentAddresses.busAddresses[index];
                        if (!address.equals(storedAddress)) continue;
                        agentAddressesToRemove = agentAddresses;
                    }
                    if (agentAddressesToRemove == null) break block10;
                    this.anonymousAddresses.remove(agentAddressesToRemove);
                    break block10;
                }
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(name)) continue;
                    agentAddresses.busAddresses[index] = null;
                    if (!busAccess.getBus().equals(Bus.STATUS)) break;
                    String info = "";
                    if (address instanceof UUID) {
                        info = ((UUID)address).toStringLong();
                    }
                    ((MessagingAccessLayer.StatusBusAccess)busAccess).processDisconnectionSuspicion(address.toString(), info);
                    logger.info((Object)("removing ====== " + address + " from " + bus + " with code " + address.hashCode()), new String[0]);
                    break;
                }
            }
            ++n2;
        }
    }

    @Override
    public void closeFor(String agentName, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.remove(agentName)) != null) {
            AgentAddresses agentAddresses = null;
            if (!"__".equals(agentName)) {
                for (AgentAddresses agAddress : this.namedAgentAddresses) {
                    if (!agentName.equals(agAddress.agentName)) continue;
                    agentAddresses = agAddress;
                    break;
                }
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                JChannel channel = localAgentChannels.channels[index];
                if (channel != null) {
                    channel.close();
                }
                if (agentAddresses != null) {
                    agentAddresses.busAddresses[index] = null;
                }
                ++n2;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (String key : this.mapLocalChannels.keySet()) {
            logger.info((Object)("******** removing " + key), new String[0]);
            LocalAgentChannels localAgentChannels = this.mapLocalChannels.get(key);
            JChannel[] jChannelArray = localAgentChannels.channels;
            int n = localAgentChannels.channels.length;
            int n2 = 0;
            while (n2 < n) {
                JChannel channel = jChannelArray[n2];
                if (channel != null) {
                    channel.close();
                }
                ++n2;
            }
        }
    }

    @Override
    public <T extends BusMessage> void sendMessage(String senderAgent, Bus<T> bus, T message, String ... destinations) throws IOException {
        LocalAgentChannels localAgentChannels;
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        ArrayList<Address> listDestinationAddress = null;
        int index = bus.ordinal();
        ArrayList<String> failed = new ArrayList<String>();
        if (destinations.length != 0 && !"".equals(destinations[0]) && !"*".equals(destinations[0])) {
            listDestinationAddress = new ArrayList<Address>();
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String destination = stringArray[n2];
                boolean found = false;
                for (AgentAddresses agentAddresses : this.namedAgentAddresses) {
                    if (!agentAddresses.agentName.equals(destination)) continue;
                    Address address = agentAddresses.busAddresses[index];
                    if (address != null) {
                        listDestinationAddress.add(address);
                    } else {
                        failed.add(destination);
                        logger.info((Object)("sending fail (closed)" + agentAddresses.agentName), new String[0]);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    failed.add(destination);
                    logger.info((Object)("sending fail to : " + destination), new String[0]);
                }
                ++n2;
            }
            for (AgentAddresses agentAddresses : this.anonymousAddresses) {
                Address address = agentAddresses.busAddresses[index];
                if (address == null) continue;
                listDestinationAddress.add(address);
            }
        }
        if ((localAgentChannels = this.mapLocalChannels.get(senderAgent)) == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        JChannel channel = localAgentChannels.channels[index];
        if (channel == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        try {
            channel.send(null, message);
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
        if (failed.size() != 0) {
            DestinationsException exc = new DestinationsException(senderAgent, failed.toArray());
            throw exc;
        }
    }

    @Override
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            throw new IllegalArgumentException(" agent " + agentName + " not registered");
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + " not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
            ++n2;
        }
    }

    @Override
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            return;
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver != null) {
                receiver.removeForwarder(forwarder);
            }
            ++n2;
        }
    }

    @Override
    public void connect(MessagingAccessLayer accessLayer) throws DuplicateAgentNameException, IOException {
        StringBuilder allBuses = new StringBuilder();
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            allBuses.append(ba.getBus() + " ");
        }
        logger.info((Object)("### Registering " + accessLayer.getName() + " for buses " + allBuses), new String[0]);
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        String agentName = accessLayer.getName();
        if (agentName == null || "".equals(agentName) || "__".equals(agentName)) {
            agentName = "__";
        }
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            Bus bus = ba.getBus();
            int index = ba.getBus().ordinal();
            try {
                XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, bus.toString());
                JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
                logger.debug((Object)("######################################################\nJGroup Configuration for bus: " + bus.toString() + "\n" + channel.getProtocolStack().printProtocolSpecAsXML() + "\n" + "######################################################"), new String[0]);
                channel.setName(agentName);
                channel.connect(bus.toString());
                if (this.isDuplicate(channel.getView(), channel.getAddress())) {
                    channel.close();
                    throw new DuplicateAgentNameException(agentName, "Channel with same name already exists in view");
                }
                String[] propertiesArray = channel.getProperties().split(";");
                String bind_addr = null;
                int i = 0;
                while (i < propertiesArray.length) {
                    if (propertiesArray[i].startsWith("bind_addr=")) {
                        bind_addr = propertiesArray[i];
                        break;
                    }
                    ++i;
                }
                logger.debug((Object)("*** new view " + channel.getClusterName() + " " + channel.getView() + " " + bind_addr), new String[0]);
                this.updateMapAddressesFromView(ba, channel.getView());
                LocalAgentChannels localChannels = this.mapLocalChannels.get(agentName);
                if (localChannels == null) {
                    localChannels = new LocalAgentChannels();
                    localChannels.agentName = agentName;
                    this.mapLocalChannels.put(agentName, localChannels);
                }
                localChannels.channels[bus.ordinal()] = channel;
                localChannels.receivers[index] = new BusReceiver(ba, channel, this);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void disconnect(MessagingAccessLayer accessLayers) {
        Bus[] buses = new Bus[accessLayers.getBusAccesses().size()];
        for (MessagingAccessLayer.BusAccess layer : accessLayers.getBusAccesses()) {
            buses[layer.getBus().ordinal()] = layer.getBus();
        }
        this.closeFor(accessLayers.getName(), buses);
    }

    class AgentAddresses {
        String agentName;
        Address[] busAddresses = new Address[Bus.values().length];

        AgentAddresses() {
        }
    }

    class BusReceiver
    extends ReceiverAdapter {
        JChannel curChan;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        BusMessagingLayer layer;
        MessagingAccessLayer.BusAccess accessLayer;

        BusReceiver(MessagingAccessLayer.BusAccess accessLayer, JChannel curChan, BusMessagingLayer layer) {
            this.accessLayer = accessLayer;
            this.curChan = curChan;
            curChan.setReceiver((Receiver)this);
            this.layer = layer;
        }

        public void addForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                this.listForwarders = new CopyOnWriteArrayList();
            }
            this.listForwarders.add(forwarder);
        }

        public void removeForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                return;
            }
            this.listForwarders.remove(forwarder);
        }

        public void receive(Message message) {
            BusMessage busMessInit;
            try {
                busMessInit = (BusMessage)message.getObject();
            }
            catch (RuntimeException exc) {
                exc.printStackTrace();
                throw exc;
            }
            BusMessage busMess = busMessInit;
            this.accessLayer.processBusMessage(busMess);
        }

        public void viewAccepted(View view) {
            logger.info((Object)("view accepted : " + view.getMembers()), new String[0]);
            JGroupsBusMessagingLayer.this.updateMapAddressesFromView(this.accessLayer, view);
            logger.info((Object)("Updated current view : " + JGroupsBusMessagingLayer.this.lastViews[this.accessLayer.getBus().ordinal()].getMembers()), new String[0]);
        }

        public void suspect(Address address) {
            logger.info((Object)("disconnection suspicion on " + this.accessLayer.getBus() + " bus : " + address.toString()), new String[0]);
            int index = this.accessLayer.getBus().ordinal();
            if (index == Bus.STATUS.ordinal()) {
                for (AgentAddresses agentAddresses : JGroupsBusMessagingLayer.this.namedAgentAddresses) {
                    Address localAddress = agentAddresses.busAddresses[index];
                    if (!address.equals(localAddress)) continue;
                    String info = "";
                    if (address instanceof UUID) {
                        info = ((UUID)address).toStringLong();
                    }
                    ((MessagingAccessLayer.StatusBusAccess)this.accessLayer).processDisconnectionSuspicion(address.toString(), info);
                    agentAddresses.busAddresses[index] = null;
                    break;
                }
            }
        }
    }

    class LocalAgentChannels {
        String agentName;
        JChannel[] channels = new JChannel[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgentChannels() {
        }
    }
}

