/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jline.console.ConsoleReader;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystem.shell.SynchronousCommandInvoker;

public class ConsoleCommandShell
implements AgentPresenceListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final CompositeCommandSet ccs;
    private final SynchronousCommandInvoker sci;
    private static final int timeoutMillis = 10000;
    private final Map<String, RoutingCommandSet> routes = new LinkedHashMap<String, RoutingCommandSet>();

    private ConsoleCommandShell(AgentMessagingLayer messagingAccess) {
        this.messagingAccess = messagingAccess;
        this.sci = new SynchronousCommandInvoker(new SynchronousCommandAgent(messagingAccess), 10000);
        CommandSetBuilder builder = new CommandSetBuilder();
        this.ccs = new CompositeCommandSet();
        this.ccs.add(builder.buildCommandSet((Object)new BusMasterCommands()));
        this.rsc = new RouteSelectionCommandSet(this.ccs);
    }

    private void init() {
        AgentPresenceManager apMan = this.messagingAccess.getAgentPresenceManager();
        apMan.addAgentPresenceListener((AgentPresenceListener)this);
        List agents = apMan.listAgents(0);
        agents.forEach(agent -> this.connecting((AgentInfo)agent));
    }

    public CompositeCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    public void connecting(AgentInfo agent) {
        if (!(agent.getType().equals((Object)AgentInfo.AgentType.LISTENER) || agent.getType().equals((Object)AgentInfo.AgentType.CONSOLE) || this.routes.containsKey(agent.getName()))) {
            AddSubsystem add = new AddSubsystem(agent.getName());
            Thread t = new Thread(add);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnecting(AgentInfo agent) {
        String agentName = agent.getName();
        ConsoleCommandShell consoleCommandShell = this;
        synchronized (consoleCommandShell) {
            Iterator<Map.Entry<String, RoutingCommandSet>> it = this.routes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RoutingCommandSet> e = it.next();
                String routeName = e.getKey();
                if (!routeName.equals(agentName) && !routeName.startsWith(String.valueOf(agentName) + "/")) continue;
                this.ccs.remove((CommandSet)e.getValue());
                it.remove();
            }
        }
    }

    private List<String> availableSubsystems() {
        List agents = this.messagingAccess.getAgentPresenceManager().listAgents(0);
        return agents.stream().map(AgentInfo::getName).collect(Collectors.toList());
    }

    public static JLineShell createJLineShell(AgentMessagingLayer messagingAccess, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(messagingAccess);
        comShell.init();
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static void main(String[] argv) throws Exception {
        BusMaster busMaster = new BusMaster("console");
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster.getMessagingAccess());
        comShell.init();
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        shell.run();
        System.exit(0);
    }

    private class AddSubsystem
    implements Runnable {
        private final String agentName;

        AddSubsystem(String name) {
            this.agentName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommandRequest getDictionaryCommand = new CommandRequest(this.agentName, "getSystemDictionary");
                HashMap dictionaries = (HashMap)ConsoleCommandShell.this.sci.invoke(getDictionaryCommand, 10000);
                ConsoleCommandShell consoleCommandShell = ConsoleCommandShell.this;
                synchronized (consoleCommandShell) {
                    dictionaries.forEach((name, dict) -> this.addDictionary((String)name, (Dictionary)dict));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void addDictionary(String name, Dictionary dictionary) {
            if (ConsoleCommandShell.this.routes.containsKey(name)) {
                throw new RuntimeException("Error: Route " + name + " already exist");
            }
            RoutingCommandSet crcs = new RoutingCommandSet(name, (CommandSet)new BusCommandSet(ConsoleCommandShell.this.sci, name, dictionary));
            ConsoleCommandShell.this.ccs.add((CommandSet)crcs);
            ConsoleCommandShell.this.routes.put(name, crcs);
        }
    }

    public class BusMasterCommands {
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses", alias="ls")
        public List<String> listSubsystems() {
            return ConsoleCommandShell.this.availableSubsystems();
        }

        @Command(description="Set timeout for future command sent on CCS bus")
        public void set(@Argument(name="item") TimeoutEnum what, @Argument(name="value", defaultValue="10000") int timeoutMillis) {
            ConsoleCommandShell.this.sci.setTimeoutMillis(timeoutMillis);
        }
    }

    public static enum TimeoutEnum {
        TIMEOUT;

    }
}

