/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.gruth.jutils.DescriptiveNode;

public class LocalMergeToBinary {
    public static void main(String[] args) throws Exception {
        SubsystemDescription description;
        if (args.length < 2) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalMergeToBinary pathName propertiesFile [-boot]\n where filename is  xx.ser or xx.groovy or xx.groo\n where propertiesFile is  xx_configName_.properties\n pathName could be file (with '/' file separator) or resource path\n option -boot then boots a subsystem with all data");
            System.exit(1);
        }
        String pathName = args[0];
        String propertiesFile = args[1];
        NamesAndTag namesAndTagOrigin = ConfigUtils.namesFromPath((String)pathName);
        NamesAndTag namesAndTagProperties = ConfigUtils.namesFromPath((String)propertiesFile);
        if (!namesAndTagOrigin.getSubsystemName().equals(namesAndTagProperties.getSubsystemName())) {
            throw new IllegalArgumentException(" subsystem names do not match : " + namesAndTagOrigin.getSubsystemName() + " " + namesAndTagProperties.getSubsystemName());
        }
        if (namesAndTagProperties.getConfigName().equals(namesAndTagOrigin.getConfigName())) {
            throw new IllegalAccessException(" configuration with same name, creating a new file will destroy model");
        }
        InputStream is = CommonResources.getInput(LocalMergeToBinary.class, (String)pathName);
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(is);
            DescriptiveNode componentNode = (DescriptiveNode)ois.readObject();
            description = Factories.createRawSubsystemDescription((String)namesAndTagOrigin.getSubsystemName(), (String)namesAndTagOrigin.getTag(), (String)"", (String)"", (Serializable)componentNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE);
            ois.close();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            description = Factories.createRawSubsystemDescription((String)namesAndTagOrigin.getSubsystemName(), (String)namesAndTagOrigin.getTag(), (String)"", (String)"", (InputStream)is, (String)"ISO-8859-1");
        } else {
            throw new IllegalArgumentException(" not supported : " + pathName);
        }
        InputStream pis = CommonResources.getInput(LocalMergeToBinary.class, (String)propertiesFile);
        Properties props = new Properties();
        props.load(pis);
        System.out.println(props);
        Collection descriptions = description.getPossibleDescriptions(10);
        description.addParameterDescriptions(descriptions);
        DescriptiveNode res = description.getModifiedConfigurationData(props);
        String newPathName = String.valueOf(namesAndTagProperties.toString()) + ".ser";
        FileOutputStream os = new FileOutputStream(newPathName);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(res);
        oos.flush();
        oos.close();
    }
}

