/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.KeyData;

public class StatusCodec {
    static Logger logger = Logger.getLogger("org.lsst.ccs.bus");
    static ConcurrentHashMap<Class, ClassDescriptor> classMap = new ConcurrentHashMap();
    public static final Class[] WELL_KNOWN_TYPES = new Class[]{Boolean.class, Boolean.TYPE, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, byte[].class, boolean[].class, int[].class, float[].class, double[].class, String[].class, BitSet.class, BigDecimal.class};
    public static final ClassDescriptor NULL_DESCRIPTOR = new ClassDescriptor(false, false, null, false, null, null){

        @Override
        public String toString() {
            return "NULL_DESCRIPTOR";
        }
    };
    public static final ClassDescriptor ENUM_DESCRIPTOR = new ClassDescriptor(true, true, null, false, null, null){

        @Override
        public String toString() {
            return "ENUM_DESCRIPTOR";
        }
    };

    static {
        Class[] classArray = WELL_KNOWN_TYPES;
        int n = WELL_KNOWN_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            classMap.put(clazz, NULL_DESCRIPTOR);
            ++n2;
        }
    }

    static ClassDescriptor getDescriptorFor(Class clazz) {
        ClassDescriptor first = classMap.get(clazz);
        if (first == null) {
            first = StatusCodec.buildDescriptorFor(clazz);
            classMap.put(clazz, first);
        }
        return first;
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized ClassDescriptor buildDescriptorFor(Class clazz) {
        block14: {
            if (clazz.isEnum()) {
                return StatusCodec.ENUM_DESCRIPTOR;
            }
            usableCtor = null;
            isNoArgCtor = false;
            try {
                usableCtor = clazz.getDeclaredConstructor(new Class[0]);
                usableCtor.setAccessible(true);
                isNoArgCtor = true;
                break block14;
            }
            catch (NoSuchMethodException v0) {
                ctors = clazz.getConstructors();
                if (ctors.length > 1) {
                    StatusCodec.logger.warning("encoding does not work properly when there is constructor overloading in class " + clazz.getName());
                    break block14;
                }
                var7_5 = ctors;
                var6_6 = ctors.length;
                var5_9 = 0;
                ** while (var5_9 < var6_6)
            }
lbl-1000:
            // 1 sources

            {
                ctor = var7_5[var5_9];
                annotation = ctor.getAnnotation(ConstructorProperties.class);
                if (annotation != null) {
                    usableCtor = ctor;
                    usableCtor.setAccessible(true);
                    isNoArgCtor = false;
                    break;
                }
                parms = ctor.getParameters();
                if (parms[0].isNamePresent()) {
                    usableCtor = ctor;
                    usableCtor.setAccessible(true);
                    isNoArgCtor = false;
                    break;
                }
                ++var5_9;
                continue;
            }
        }
        crystallize = usableCtor == null;
        listFields = new ArrayList<Field>();
        superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            superDescriptor = StatusCodec.getDescriptorFor(superClazz);
            if (superDescriptor.toCrystallize) {
                return new ClassDescriptor(false, true, usableCtor, isNoArgCtor, superClazz, null);
            }
            listFields.addAll(superDescriptor.mapFields.values());
        }
        var10_16 = fields = clazz.getDeclaredFields();
        var9_15 = fields.length;
        var8_13 = 0;
        while (var8_13 < var9_15) {
            field = var10_16[var8_13];
            modifiers = field.getModifiers();
            if (!(Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) && !Serializable.class.isAssignableFrom(field.getType()))) {
                fieldType = field.getType();
                descriptor = StatusCodec.getDescriptorFor(fieldType);
                if (descriptor != StatusCodec.NULL_DESCRIPTOR && descriptor != StatusCodec.ENUM_DESCRIPTOR) {
                    if (descriptor.toCrystallize) {
                        crystallize = true;
                        break;
                    }
                    if (descriptor.usableCtor == null) {
                        crystallize = true;
                    }
                }
                field.setAccessible(true);
                listFields.add(field);
            }
            ++var8_13;
        }
        res = new ClassDescriptor(true, crystallize, usableCtor, isNoArgCtor, superClazz, listFields);
        return res;
    }

    static List<KeyData> listEncode(Object object, ClassDescriptor descriptor) {
        Collection<Field> descriptorValues = descriptor.mapFields.values();
        ArrayList<KeyData> res = new ArrayList<KeyData>(descriptorValues.size());
        for (Field field : descriptorValues) {
            try {
                Object val = StatusCodec.encode(field.get(object));
                res.add(new KeyData(field.getName(), val));
            }
            catch (Exception e) {
                System.err.println("OOPS " + e);
            }
        }
        return res;
    }

    public static Object encode(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        ClassDescriptor descriptor = StatusCodec.getDescriptorFor(clazz);
        if (descriptor == NULL_DESCRIPTOR) {
            return value;
        }
        if (descriptor == ENUM_DESCRIPTOR) {
            KeyData.CodedData codedEnum = new KeyData.CodedData(clazz.getName());
            codedEnum.content = StatusCodec.crystallize(value);
            ArrayList<KeyData> res = new ArrayList<KeyData>(1);
            res.add(new KeyData("", String.valueOf(value)));
            codedEnum.listKV = res;
            return codedEnum;
        }
        KeyData.CodedData codedRes = new KeyData.CodedData(clazz.getName());
        if (descriptor.decomposable) {
            codedRes.listKV = StatusCodec.listEncode(value, descriptor);
        }
        if (descriptor.toCrystallize) {
            codedRes.content = StatusCodec.crystallize(value);
        }
        return codedRes;
    }

    static byte[] crystallize(Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(value);
        return bos.toByteArray();
    }

    public static Object decode(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof KeyData.CodedData) {
            KeyData.CodedData codedData = (KeyData.CodedData)value;
            String className = codedData.className;
            Class<?> clazz = Class.forName(className);
            ClassDescriptor descriptor = StatusCodec.getDescriptorFor(clazz);
            if (descriptor.toCrystallize) {
                byte[] array = (byte[])codedData.content;
                ByteArrayInputStream bis = new ByteArrayInputStream(array);
                ObjectInputStream ois = new ObjectInputStream(bis);
                return ois.readObject();
            }
            if (descriptor.usableCtor != null) {
                Object res = null;
                if (descriptor.isNoargCtor) {
                    res = descriptor.usableCtor.newInstance(new Object[0]);
                    for (KeyData keyValue : codedData.listKV) {
                        String key = keyValue.getKey();
                        Field field = descriptor.mapFields.get(key);
                        if (field == null) continue;
                        Object valForField = StatusCodec.decode(keyValue.getRawValue());
                        field.set(res, valForField);
                    }
                } else {
                    int ix;
                    String[] names;
                    ConstructorProperties ctorProps = descriptor.usableCtor.getAnnotation(ConstructorProperties.class);
                    if (ctorProps != null) {
                        names = ctorProps.value();
                    } else {
                        Parameter[] parms = descriptor.usableCtor.getParameters();
                        if (!parms[0].isNamePresent()) {
                            throw new IllegalArgumentException("no way to recompose the object (code not compiled with named parameters options) :" + value);
                        }
                        names = new String[parms.length];
                        ix = 0;
                        while (ix < parms.length) {
                            names[ix] = parms[ix].getName();
                            ++ix;
                        }
                    }
                    Object[] args = new Object[names.length];
                    ix = 0;
                    while (ix < names.length) {
                        String name = names[ix];
                        for (KeyData keyData : codedData.listKV) {
                            if (!keyData.getKey().equals(name)) continue;
                            args[ix] = StatusCodec.decode(keyData.getRawValue());
                            break;
                        }
                        ++ix;
                    }
                    res = descriptor.usableCtor.newInstance(args);
                }
                return res;
            }
            throw new IllegalArgumentException("no way to recompose the object :" + value);
        }
        return value;
    }

    static List<KeyData> simpleKeyValueList(String rootName, KeyData.CodedData codedData) {
        ArrayList<KeyData> resList = new ArrayList<KeyData>();
        if (codedData.listKV == null) {
            return resList;
        }
        for (KeyData keyVal : codedData.listKV) {
            Object val = keyVal.getRawValue();
            String key = keyVal.getKey();
            String longName = key.length() == 0 ? rootName : String.valueOf(rootName) + '/' + key;
            if (val instanceof KeyData.CodedData) {
                List<KeyData> contentList = StatusCodec.asSimpleKeyValueList(longName, (KeyData.CodedData)val);
                resList.addAll(contentList);
                continue;
            }
            resList.add(new KeyData(longName, val));
        }
        return resList;
    }

    public static List<KeyData> asSimpleKeyValueList(String keyName, Object data) {
        if (data instanceof KeyData.CodedData) {
            return StatusCodec.simpleKeyValueList(keyName, (KeyData.CodedData)data);
        }
        ArrayList<KeyData> res = new ArrayList<KeyData>(1);
        res.add(new KeyData(keyName, data));
        return res;
    }

    static class ClassDescriptor {
        final boolean decomposable;
        final boolean toCrystallize;
        final Constructor usableCtor;
        final boolean isNoargCtor;
        final Class superClass;
        final LinkedHashMap<String, Field> mapFields;

        ClassDescriptor(boolean decomposable, boolean toCrystallize, Constructor usableCtor, boolean useNoargCtor, Class superClass, List<Field> fieldList) {
            this.decomposable = decomposable;
            this.toCrystallize = toCrystallize;
            this.usableCtor = usableCtor;
            this.isNoargCtor = useNoargCtor;
            this.superClass = superClass;
            if (fieldList != null) {
                this.mapFields = new LinkedHashMap();
                for (Field field : fieldList) {
                    this.mapFields.put(field.getName(), field);
                }
            } else {
                this.mapFields = null;
            }
        }

        public String toString() {
            return "ClassDescriptor{decomposable=" + this.decomposable + ", toCrystallize=" + this.toCrystallize + ", usableCtor=" + this.usableCtor + ", superClass=" + this.superClass + ", fieldList=" + this.mapFields.values() + '}';
        }
    }
}

