/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.IOException;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingAccessManager;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentMessagingLayer {
    private final BusMessageFilter filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private final BusApplicationLayer layer;
    private final AgentInfo agentInfo;

    protected AgentMessagingLayer(AgentInfo agentInfo) {
        if (agentInfo == null) {
            throw new RuntimeException("MessagingAccess cannot have null Agent");
        }
        this.agentInfo = agentInfo;
        this.layer = new BusApplicationLayer(agentInfo);
        MessagingAccessManager.addMessagingAccess(this);
        this.filterMessagesFromThisAgent = BusMessageFilter.messageOrigin(this.getAgentName()).not();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public String getAgentName() {
        return this.agentInfo.getName();
    }

    protected BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    protected void shutdownBusAccess() {
        this.layer.close();
        MessagingAccessManager.removeMessagingAccess(this);
    }

    public synchronized AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public synchronized void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public synchronized void addLogMessageListener(LogMessageListener listener, BusMessageFilter filter) {
        this.layer.addLogListener(listener, filter);
    }

    public synchronized void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public synchronized void addStatusMessageListener(StatusMessageListener listener, BusMessageFilter filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public synchronized void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public synchronized void addCommandMessageListener(CommandMessageListener listener, BusMessageFilter filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public synchronized void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public synchronized void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public synchronized void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public synchronized void sendLogMessage(LogMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.sendLogEvent(msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void sendStatusMessage(StatusMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        this.curLogger.debug((Object)("sending status " + msg), new String[0]);
        try {
            this.layer.sendStatus(msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        cmd.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.sendCommand(cmd, originator);
        }
        catch (IOException e) {
            if (e instanceof DestinationsException) {
                this.curLogger.warn((Object)"destination problem", (Throwable)e, new String[0]);
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
    }

    public synchronized void sendCommandReply(CommandReply reply) {
        reply.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.reply(reply);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }
}

