/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.IndirectMap;
import org.lsst.gruth.jutils.MapArgs;
import org.lsst.gruth.jutils.MethodsCalls;
import org.lsst.gruth.utils.Tracer;

public class EffectiveNode
extends ComponentNode<EffectiveNode> {
    public EffectiveNode(IndirectMap<String, Object> registry, Object name, String key, Object value) {
        super(registry, name, key, null, value);
    }

    public void adoptOrphans(IndirectMap<String, Object> registry, ArrayList<EffectiveNode> children, EffectiveNode parent) throws NullPointerException, IllegalArgumentException {
        for (ComponentNode componentNode : children) {
            componentNode.orphan = false;
            if (componentNode.parent == null) {
                if (componentNode.nodeDict != registry) {
                    registry.putAll(componentNode.getNodeDict());
                    componentNode.nodeDict = registry;
                }
            } else {
                throw new IllegalArgumentException("child added but is part of another node tree");
            }
            componentNode.parent = parent;
            componentNode.root = false;
        }
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

    public Object doInvoke(String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object support = this.getRealValue();
        return this.invocation(support, methodName, args);
    }

    private Object invocation(Object support, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (support != null) {
            Tracer.trace(Tracer.NODE_CALLS, "invocation:" + methodName + Arrays.toString(args));
            return MethodsCalls.invokeMethod(support, methodName, args);
        }
        return null;
    }

    public Object invokeOn(String objectName, String methodName, Object ... args) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object obj = this.getIndirect(objectName);
        return this.invocation(obj, methodName, args);
    }

    public void doCalls() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object curObj = this.getRealValue();
        if (curObj == null) {
            return;
        }
        if (this.calls != null) {
            ComponentNode topCalls = this.calls;
            ArrayList children = topCalls.getChildren();
            if (children == null) {
                System.out.println("empty calls node");
                return;
            }
            for (ComponentNode child : children) {
                String methodName = child.getName();
                Map attrib = child.getAttributes();
                if (attrib == null) {
                    this.invocation(curObj, methodName, new Object[0]);
                    continue;
                }
                MapArgs mapArgs = (MapArgs)attrib;
                if (!(this.nodeDict instanceof IndirectMap)) continue;
                Object[] args = mapArgs.asFullArray(this.nodeDict);
                this.invocation(curObj, methodName, args);
            }
        }
    }

    public void doCallsFromTop() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.doCalls();
        ArrayList children = this.getChildren();
        if (children == null) {
            return;
        }
        for (EffectiveNode child : children) {
            child.doCallsFromTop();
        }
    }

    public void doCallsFromBase() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        for (EffectiveNode child : this.getChildren()) {
            child.doCalls();
        }
        this.doCalls();
    }
}

