/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.Iterator;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.Status;

public class EncodedDataStatus
extends Status
implements Iterable<EncodedDataStatus> {
    private static final long serialVersionUID = 3510287510951431305L;
    private EncodedDataStatus nextStatus;
    private final KVList content;
    private final long dataTimeStamp;

    public EncodedDataStatus(long timestampArg, KVList content) {
        this.dataTimeStamp = timestampArg;
        this.content = content;
    }

    public EncodedDataStatus(KVList content) {
        this(System.currentTimeMillis(), content);
    }

    public EncodedDataStatus(long timestamp, String key, Object value) {
        this(timestamp, new KVList(key, value));
    }

    public EncodedDataStatus(String key, Object value) {
        this(new KVList(key, value));
    }

    public void addStatus(EncodedDataStatus next) {
        EncodedDataStatus dataStatus2 = this;
        while (dataStatus2.nextStatus != null) {
            dataStatus2 = dataStatus2.nextStatus;
        }
        dataStatus2.nextStatus = next;
    }

    public void setNext(EncodedDataStatus next) {
        this.nextStatus = next;
    }

    public static EncodedDataStatus addData(EncodedDataStatus current, long timeStamp, String name, Object value) {
        EncodedDataStatus res = new EncodedDataStatus(timeStamp, name, value);
        res.setNext(current);
        current = res;
        return res;
    }

    @Override
    public Iterator<EncodedDataStatus> iterator() {
        return new Iterator<EncodedDataStatus>(){
            EncodedDataStatus coming;
            {
                this.coming = EncodedDataStatus.this;
            }

            @Override
            public boolean hasNext() {
                return this.coming != null;
            }

            @Override
            public EncodedDataStatus next() {
                EncodedDataStatus res = this.coming;
                this.coming = res.nextStatus;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public KVList getContent() {
        return this.content;
    }

    public long getDataTimestamp() {
        return this.dataTimeStamp;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " {" + "content=" + this.content + ", dataTimeStamp=" + this.dataTimeStamp + "} ";
    }
}

