/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Mode;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.LocalCommandDictionary;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.RollBackException;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.startup.NodeLookup;
import org.lsst.ccs.utilities.functions.Cocoon;
import org.lsst.ccs.utilities.functions.MutableReference;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.EffectiveNode;

public class NodeModularSubsystem
extends Subsystem {
    private ComponentLookupService lookup;
    private Configurable mainObject;
    private Context context;
    private ArrayList<ViewValue> preOrderComponentList = new ArrayList();
    private List<ViewValue> preOrderUnmodifiableView = Collections.unmodifiableList(this.preOrderComponentList);

    public NodeModularSubsystem(String name, ConfigurationProxy proxy, EffectiveNode topNode) {
        Objects.requireNonNull(name);
        this.setName(name);
        this.context = new Context();
        this.context.setSubsystem((Subsystem)this);
        this.context.setSubsystemName(name);
        this.configurationProxy = proxy;
        proxy.setSubsystem((Subsystem)this);
        this.lookup = new NodeLookup(topNode);
        this.realRegisterNodes(topNode);
        this.mainObject = (Configurable)topNode.getRealValue();
        this.doInitComponents();
    }

    public boolean isSlave() {
        return true;
    }

    public ComponentLookupService getLookup() {
        return this.lookup;
    }

    public List<ViewValue> getPreOrderComponentList() {
        return this.preOrderUnmodifiableView;
    }

    private void realRegisterNodes(EffectiveNode node) {
        String key = node.getKey();
        Object value = node.getRealValue();
        this.preOrderComponentList.add(new ViewValue(key, value));
        ArrayList children = node.getChildren();
        if (children != null) {
            for (EffectiveNode child : children) {
                this.realRegisterNodes(child);
            }
        }
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable)value;
            configurable.setEnvironment(new Configurable.Environment(key, configurable, this.configurationProxy, this.lookup));
        }
    }

    private void doInitComponents() {
        this.mainObject.proceduralWalk(Configurable::init, null);
    }

    public void doStart() {
        this.mainObject.proceduralWalk(Configurable::start, null);
    }

    public void postStart() throws HardwareException {
        this.callPostStart(this.mainObject);
    }

    private void callPostStart(Configurable goal) throws HardwareException {
        goal.postStart();
        for (Configurable configurable : goal.listChildren()) {
            this.callPostStart(configurable);
        }
    }

    public void doShutdown() {
        log.info((Object)("Subsystem " + this.getName() + " shutdown starting"), new String[0]);
        this.mainObject.proceduralWalk(Configurable::shutdownNow, null);
    }

    protected Configurable getCommandDestination(String commandDestination) {
        Configurable configurable = null;
        String configurableName = "main";
        if (commandDestination.contains("/")) {
            configurableName = commandDestination.substring(commandDestination.indexOf("/") + 1);
        }
        if ((configurable = (Configurable)this.lookup.getComponentByName(configurableName)) == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName + " for command destination");
        }
        return configurable;
    }

    protected LocalCommandDictionary getCommandBuilder(Object object) {
        if (object instanceof Configurable) {
            Configurable configurable = (Configurable)object;
            Configurable.Environment env = configurable.getEnvironment();
            LocalCommandDictionary res = env.getCommandBuilder();
            return res;
        }
        return super.getCommandBuilder(object);
    }

    protected Subsystem.DictionarySearchResult searchForDictionary(org.lsst.ccs.bus.Command command) throws CommandInvocationException {
        Configurable goal = this.getCommandDestination(command.getDestination());
        LocalCommandDictionary localDict = this.getCommandBuilder(goal);
        if (goal.getEnvironment().getNameOfComponent().equals("main")) {
            Subsystem.DictionarySearchResult searchDict = this.searchForDictionary(false, command, goal, localDict);
            if (searchDict == null) {
                return super.searchForDictionary(command);
            }
            if (searchDict.method != null) {
                return searchDict;
            }
            return super.searchForDictionary(command);
        }
        return this.searchForDictionary(true, command, goal, localDict);
    }

    @Command(description="halt", type=Command.CommandType.ABORT)
    public void abort() {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.ABORT)
    public void abort(long expectedMaxDelay) {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long expectedMaxDelay) throws HardwareException, InterruptedException {
        this.stop(expectedMaxDelay);
        int step = 10;
        long fracDelay = expectedMaxDelay / (long)step;
        HardwareException lastExc = null;
        int i = 0;
        while (i < step) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                ++i;
            }
        }
        throw lastExc;
    }

    public void checkHardware() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.treeWalk(configurable -> {
            block3: {
                if (configurable instanceof HardwareController) {
                    try {
                        return ((HardwareController)configurable).checkHardware();
                    }
                    catch (HardwareException e) {
                        mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + " fails check", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                        if (!e.isFatal()) break block3;
                        return TreeWalkerDiag.STOP;
                    }
                }
            }
            return TreeWalkerDiag.GO;
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStarted();
                }
                catch (HardwareException e) {
                    mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + "not started ", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                }
            }
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        MutableReference excList = new MutableReference();
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStopped();
                }
                catch (HardwareException e) {
                    mutableReference.reference = new HardwareException(String.valueOf(configurable.toString()) + "not stopped ", (Throwable)e, (HardwareException)((Object)((Object)mutableReference.reference)));
                }
            }
        }, null);
        if (excList.reference != null) {
            throw (HardwareException)((Object)excList.reference);
        }
    }

    @Deprecated
    @Command(description="will create a new context for modifying parameters (engineering mode)", type=Command.CommandType.ACTION)
    public final synchronized void newConfigurationContext() {
        if (this.innerState.getMode().equals((Object)Mode.NORMAL)) {
            this.switchToEngineeringMode();
        }
        this.configurationProxy.startNewConfigurationContext();
    }

    @Command(description="@Deprecated: registers a new configuration with name and tag", type=Command.CommandType.CONFIGURATION)
    @Deprecated
    public final void register(@Argument(name="configurationName", description="The Name of the Configuration") String configurationName, @Argument(name="tag", description="The new tag name", defaultValue="") String tag) throws IOException {
        this.configurationProxy.registerConfiguration(configurationName, tag);
    }

    @Deprecated
    @Command(description="registers a new configuration with a name", type=Command.CommandType.CONFIGURATION)
    public final void registerConfiguration(@Argument(name="configurationName", description="The Name of the Configuration") String configurationName) throws IOException {
        this.configurationProxy.registerConfiguration(configurationName);
    }

    @Command(description="Saves a new configuration with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveConfiguration(@Argument(name="configurationName", description="The Name of the Configuration") String configurationName) throws IOException {
        this.configurationProxy.registerConfiguration(configurationName);
    }

    @Command(description="Overwrites the current configuration", type=Command.CommandType.CONFIGURATION)
    public final void saveConfiguration() throws IOException {
        this.configurationProxy.registerConfiguration(this.configurationProxy.getConfigurationName());
    }

    @Command(description="will drop context for modifying parameters (engineering mode)", type=Command.CommandType.CONFIGURATION)
    public void dropConfigurationContext() {
        this.configurationProxy.dropModifications();
    }

    @Command(description="loads a new configuration with a name", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(@Argument(name="configurationName", description="The Name of the Configuration") String config) throws Exception {
        ConfigProfile oldProfile;
        Properties configProps;
        block4: {
            if (ConfigUtils.isAPath((String)config)) {
                throw new IllegalArgumentException("loadConfiguration requires a configuration name, not a path");
            }
            this.configurationProxy.startNewConfigurationContext();
            configProps = null;
            oldProfile = ((LocalConfigurationProxy)this.configurationProxy).getCurrentProfile();
            String configName = ConfigUtils.baseNameFromNames((String)oldProfile.getSubsystemName(), (String)config, (String)oldProfile.getTag());
            try {
                configProps = ((LocalConfigurationProxy)this.configurationProxy).getWriterProvider().getConfigurationProperties(configName);
            }
            catch (IllegalArgumentException ex) {
                if (config.isEmpty()) break block4;
                throw ex;
            }
        }
        ConfigProfile newProfile = Factories.createConfigProfile((SubsystemDescription)oldProfile.getSubsystemDescription(), (String)oldProfile.getName(), (String)oldProfile.getTag(), (String)oldProfile.getUserName(), (int)oldProfile.getLevel());
        if (configProps != null && !configProps.isEmpty()) {
            newProfile.mergeProperties(configProps);
        }
        this.switchConfiguration(oldProfile, newProfile);
        this.configurationProxy.saveModifications(config);
    }

    @Command(description="loads the default configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration() throws Exception {
        this.loadConfiguration("");
    }

    public void switchConfiguration(ConfigProfile oldProfile, ConfigProfile newProfile) throws Exception {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        Map mapChanges = newProfile.getConfigurationMap();
        Map oldMap = oldProfile.getConfigurationMap();
        ArrayList changedValues = new ArrayList();
        mainModule.proceduralWalk(null, Cocoon.consumer(arg_0 -> this.lambda$3(mapChanges, oldMap, oldProfile, changedValues, arg_0)));
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$3(Map var1_1, Map var2_2, ConfigProfile var3_3, List var4_4, Configurable configurable) throws Exception {
        block11: {
            name = configurable.getName();
            list = (List)var1_1.get(name);
            oldList = (List<T>)var2_2.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            try {
                if (list != null) {
                    for (ParameterConfiguration parmConfig : list) {
                        oldList.remove(parmConfig);
                        path = parmConfig.getPath();
                        parameterName = path.getParameterName();
                        value = parmConfig.getValue();
                        oldValue = var3_3.getValueAt(path, PackCst.STILL_VALID);
                        if (oldValue.equals(value)) continue;
                        if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                            throw new IllegalArgumentException(path + "not modifiable at runtime");
                        }
                        histElement = new String[]{name, parameterName, oldValue};
                        configurable.change(parameterName, (Object)value);
                        var4_4.add(0, histElement);
                    }
                }
                for (ParameterConfiguration parmConfig : oldList) {
                    path = parmConfig.getPath();
                    parameterName = path.getParameterName();
                    value = parmConfig.getDescription().getDefaultValue();
                    oldValue = var3_3.getValueAt(path, PackCst.STILL_VALID);
                    if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                        throw new IllegalArgumentException(path + "not modifiable at runtime");
                    }
                    histElement = new String[]{name, parameterName, oldValue};
                    configurable.change(parameterName, (Object)value);
                    var4_4.add(0, histElement);
                }
                break block11;
            }
            catch (Exception exc) {
                ** for (historyElement : var4_4)
            }
lbl-1000:
            // 1 sources

            {
                cpName = historyElement[0];
                parmName = historyElement[1];
                histValue = historyElement[2];
                try {
                    cp = (Configurable)this.lookup.getComponentByName(cpName);
                    cp.change(parmName, (Object)histValue);
                    continue;
                }
                catch (Exception rollbackExc) {
                    throw new RollBackException((Throwable)rollbackExc, cpName, parmName, histValue);
                }
            }
lbl45:
            // 1 sources

            throw exc;
        }
    }
}

