/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.scripting.ScriptingTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;

public abstract class CCS {
    private static boolean throwExceptions = true;
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.scripting");
    private static final MessagingFactory fac = MessagingFactory.getInstance().forSubsystem(Names.almostUniqueAgentName((String)"CCS-script"));
    private static final HashMap<Integer, ArrayList<ScriptingSubsystemWrapper>> subsystemsForThread = new HashMap();
    private static final HashMap<Integer, ArrayList<ScriptingStatusBusListenerWrapper>> listenersForThread = new HashMap();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            Integer id = nextId.getAndIncrement();
            subsystemsForThread.put(id, new ArrayList());
            listenersForThread.put(id, new ArrayList());
            return id;
        }
    };

    private CCS() {
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        CCS.throwExceptions = throwExceptions;
    }

    public static boolean getThrowExceptions() {
        return throwExceptions;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String subsystemName) throws RuntimeException {
        ScriptingSubsystemWrapper wrapper = new ScriptingSubsystemWrapper(subsystemName);
        subsystemsForThread.get(threadId.get()).add(wrapper);
        logger.finest((Object)("Adding subsystem " + subsystemName + " to Thread " + threadId.get() + " for a total of " + subsystemsForThread.get(threadId.get()).size()), new String[0]);
        return wrapper;
    }

    public static void cleanUp() {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.remove(threadId.get());
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            CCS.cleanupListener(l);
        }
        listeners.clear();
        ArrayList<ScriptingSubsystemWrapper> subsystems = subsystemsForThread.remove(threadId.get());
        for (ScriptingSubsystemWrapper s : subsystems) {
            s.close();
        }
        subsystems.clear();
        logger.finest((Object)("**** Cleaned up on ThreadLocal " + threadId.get() + " " + listeners.size() + " " + subsystems.size()), new String[0]);
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener) {
        ScriptingStatusBusListenerWrapper busListener = new ScriptingStatusBusListenerWrapper(listener);
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        listeners.add(busListener);
        logger.finest((Object)("Adding listener to Thread " + threadId.get() + " for a total of " + listeners.size()), new String[0]);
        fac.addStatusListener((StatusListens)busListener, "");
    }

    public static void removeStatusBusListener(ScriptingStatusBusListener listener) {
        CCS.removeStatusBusListener(listener, threadId.get());
    }

    private static void removeStatusBusListener(ScriptingStatusBusListener listener, Integer id) {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(id);
        ScriptingStatusBusListenerWrapper toDelete = null;
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            if (l.getScriptingStatusBusListener() != listener) continue;
            CCS.cleanupListener(l);
            toDelete = l;
            logger.finest((Object)("Removed listener on thread " + id + " for a total of " + listeners.size()), new String[0]);
            break;
        }
        if (toDelete != null) {
            listeners.remove(toDelete);
        } else {
            logger.warning((Object)("Could not remove listener " + listener + " on thread " + id), new String[0]);
        }
    }

    private static void cleanupListener(ScriptingStatusBusListenerWrapper listener) {
        fac.removeStatusListener((StatusListens)listener);
    }

    @Deprecated
    public static ScriptingStatusBusMessage waitForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) throws ScriptingTimeoutException {
        Object reply;
        block6: {
            SynchronousQueue<Object> synchQueue = new SynchronousQueue<Object>();
            ScriptingStatusBusListenerImpl innerListener = new ScriptingStatusBusListenerImpl(filter, synchQueue, threadId.get());
            CCS.addStatusBusListener(innerListener);
            reply = null;
            try {
                try {
                    reply = synchQueue.poll(timeout, TimeUnit.SECONDS);
                    if (reply instanceof ScriptingTimeoutException) {
                        throw new ExecutionException("Timeout exception", (ScriptingTimeoutException)reply);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CCS.removeStatusBusListener(innerListener);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CCS.removeStatusBusListener(innerListener);
                throw throwable;
            }
            CCS.removeStatusBusListener(innerListener);
        }
        return (ScriptingStatusBusMessage)reply;
    }

    public static Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) {
        ScriptingStatusBusListenerImpl innerListener = new ScriptingStatusBusListenerImpl(filter, timeout, threadId.get());
        CCS.addStatusBusListener(innerListener);
        return new FutureTask<ScriptingStatusBusMessage>((Callable)innerListener){

            @Override
            public ScriptingStatusBusMessage get() throws InterruptedException, ExecutionException {
                this.run();
                ScriptingStatusBusMessage msg = (ScriptingStatusBusMessage)super.get();
                return msg;
            }

            @Override
            public ScriptingStatusBusMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.run();
                ScriptingStatusBusMessage msg = (ScriptingStatusBusMessage)super.get(timeout, unit);
                return msg;
            }
        };
    }

    static class ScriptingStatusBusListenerImpl
    implements ScriptingStatusBusListener,
    Callable<ScriptingStatusBusMessage> {
        private final ScriptingStatusBusMessageFilter filter;
        private final BlockingQueue<Object> queue;
        private final Timer timeoutTimer = new Timer();
        private boolean cleanedUp = false;
        private final Integer id;

        ScriptingStatusBusListenerImpl(final ScriptingStatusBusMessageFilter filter, int timeout, Integer id) {
            this.queue = new LinkedTransferQueue<Object>();
            this.filter = filter;
            this.id = id;
            this.timeoutTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cleanUp();
                    ScriptingTimeoutException ex = new ScriptingTimeoutException("Timeout listening for filtered events " + filter.toString());
                    queue.offer(ex);
                }
            }, (long)timeout * 1000L);
        }

        private void cleanUp() {
            if (!this.cleanedUp) {
                CCS.removeStatusBusListener(this, this.id);
                this.cleanedUp = true;
            }
        }

        ScriptingStatusBusListenerImpl(ScriptingStatusBusMessageFilter filter, SynchronousQueue<Object> queue, Integer id) {
            this.filter = filter;
            this.queue = queue;
            this.id = id;
        }

        @Override
        public void onStatusBusMessage(ScriptingStatusBusMessage bm) {
            if (this.queue.isEmpty() && this.filter.accept(bm)) {
                this.timeoutTimer.cancel();
                logger.finest((Object)("Found match with " + bm), new String[0]);
                this.queue.offer(bm);
                this.cleanUp();
            }
        }

        @Override
        public ScriptingStatusBusMessage call() throws Exception {
            Object reply = null;
            try {
                try {
                    reply = this.queue.take();
                    if (reply instanceof ScriptingTimeoutException) {
                        throw new ExecutionException("Timeout exception", (ScriptingTimeoutException)reply);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Interruption Exception", e);
                }
            }
            finally {
                this.cleanUp();
            }
            return (ScriptingStatusBusMessage)reply;
        }
    }

    static class ScriptingStatusBusListenerWrapper
    implements StatusListener {
        private final ScriptingStatusBusListener scriptingListener;

        ScriptingStatusBusListenerWrapper(ScriptingStatusBusListener scriptingListener) {
            this.scriptingListener = scriptingListener;
        }

        public void onStatus(BusMessage bm) {
            this.scriptingListener.onStatusBusMessage(new ScriptingStatusBusMessage(bm));
        }

        protected ScriptingStatusBusListener getScriptingStatusBusListener() {
            return this.scriptingListener;
        }
    }
}

