/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.startup.SubsystemBootFromBus;
import org.lsst.ccs.startup.SubsystemBootFromStream;

public class SubsystemBoot {
    static String descriptionName;
    static String configurationName;

    public static void main(String[] args) throws Exception {
        block9: {
            block11: {
                block10: {
                    block7: {
                        block8: {
                            SubsystemBoot.parseArgsCLI(args);
                            if (descriptionName != null) break block7;
                            if (configurationName != null) break block8;
                            SubsystemBootFromBus.main(new String[0]);
                            break block9;
                        }
                        throw new IllegalArgumentException("no description specification");
                    }
                    if (!descriptionName.contains(".")) break block10;
                    if (configurationName != null) {
                        SubsystemBootFromStream.main(new String[]{descriptionName, configurationName});
                    } else {
                        SubsystemBootFromStream.main(new String[]{descriptionName});
                    }
                    break block9;
                }
                if (configurationName == null) break block11;
                if (configurationName.contains(".")) {
                    throw new UnsupportedOperationException("loading description from bus and configuration locally");
                }
                String[] names = configurationName.split("_");
                switch (names.length) {
                    case 1: {
                        SubsystemBootFromBus.main(new String[]{descriptionName, configurationName});
                        break block9;
                    }
                    case 2: {
                        SubsystemBootFromBus.main(new String[]{descriptionName, names[0], names[1]});
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("too many underscores in " + configurationName);
                    }
                }
            }
            SubsystemBootFromBus.main(new String[]{descriptionName});
        }
    }

    static void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("c", "configuration", true, "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, true);
            if (line.hasOption("help")) {
                SubsystemBoot.usageCLI(commandLineOptions);
            } else {
                descriptionName = line.getOptionValue("description");
                configurationName = line.getOptionValue("configuration");
            }
        }
        catch (Exception exception) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
        System.exit(0);
    }
}

