/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.DuplicateBusNameException;
import org.lsst.ccs.bus.EncodedDataStatus;
import org.lsst.ccs.bus.EncodedStatusListens;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.KeyData;
import org.lsst.ccs.bus.KeyValueStatusListener;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;
import org.lsst.ccs.bus.ProvidesDisconnectionInformation;
import org.lsst.ccs.bus.SerializedDataStatusListener;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.utilities.logging.Logger;

public class BusApplicationLayer {
    protected final String subsystemName;
    protected final BusMessagingLayer busMessagingLayer;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.layer");
    protected boolean duplicateNamesAllowed = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.duplicateAgentNameAllowed", "false").toUpperCase());
    String token = UUID.randomUUID().toString();
    private final MembershipMultiplexor[] membershipMultiplexors = new MembershipMultiplexor[Bus.values().length];
    IdentityHashMap<CommandListener, BusMessageForwarder> commandForwarderMap = new IdentityHashMap();
    IdentityHashMap<LogListener, BusMessageForwarder> logForwarderMap = new IdentityHashMap();
    IdentityHashMap<StatusListens, BusMessageForwarder> statusForwarderMap = new IdentityHashMap();

    public BusApplicationLayer(String subsystemName, BusMessagingLayer busMessagingLayer) {
        this.subsystemName = subsystemName;
        this.busMessagingLayer = busMessagingLayer;
        int i = 0;
        while (i < Bus.values().length) {
            this.membershipMultiplexors[i] = new MembershipMultiplexor();
            ++i;
        }
        if (!this.duplicateNamesAllowed && busMessagingLayer instanceof ProvidesDisconnectionInformation) {
            this.addMembershipListener(new BusMembershipListener(){

                @Override
                public void connecting(String agentName, String otherInfos) {
                }

                @Override
                public void disconnecting(String agentName, String otherInfos) {
                }

                @Override
                public void anormalEvent(Exception exc) {
                    if (exc instanceof DuplicateBusNameException) {
                        throw new IllegalArgumentException(exc);
                    }
                }
            }, Bus.COMMAND);
        }
    }

    public BusMessagingLayer getBusMessagingLayer() {
        return this.busMessagingLayer;
    }

    public String getToken() {
        return this.token;
    }

    public void registerToCommand() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.COMMAND);
    }

    public void registerToStatus() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.STATUS);
    }

    public void registerToLog() throws IOException {
        this.busMessagingLayer.register(this.subsystemName, Bus.LOG);
    }

    protected String[] parseDestination(String destination) {
        String[] dests = destination.split(",");
        int ix = 0;
        while (ix < dests.length) {
            String dest = dests[ix];
            if ("*".equals(dest)) {
                dests = new String[]{};
                break;
            }
            if (dest.contains("/")) {
                dests[ix] = dest.substring(0, dest.indexOf("/"));
            }
            ++ix;
        }
        return dests;
    }

    public void sendCommand(Command cmd) throws IOException {
        String[] destinations = this.parseDestination(cmd.getDestination());
        cmd.setKey(this.token);
        if (cmd.getOrigin() == null) {
            cmd.setOrigin(this.subsystemName);
        }
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(UUID.randomUUID().toString());
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destinations);
    }

    public void sendStatus(Status status) throws IOException {
        if (status.getOrigin() == null) {
            status.setOrigin(this.subsystemName);
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.STATUS, status, new String[0]);
    }

    public void sendLogEvent(LogEvent evt) throws IOException {
        if (evt.getOrigin() == null) {
            evt.setOrigin(this.subsystemName);
        }
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.LOG, evt, new String[0]);
    }

    public void reply(CommandAckOrReply cmd) throws IOException {
        if (cmd.getOrigin() == null) {
            cmd.setOrigin(this.subsystemName);
        }
        String destination = cmd.getDestination();
        this.busMessagingLayer.sendMessage(this.subsystemName, Bus.COMMAND, cmd, destination);
    }

    void addMembershipListener(BusMembershipListener l, Bus bus) {
        this.membershipMultiplexors[bus.ordinal()].addMembershipListener(l, bus);
    }

    void removeMembershipListener(BusMembershipListener l, Bus bus) {
        this.membershipMultiplexors[bus.ordinal()].removeMembershipListener(l);
    }

    public void addCommandListener(CommandListener l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToCommand(l), Bus.COMMAND);
    }

    public void removeCommandListener(CommandListener l) {
        BusMessageForwarder forwarder = this.commandForwarderMap.remove(l);
        if (forwarder != null) {
            this.busMessagingLayer.removeMessageListener(this.subsystemName, forwarder, Bus.COMMAND);
        }
    }

    public void addStatusListener(StatusListens l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToStatus(l), Bus.STATUS);
    }

    public void removeStatusListener(StatusListens l) {
        BusMessageForwarder forwarder = this.statusForwarderMap.remove(l);
        if (forwarder != null) {
            this.busMessagingLayer.removeMessageListener(this.subsystemName, forwarder, Bus.STATUS);
        }
    }

    public void addLogListener(LogListener l) {
        this.busMessagingLayer.addMessageListener(this.subsystemName, new ForwarderToLog(l), Bus.LOG);
    }

    public void removeLogListener(LogListener l) {
        BusMessageForwarder forwarder = this.logForwarderMap.remove(l);
        if (forwarder != null) {
            this.busMessagingLayer.removeMessageListener(this.subsystemName, forwarder, Bus.LOG);
        }
    }

    public List<String> connectedToCommand() {
        if (this.busMessagingLayer instanceof ProvidesDisconnectionInformation) {
            return ((ProvidesDisconnectionInformation)((Object)this.busMessagingLayer)).getConnectedNames(Bus.COMMAND);
        }
        throw new UnsupportedOperationException("getConnectedNames not supported by this transport layer");
    }

    public void close() {
        this.busMessagingLayer.closeFor(this.subsystemName, new Bus[0]);
    }

    protected class ForwarderToCommand
    implements BusMessageForwarder {
        CommandListener listener;

        ForwarderToCommand(CommandListener listener) {
            this.listener = listener;
            BusApplicationLayer.this.commandForwarderMap.put(listener, this);
        }

        @Override
        public void update(BusMessage message) {
            if (message instanceof CommandReply) {
                this.listener.onReply((CommandReply)message);
            } else if (message instanceof CommandAck) {
                this.listener.onAck((CommandAck)message);
            } else if (message instanceof Command) {
                Command cmd = (Command)message;
                try {
                    this.listener.onCommand(cmd);
                }
                catch (Throwable throwable) {
                    log.error((Object)("on command :" + throwable), new String[0]);
                }
            }
        }
    }

    protected class ForwarderToLog
    implements BusMessageForwarder {
        LogListener listener;

        ForwarderToLog(LogListener listener) {
            this.listener = listener;
            BusApplicationLayer.this.logForwarderMap.put(listener, this);
        }

        @Override
        public void update(BusMessage message) {
            if (message instanceof LogEvent) {
                this.listener.onLog((LogEvent)message);
            }
        }
    }

    public class ForwarderToStatus
    implements BusMessageForwarder {
        final StatusListens listener;
        final boolean isEncodedListener;
        final boolean isKeyValueListener;
        final boolean isDataListener;
        final boolean isCrystallizedListener;

        public ForwarderToStatus(StatusListens listener) {
            this.listener = listener;
            this.isEncodedListener = listener instanceof EncodedStatusListens;
            this.isKeyValueListener = listener instanceof KeyValueStatusListener;
            this.isDataListener = listener instanceof DataStatusListener;
            this.isCrystallizedListener = listener instanceof SerializedDataStatusListener;
            BusApplicationLayer.this.statusForwarderMap.put(listener, this);
        }

        @Override
        public void update(BusMessage message) {
            if (message instanceof EncodedDataStatus && this.isEncodedListener) {
                EncodedDataStatus status = (EncodedDataStatus)message;
                String source = status.getOrigin();
                for (EncodedDataStatus dataStatus : status) {
                    long timeStamp = dataStatus.getDataTimestamp();
                    KVList list = dataStatus.getContent();
                    for (KeyData keyData : list) {
                        Optional crysta;
                        Optional optObj;
                        String key = keyData.getKey();
                        if (this.isDataListener && (optObj = keyData.getValue()).isPresent()) {
                            ((DataStatusListener)this.listener).onDataArrival(source, timeStamp, key, optObj.get());
                        }
                        if (this.isKeyValueListener) {
                            int id = keyData.hashCode();
                            List detailsList = keyData.getContentAsList();
                            for (KeyData detaileddata : detailsList) {
                                String complexKey = detaileddata.getKey();
                                Optional optional = detaileddata.getValue();
                                if (!optional.isPresent()) continue;
                                ((KeyValueStatusListener)this.listener).onKeyValueStatusDecomposition(source, timeStamp, complexKey, optional.get(), id);
                            }
                        }
                        if (!this.isCrystallizedListener || !(crysta = keyData.getCrystallizedData()).isPresent()) continue;
                        ((SerializedDataStatusListener)this.listener).onSerializedDataArrival(source, timeStamp, key, (byte[])crysta.get());
                    }
                }
            } else if (this.listener instanceof StatusListener) {
                ((StatusListener)this.listener).onStatus(message);
            }
        }
    }

    private class MembershipMultiplexor
    implements BusMembershipListener {
        private final List<BusMembershipListener> listenerList = new CopyOnWriteArrayList<BusMembershipListener>();

        private MembershipMultiplexor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMembershipListener(BusMembershipListener l, Bus bus) {
            if (BusApplicationLayer.this.busMessagingLayer instanceof ProvidesDisconnectionInformation) {
                MembershipMultiplexor membershipMultiplexor = this;
                synchronized (membershipMultiplexor) {
                    if (((ProvidesDisconnectionInformation)((Object)BusApplicationLayer.this.busMessagingLayer)).getBusMembershipListener(bus) == null) {
                        ((ProvidesDisconnectionInformation)((Object)BusApplicationLayer.this.busMessagingLayer)).setMembershipListener(this, bus);
                    }
                }
            } else {
                throw new UnsupportedOperationException("addMembershipListener not supported");
            }
            this.listenerList.add(l);
        }

        private void removeMembershipListener(BusMembershipListener l) {
            this.listenerList.remove(l);
        }

        @Override
        public void connecting(String agentName, String otherInfos) {
            for (BusMembershipListener l : this.listenerList) {
                l.connecting(agentName, otherInfos);
            }
        }

        @Override
        public void disconnecting(String agentName, String otherInfos) {
            for (BusMembershipListener l : this.listenerList) {
                l.disconnecting(agentName, otherInfos);
            }
        }

        @Override
        public void anormalEvent(Exception exc) {
            for (BusMembershipListener l : this.listenerList) {
                l.anormalEvent(exc);
            }
        }
    }
}

