/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.ActionCommandStillRunning;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.AlarmState;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.ClosingStateException;
import org.lsst.ccs.CommandState;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.InvocationListener;
import org.lsst.ccs.InvocationVetoException;
import org.lsst.ccs.Mode;
import org.lsst.ccs.Phase;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SystemState;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.AgentPresenceManager;
import org.lsst.ccs.bus.Alarm;
import org.lsst.ccs.bus.AlarmClear;
import org.lsst.ccs.bus.AlarmOnStateChange;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.CCSVersions;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.DetailLevel;
import org.lsst.ccs.bus.DistributionInfo;
import org.lsst.ccs.bus.EncodedDataStatus;
import org.lsst.ccs.bus.HeartBeatStatus;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.NegativeAck;
import org.lsst.ccs.bus.PingStatus;
import org.lsst.ccs.bus.PositiveAck;
import org.lsst.ccs.bus.StateChangeNotification;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusForEnd;
import org.lsst.ccs.bus.StatusForStart;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.locking.LockArbitrator;
import org.lsst.ccs.bus.utils.LogBusHandler;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.LocalBuilders;
import org.lsst.ccs.command.LocalCommandDictionary;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;
import org.lsst.ccs.utilities.tracers.Names;

public class Subsystem
implements CommandListener,
StatusListener,
CommandExecutor {
    static String revision = "$Rev: 34798 $";
    protected State innerState = new State();
    protected volatile boolean initializing = true;
    protected volatile boolean closing = false;
    protected ThreadGroup commandGroup;
    protected ThreadGroup ancillaryGroup;
    AtomicInteger activeThreads = new AtomicInteger(0);
    Thread currentActionThread;
    protected final Object actionMonitor = new Object();
    protected final Object commandMonitor = new Object();
    protected volatile boolean waitingForCommandTermination;
    ArrayList<SignalThread> listSignalThreads = new ArrayList();
    Iterable<SignalThread> signalThreadsIterable = new Iterable<SignalThread>(){

        @Override
        public Iterator<SignalThread> iterator() {
            return new Iterator(){
                Iterator<SignalThread> inIterator;
                SignalThread nextThread;
                {
                    this.inIterator = (this).Subsystem.this.listSignalThreads.iterator();
                    this.nextThread = this.getNext();
                }

                @Override
                public boolean hasNext() {
                    return this.nextThread != null;
                }

                public SignalThread next() {
                    SignalThread res = this.nextThread;
                    this.nextThread = this.getNext();
                    return res;
                }

                SignalThread getNext() {
                    if (this.inIterator.hasNext()) {
                        SignalThread coming = this.inIterator.next();
                        if (!coming.isAlive()) {
                            this.inIterator.remove();
                            (this).Subsystem.this.activeThreads.getAndDecrement();
                            return this.getNext();
                        }
                        return coming;
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    };
    protected final Object signalsMonitor = new Object();
    protected Thread initThread;
    Object initThreadMonitor = new Object();
    protected volatile boolean forceShutdown = false;
    protected static Logger log;
    protected MessagingFactory fac = MessagingFactory.getInstance();
    protected String commandBusSelector = null;
    protected String statusBusSelector = null;
    protected boolean inTestContext = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false").toUpperCase());
    protected boolean startInEngineeringMode = this.inTestContext && "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.startInEngineeringMode", "false").toUpperCase());
    protected ConfigurationProxy configurationProxy = ConfigurationProxy.NONE;
    protected LogBusHandler logBusHandler;
    protected LocalCommandDictionary commandBuilder;
    String name = "";
    String configuration = "";
    String tag = "";
    boolean listeningToStatus = false;
    volatile int statusBroadcastPeriod = 5;
    protected volatile Thread statusBroadcasterThread = null;
    protected volatile Object statusBroadcasterLock = new Object();
    protected Map<String, LockArbitrator.LockOwnerInfo> locks = new HashMap<String, LockArbitrator.LockOwnerInfo>();
    @Deprecated
    protected static ThreadLocal<Subsystem> currentSubsystem;
    public static final ThreadLocal<CurrentCommandContext> LOCAL_EXECUTION_INFO;
    private final Agent agent;
    static MethodHandles.Lookup lookup;

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        currentSubsystem = new ThreadLocal();
        LOCAL_EXECUTION_INFO = new ThreadLocal();
        lookup = MethodHandles.lookup();
    }

    public static State createState(Phase phase, Mode mode, CommandState activity, AlarmState alarm) {
        State res = new State();
        res.phase = phase;
        res.mode = mode;
        res.commandProcessing = activity;
        res.alarmState = alarm;
        return res;
    }

    @Deprecated
    public Subsystem() {
        this(null, Agent.AgentType.WORKER);
    }

    public Subsystem(String name, Agent.AgentType type) {
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_", "BUILD"));
        if (name != null) {
            switch (type) {
                case LISTENER: 
                case CONSOLE: {
                    name = Names.almostUniqueAgentName((String)name);
                }
            }
        }
        this.agent = new Agent(name, type);
        if (name != null) {
            this.setName(name);
        }
    }

    public static String getSoftwareRevision() {
        return revision;
    }

    public MessagingFactory getMessagingAccess() {
        return this.fac;
    }

    public State getInnerState() {
        return this.innerState;
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInEngineeringMode() {
        return this.innerState.mode.compareTo(Mode.ENGINEERING_OK) >= 0;
    }

    public boolean isMaster() {
        return false;
    }

    public boolean isSlave() {
        return false;
    }

    public static String getEthHardAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                byte[] z;
                NetworkInterface itf = e.nextElement();
                if (!itf.isUp() || itf.isLoopback() || (z = itf.getHardwareAddress()) == null) continue;
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", z[0], z[1], z[2], z[3], z[4], z[5]);
            }
        }
        catch (SocketException e1) {
            log.error((Object)"cannot get hardware address", (Throwable)e1, new String[]{"INIT"});
        }
        return null;
    }

    public Logger getLogger() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getCurrentActionThread() {
        Object object = this.actionMonitor;
        synchronized (object) {
            if (this.currentActionThread != null && !this.currentActionThread.isAlive()) {
                this.currentActionThread = null;
                this.activeThreads.getAndDecrement();
            }
        }
        return this.currentActionThread;
    }

    public ThreadGroup getAncillaryGroup() {
        return this.ancillaryGroup;
    }

    public void setListenToStatus(boolean listenToStatus) {
        this.listeningToStatus = listenToStatus;
    }

    public boolean isListenToStatus() {
        return this.listeningToStatus;
    }

    @Command(description="is the system in test context", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInTestContext() {
        return this.inTestContext;
    }

    public boolean isStartedInEngineeringMode() {
        return this.startInEngineeringMode;
    }

    @Deprecated
    public void setName(String name) {
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + name, "BUS CONNECTIONS"));
        this.name = name;
        if (this.agent.getName() == null) {
            this.agent.setName(name);
        }
        this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
        this.fac = MessagingFactory.getInstance().forSubsystem(name);
        this.configurationProxy.setSubsystem(this);
        this.initLogBusHandler();
        this.commandGroup = new ThreadGroup(name){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error((Object)("uncaught exception on command thread: " + t.getName() + "{" + e + "}"), e, new String[]{"CMD"});
            }
        };
    }

    protected void initLogBusHandler() {
        if (this.logBusHandler == null) {
            java.util.logging.Logger generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
            this.logBusHandler = new LogBusHandler(this.getName(), this.fac);
            generalLogger.addHandler(this.logBusHandler);
            if (!LogManagement.isConfigInitialized()) {
                generalLogger.setLevel(Level.WARNING);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getConfiguration() {
        return this.configurationProxy.getConfigurationName();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
        this.configurationProxy.setSubsystem(this);
    }

    @Deprecated
    public String getDefaultSelector() {
        return "destination = '" + this.name + "' OR destination = '*' or destination like '" + this.name + "/%'";
    }

    @Deprecated
    public String getStatusBusSelector() {
        return this.statusBusSelector == null ? this.getDefaultSelector() : this.statusBusSelector;
    }

    @Deprecated
    public void setStatusBusSelector(String selector) {
        this.statusBusSelector = selector;
    }

    @Deprecated
    public String getCommandBusSelector() {
        return this.commandBusSelector == null ? this.getDefaultSelector() : this.commandBusSelector;
    }

    @Deprecated
    public void setCommandBusSelector(String selector) {
        this.commandBusSelector = selector;
    }

    public void start() {
        log.info((Object)("Subsystem " + this.name + " starting with revision " + Subsystem.getSoftwareRevision()), new String[]{"INIT"});
        log.info((Object)("running on MAC " + Subsystem.getEthHardAddress()), new String[]{"INIT"});
        this.initThread = Thread.currentThread();
        this.ancillaryGroup = new ThreadGroup(this.initThread.getThreadGroup(), String.valueOf(this.getName()) + "'s ancillary");
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.name, "INITIALIZATION"));
        this.updateCurrentSubsystem();
        this.doStart();
        this.fac.addCommandListener((CommandListener)this, this.getCommandBusSelector());
        if (this.listeningToStatus) {
            this.fac.addStatusListener((StatusListens)this, this.getStatusBusSelector());
        }
        this.markReadyForCommands();
        try {
            this.checkHardware();
            this.initialisationEndPhase(true);
        }
        catch (HardwareException e) {
            log.error((Object)"check hardware problem ", (Throwable)((Object)e), new String[]{"INIT"});
            this.initialisationError(StackTraceFormats.toString((Throwable)((Object)e)));
            return;
        }
    }

    public void initialisationEndPhase(boolean checkHardwareOK) throws HardwareException {
        boolean stayAlive;
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
        }
        this.startStatusBroadcasting();
        this.postStart();
        this.switchToNormalReady();
        StatusForStart startMessage = new StatusForStart(this.configuration, this.tag, this.isMaster(), this.isSlave());
        startMessage.setInTestContext(this.inTestContext);
        this.broadcastStatus((Status)startMessage);
        log.info((Object)("Subsystem " + this.name + " started"), new String[]{"INIT"});
        if (checkHardwareOK) {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.name, "IDLE"));
        }
        if (stayAlive = "TRUE".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.stayAlive", "false").toUpperCase())) {
            this.stayAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stayAlive() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.initThread) {
            log.warn((Object)(" trying to block the initialisation thread from a different thread" + currentThread + "!=  init thread :" + this.initThread), new String[0]);
            return;
        }
        Object object = this.initThreadMonitor;
        synchronized (object) {
            try {
                this.initThreadMonitor.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialization() throws SystemStateException, HardwareException {
        if (!this.innerState.getPhase().equals((Object)Phase.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.initialisationEndPhase(false);
    }

    public void doStart() {
    }

    public void postStart() throws HardwareException {
    }

    public void checkHardware() throws HardwareException {
    }

    public void checkAllHardwareStarted() throws HardwareException {
    }

    public void checkAllHardwareStopped() throws HardwareException {
    }

    public Status getStatus(int statusBroadcastPeriod) {
        HeartBeatStatus s = new HeartBeatStatus(statusBroadcastPeriod);
        return this.fillStatus((Status)s);
    }

    protected synchronized Status fillStatus(Status s) {
        s.setOrigin(this.getName());
        s.setState(new PublishedState((Serializable)this.innerState));
        s.setAgent(this.agent);
        s.setSummary(this.innerState.stateExtraInfo);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (statusBroadcastPeriod < 1) {
                this.statusBroadcastPeriod = this.getDefaultBroadcastingPeriod();
                log.warn((Object)("broadcast period should be 1 or above. set to " + this.getDefaultBroadcastingPeriod()), new String[0]);
            } else {
                this.statusBroadcastPeriod = statusBroadcastPeriod;
            }
            Phase state = this.innerState.getProcessingState();
            if (state.compareTo(Phase.CLOSING) < 0 && !this.initializing) {
                this.startStatusBroadcasting();
            }
        }
    }

    private int getDefaultBroadcastingPeriod() {
        if (this.agent.getType().compareTo((Enum)Agent.AgentType.WORKER) >= 0) {
            return 1;
        }
        return 5;
    }

    public int getStatusBroadcastPeriod() {
        return this.statusBroadcastPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            while (true) {
                if (this.statusBroadcasterThread == null) {
                    return;
                }
                if (this.statusBroadcasterThread != null) {
                    this.statusBroadcasterThread.interrupt();
                }
                try {
                    this.statusBroadcasterLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (this.statusBroadcasterThread == null) {
                StatusBroadcaster run = new StatusBroadcaster();
                this.statusBroadcasterThread = new Thread((Runnable)run, String.valueOf(this.getName()) + "-broadcast");
                this.statusBroadcasterThread.start();
            }
        }
    }

    public void broadcastStatus(int statusBroadcastPeriod) {
        this.updateCurrentSubsystem();
        HeartBeatStatus s = (HeartBeatStatus)this.getStatus(statusBroadcastPeriod);
        log.debug((Object)("sending status " + s), new String[0]);
        this.fac.sendStatus((Status)s);
    }

    public void broadcastStatus(Status s) {
        this.updateCurrentSubsystem();
        s = this.fillStatus(s);
        log.debug((Object)("sending status " + s), new String[0]);
        this.fac.sendStatus(s);
    }

    @Command(description="shutdown", type=Command.CommandType.ACTION)
    public Object shutdown() throws HardwareException {
        log.info((Object)("Subsystem " + this.name + " shutdown starting"), new String[]{"SHUTDOWN"});
        this.switchToShutdownState();
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.raiseAlarm("some hardware are not stopped");
            log.error((Object)"some hardware are not stopped", (Throwable)((Object)exc), new String[]{"SHUTDOWN"});
            throw exc;
        }
        log.info((Object)"all hardware are stopped", new String[]{"SHUTDOWN"});
        this.doShutdown();
        final Thread shutdownCommandThread = Thread.currentThread();
        final boolean createShutdownThreadAndJoinOnCurrentThread = shutdownCommandThread.getThreadGroup() == this.commandGroup;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("SUBSYSTEM" + Subsystem.this.name, "END PHASE"));
                log.info((Object)"shutdown background thread started", new String[]{"SHUTDOWN"});
                if (createShutdownThreadAndJoinOnCurrentThread) {
                    try {
                        shutdownCommandThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn((Object)("Subsystem " + Subsystem.this.name + " shutdown interrupt"), new String[]{"SHUTDOWN"});
                    }
                }
                log.info((Object)"shutdown background thread is active :the initial shutdown command completed", new String[]{"SHUTDOWN"});
                Subsystem.this.switchToOfflineState();
                Subsystem.this.broadcastStatus(Subsystem.this.statusBroadcastPeriod);
                StatusForEnd endmessage = new StatusForEnd(Subsystem.this.configuration, Subsystem.this.tag, Subsystem.this.isMaster(), Subsystem.this.isSlave());
                endmessage.setInTestContext(Subsystem.this.inTestContext);
                Subsystem.this.broadcastStatus((Status)endmessage);
                log.info((Object)("Subsystem " + Subsystem.this.name + " shutdown completed [bus access going to close]"), new String[]{"SHUTDOWN"});
                if (Subsystem.this.logBusHandler != null) {
                    Subsystem.this.logBusHandler.close();
                }
                Subsystem.this.stopStatusBroadcasting();
                Subsystem.this.fac.shutdownBusAccess();
                if (Subsystem.this.initThread != null && Subsystem.this.initThread.isAlive()) {
                    Object object = Subsystem.this.initThreadMonitor;
                    synchronized (object) {
                        Subsystem.this.initThreadMonitor.notifyAll();
                    }
                }
            }
        };
        Thread endThread = new Thread(this.commandGroup, runnable, "EndThread");
        endThread.start();
        return "shutdown ok";
    }

    public void doShutdown() {
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.ABORT)
    public synchronized void forceShutdown() {
        this.forceShutdown = true;
        this.interruptAllRunningCommands();
        this.interruptAncillaryThreads(".*");
        this.notifyAll();
    }

    @Command(description="halt hardware", type=Command.CommandType.ABORT)
    public void abort() {
        log.info((Object)("Subsystem " + this.name + " halt requested"), new String[0]);
    }

    @Command(description="halt hardware with expected max delay", type=Command.CommandType.ABORT)
    public void abort(long expectedMaxDelay) {
        log.info((Object)("Subsystem " + this.name + " halt requested"), new String[0]);
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        log.info((Object)("Subsystem " + this.name + " stop requested"), new String[0]);
    }

    @Deprecated
    public synchronized SystemState updateState(SystemState newState, String extraInfo) {
        return null;
    }

    @Deprecated
    public SystemState updateState(SystemState newState) {
        return this.updateState(newState, "");
    }

    protected void publishStateChange(State before, State after) {
        PublishedState pBefore = new PublishedState((Serializable)before.clone());
        PublishedState pAfter = new PublishedState((Serializable)after.clone());
        DetailLevel level = DetailLevel.INFO;
        int comparison = after.alarmState.compareTo(AlarmState.WARNING);
        AlarmOnStateChange alarmOnStateChange = new AlarmOnStateChange(level, pBefore, pAfter);
        alarmOnStateChange.setSummary(((State)pAfter.getState()).stateExtraInfo);
        if (comparison > 0) {
            level = DetailLevel.SEVERE;
            this.fac.sendStatus((Status)alarmOnStateChange);
        } else if (comparison == 0) {
            level = DetailLevel.WARNING;
            this.fac.sendStatus((Status)alarmOnStateChange);
        } else {
            this.fac.sendStatus((Status)new StateChangeNotification(level, pBefore, pAfter));
        }
    }

    synchronized void markReadyForCommands() {
        State oldState = this.innerState;
        this.innerState.commandProcessing = CommandState.READY;
        this.publishStateChange(oldState, this.innerState);
    }

    synchronized void switchToNormalReady() {
        this.waitForSignalThreads(-1);
        State oldState = this.innerState;
        this.innerState.phase = Phase.OPERATIONAL;
        this.innerState.commandProcessing = CommandState.READY;
        if (!this.isStartedInEngineeringMode()) {
            this.innerState.mode = Mode.NORMAL;
        }
        this.innerState.alarmState = AlarmState.NOMINAL;
        this.innerState.stateExtraInfo = "";
        this.publishStateChange(oldState, this.innerState);
        this.initializing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForSignalThreads(int maxTries) {
        Object object = this.signalsMonitor;
        synchronized (object) {
            int nbTries = 0;
            block5: while (this.listSignalThreads.size() > 0) {
                if (maxTries - nbTries++ <= 0) break;
                long currentTime = System.currentTimeMillis();
                for (SignalThread interruptThread : this.signalThreadsIterable) {
                    if (interruptThread.getMaxDueTime() <= currentTime) continue;
                    try {
                        this.signalsMonitor.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue block5;
                    }
                }
            }
        }
    }

    synchronized void initialisationError(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((Status)alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
        State oldState = this.innerState;
        this.innerState.mode = Mode.ENGINEERING_FAULT;
        this.innerState.alarmState = AlarmState.ALARM;
        this.innerState.stateExtraInfo = message;
        this.publishStateChange(oldState, this.innerState);
    }

    protected synchronized void switchToShutdownState() {
        State oldState = this.innerState;
        this.innerState.phase = Phase.CLOSING;
        this.closing = true;
        if (this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
            this.innerState.mode = Mode.ENGINEERING_OK;
        }
        this.publishStateChange(oldState, this.innerState);
    }

    synchronized void switchToOfflineState() {
        State oldState = this.innerState;
        this.innerState.phase = Phase.OFF_LINE;
        this.publishStateChange(oldState, this.innerState);
    }

    synchronized boolean testAndSetReadyToActive() {
        if (this.innerState.commandProcessing.equals((Object)CommandState.READY)) {
            State oldState = this.innerState;
            this.innerState.commandProcessing = CommandState.ACTIVE;
            this.publishStateChange(oldState, this.innerState);
            return true;
        }
        return false;
    }

    synchronized boolean switchToRunningSignalsState() {
        CommandState commandProcessing = this.innerState.commandProcessing;
        if (commandProcessing.equals((Object)CommandState.READY)) {
            State oldState = this.innerState;
            this.innerState.commandProcessing = CommandState.ACTIVE;
            this.publishStateChange(oldState, this.innerState);
            return true;
        }
        return commandProcessing.equals((Object)CommandState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean backToReadyFromActive() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            block4: {
                if (this.listSignalThreads.size() != 0) break block4;
                State oldState = this.innerState;
                this.innerState.commandProcessing = CommandState.READY;
                this.publishStateChange(oldState, this.innerState);
                return true;
            }
            log.warn((Object)"signals running : unable to go back to READY", new String[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean backFromRunningSignal(Thread thread) {
        if (this.innerState.commandProcessing.equals((Object)CommandState.ACTIVE)) {
            Object object = this.signalsMonitor;
            synchronized (object) {
                block9: {
                    this.listSignalThreads.remove(thread);
                    if (this.listSignalThreads.size() != 0) break block9;
                    State oldState = this.innerState;
                    this.innerState.commandProcessing = CommandState.READY;
                    if (this.getCurrentActionThread() != null) {
                        this.innerState.commandProcessing = CommandState.ACTIVE;
                    }
                    if (this.initializing) {
                        this.innerState.phase = Phase.INITIALIZING;
                    }
                    if (this.closing) {
                        this.innerState.phase = Phase.CLOSING;
                    }
                    if (!this.innerState.equals(oldState)) {
                        this.publishStateChange(oldState, this.innerState);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public synchronized boolean switchToEngineeringMode() {
        Mode mode = this.innerState.getMode();
        if (mode.equals((Object)Mode.NORMAL)) {
            State oldState = this.innerState;
            this.innerState.mode = Mode.ENGINEERING_OK;
            this.publishStateChange(oldState, this.innerState);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public synchronized void switchToNormalMode() throws SystemStateException {
        if (this.innerState.getAlarmState().compareTo(AlarmState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        State oldState = this.innerState;
        this.innerState.mode = Mode.NORMAL;
        this.innerState.commandProcessing = CommandState.READY;
        this.publishStateChange(oldState, this.innerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((Status)alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            State oldState = this.innerState;
            this.innerState.mode = Mode.ENGINEERING_FAULT;
            this.innerState.alarmState = AlarmState.ALARM;
            this.innerState.stateExtraInfo = message;
            this.publishStateChange(oldState, this.innerState);
        }
    }

    @Deprecated
    public void switchToErrorState(String message) {
        this.raiseAlarm(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void warning(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((Status)alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            State oldState = this.innerState;
            this.innerState.alarmState = AlarmState.WARNING;
            this.innerState.stateExtraInfo = message;
            this.publishStateChange(oldState, this.innerState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="clear alarms", type=Command.CommandType.QUERY)
    public synchronized void clearAlarms(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
        Subsystem subsystem = this;
        synchronized (subsystem) {
            State oldState = this.innerState;
            this.innerState.alarmState = AlarmState.NOMINAL;
            this.innerState.stateExtraInfo = message;
            this.publishStateChange(oldState, this.innerState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="tries to switch to READY ", type=Command.CommandType.QUERY)
    public synchronized void tryReadyState(String message) throws SystemStateException {
        if (this.getCurrentActionThread() != null) {
            throw new ActionCommandStillRunning();
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            if (this.listSignalThreads.size() != 0) {
                throw new SignalsStillRunning();
            }
        }
        Phase phase = this.innerState.getProcessingState();
        if (phase.compareTo(Phase.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        State oldState = this.innerState;
        this.innerState.commandProcessing = CommandState.READY;
        this.publishStateChange(oldState, this.innerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(description="tries to wait until READY ", type=Command.CommandType.QUERY)
    public synchronized boolean waitForReadyState() throws ClosingStateException {
        while (this.getCurrentActionThread() != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        Object object = this.signalsMonitor;
        synchronized (object) {
            while (this.listSignalThreads.size() != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        Phase phase = this.innerState.getProcessingState();
        if (phase.compareTo(Phase.CLOSING) >= 0) {
            throw new ClosingStateException();
        }
        State oldState = this.innerState;
        this.innerState.commandProcessing = CommandState.READY;
        this.publishStateChange(oldState, this.innerState);
        return true;
    }

    public PublishedState getStateForPublication() {
        return new PublishedState((Serializable)this.innerState.clone());
    }

    @Deprecated
    public void broadcastAlarm() {
        this.broadcastAlarm(null);
    }

    @Deprecated
    public void broadcastAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus((Status)alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
    }

    @Deprecated
    public void broadcastAlarmClear(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)alrm);
    }

    @Deprecated
    public boolean isMultithreaded() {
        return true;
    }

    @Deprecated
    public synchronized void setMultithreaded(boolean multithreaded) {
    }

    @Deprecated
    public static String getCurrentSubsystemName() {
        Subsystem sys = currentSubsystem.get();
        if (sys == null) {
            return null;
        }
        return sys.getName();
    }

    @Deprecated
    protected void updateCurrentSubsystem() {
        currentSubsystem.set(this);
    }

    public void addLock(String target, LockArbitrator.LockOwnerInfo info) {
        log.info((Object)("lock requested by " + info.ownerSubsystem), new String[0]);
        LockArbitrator.LockOwnerInfo old = this.locks.put(target, info);
        if (old != null) {
            log.warn((Object)("lock on " + target + "(" + info.ownerSubsystem + ") was alread held by " + old.ownerSubsystem + " overriden by " + info.ownerSubsystem), new String[0]);
        }
    }

    public void removeLock(String target) {
        LockArbitrator.LockOwnerInfo old = this.locks.remove(target);
        if (old == null) {
            log.warn((Object)("removal of nonexistent lock on " + target), new String[0]);
        } else {
            log.debug((Object)("lock on " + target + "(" + old.ownerSubsystem + ") held by token " + old.token + " removed"), new String[0]);
        }
    }

    public void lockUpdate(String target, LockArbitrator.LockOwnerInfo info, boolean isAdd) {
        if (isAdd) {
            this.addLock(target, info);
        } else {
            this.removeLock(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(final org.lsst.ccs.bus.Command cmd) {
        block56: {
            Object[] parms;
            String commandName;
            Object realDestination;
            block57: {
                boolean notTopCommand;
                log.debug((Object)("subsystem got command " + cmd), new String[]{"CMD"});
                if (this.innerState.commandProcessing.equals((Object)CommandState.OFF) || this.innerState.getPhase().equals((Object)Phase.OFF_LINE)) {
                    NegativeAck ack = new NegativeAck(cmd, this.getName(), "can't accept command : state is Off");
                    log.debug((Object)("sending nack " + ack), new String[]{"CMD"});
                    this.fac.reply((CommandAckOrReply)ack);
                    return;
                }
                boolean bl = notTopCommand = !cmd.getDestination().endsWith("/main") && cmd.getDestination().contains("/");
                if (notTopCommand && this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
                    NegativeAck ack = new NegativeAck(cmd, this.getName(), "can't access lower level component (not named \"main\") if not in ENGINEERING MODE");
                    log.debug((Object)("sending nack " + ack), new String[]{"CMD"});
                    this.fac.reply((CommandAckOrReply)ack);
                    return;
                }
                DictionarySearchResult dictSearchResult = null;
                try {
                    dictSearchResult = this.searchForDictionary(cmd);
                }
                catch (Exception exc) {
                    NegativeAck ack = new NegativeAck(cmd, this.getName(), exc.toString());
                    log.debug((Object)("sending nack " + ack), new String[]{"CMD"});
                    this.fac.reply((CommandAckOrReply)ack);
                    return;
                }
                Object objDestination = dictSearchResult.goal;
                if (objDestination instanceof Configurable) {
                    objDestination = ((Configurable)objDestination).getEnvironment().getRelevantObject();
                }
                realDestination = objDestination;
                DictionaryCommand realCommand = dictSearchResult.dictionaryCommand;
                final Method method = dictSearchResult.method;
                commandName = dictSearchResult.commandName;
                parms = dictSearchResult.invocationParameters;
                if (realCommand == null) break block57;
                final Command.CommandType type = realCommand.getType();
                final CurrentCommandContext execInfo = new CurrentCommandContext(cmd.getOrigin(), commandName, type, parms);
                switch (type) {
                    case QUERY: {
                        if (notTopCommand && !this.checkLevelRights(realCommand, cmd)) {
                            NegativeAck ack = new NegativeAck(cmd, this.getName(), "insufficient Level privilege");
                            log.debug((Object)(" QUERY: sending nack " + ack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)ack);
                            return;
                        }
                        if (this.isVetoed(cmd, realDestination, method.getName(), parms)) {
                            log.debug((Object)(" QUERY: vetoed  " + cmd), new String[]{"CMD"});
                            return;
                        }
                        PositiveAck ack = new PositiveAck(cmd, this.getName());
                        log.debug((Object)(" QUERY: sending ack " + ack), new String[]{"CMD"});
                        this.fac.reply((CommandAckOrReply)ack);
                        String threadName = this.nameThread(cmd.getOrigin(), cmd.getCorrelId(), String.valueOf((Object)type), commandName, parms);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                Object result;
                                CommandReply.CommandStatus status;
                                block2: {
                                    LOCAL_EXECUTION_INFO.set(execInfo);
                                    status = CommandReply.CommandStatus.OK;
                                    result = null;
                                    try {
                                        result = method.isVarArgs() ? Subsystem.this.virtualMethodInvocation(method, realDestination, parms) : method.invoke(realDestination, parms);
                                    }
                                    catch (Throwable e) {
                                        Throwable th;
                                        log.debug((Object)("QUERY exception:" + commandName + Arrays.toString(parms)), e, new String[]{"CMD"});
                                        status = CommandReply.CommandStatus.ERROR;
                                        result = e;
                                        if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                        result = th;
                                    }
                                }
                                Subsystem.this.endOfCommand(cmd, type);
                                CommandReply reply = new CommandReply(cmd, result, status, Subsystem.this.getName());
                                log.debug((Object)("QUERY reply will be sent  " + reply), new String[]{"CMD"});
                                Subsystem.this.fac.reply((CommandAckOrReply)reply);
                            }
                        };
                        Thread queryThread = this.createThread(cmd, runnable, threadName);
                        this.activeThreads.getAndIncrement();
                        queryThread.start();
                        break block56;
                    }
                    case CONFIGURATION: {
                        if (this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
                            NegativeAck nack = new NegativeAck(cmd, this.getName(), "Configuration commands are accepted only in active ENGINEERING mode");
                            log.debug((Object)("sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                    }
                    case ACTION: {
                        CommandState commandProcessing = this.innerState.commandProcessing;
                        if (!commandProcessing.equals((Object)CommandState.READY)) {
                            NegativeAck nack = null;
                            Thread thread = this.getCurrentActionThread();
                            if (thread != null) {
                                nack = new NegativeAck(cmd, this.getName(), String.valueOf(thread.getName()) + " still running");
                            }
                            if (nack == null) {
                                Object queryThread = this.signalsMonitor;
                                synchronized (queryThread) {
                                    if (this.listSignalThreads.size() != 0) {
                                        nack = new NegativeAck(cmd, this.getName(), String.valueOf(cmd.getCommand()) + " Action or Configuration commands are accepted only if no interruption is running -> " + this.listSignalThreads);
                                    }
                                }
                                if (nack == null) {
                                    nack = new NegativeAck(cmd, this.getName(), String.valueOf(cmd.getCommand()) + " Action or Configuration commands are accepted only if CommandState is READY");
                                }
                            }
                            log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                        if (notTopCommand && !this.checkLevelRights(realCommand, cmd)) {
                            NegativeAck nack = new NegativeAck(cmd, this.getName(), "insufficient Level privilege");
                            log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                        if (!this.checkLock(cmd)) {
                            NegativeAck nack = new NegativeAck(cmd, this.getName(), "lock : not owner");
                            log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                        if (this.isVetoed(cmd, realDestination, method.getName(), parms)) {
                            log.debug((Object)((Object)((Object)type) + " sending veto " + cmd), new String[]{"CMD"});
                            return;
                        }
                        Object nack = this.actionMonitor;
                        synchronized (nack) {
                            if (!this.testAndSetReadyToActive()) {
                                NegativeAck nack2 = new NegativeAck(cmd, this.getName(), " not ready");
                                log.debug((Object)((Object)((Object)type) + " sending nack " + nack2), new String[]{"CMD"});
                                this.fac.reply((CommandAckOrReply)nack2);
                                return;
                            }
                            PositiveAck ack = new PositiveAck(cmd, this.getName());
                            log.debug((Object)((Object)((Object)type) + " sending ack " + ack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)ack);
                            String threadName = this.nameThread(cmd.getOrigin(), cmd.getCorrelId(), String.valueOf((Object)type), commandName, parms);
                            Runnable runnable = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object result;
                                    CommandReply.CommandStatus status;
                                    block5: {
                                        LOCAL_EXECUTION_INFO.set(execInfo);
                                        status = CommandReply.CommandStatus.OK;
                                        result = null;
                                        try {
                                            result = method.isVarArgs() ? Subsystem.this.virtualMethodInvocation(method, realDestination, parms) : method.invoke(realDestination, parms);
                                        }
                                        catch (Throwable e) {
                                            Throwable th;
                                            log.debug((Object)((Object)((Object)type) + " exception:" + commandName + Arrays.toString(parms)), e, new String[]{"CMD"});
                                            status = CommandReply.CommandStatus.ERROR;
                                            result = e;
                                            if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block5;
                                            result = th;
                                        }
                                    }
                                    Object e = Subsystem.this.actionMonitor;
                                    synchronized (e) {
                                        Subsystem.this.currentActionThread = null;
                                        Subsystem.this.backToReadyFromActive();
                                        Subsystem.this.endOfCommand(cmd, type);
                                    }
                                    CommandReply reply = new CommandReply(cmd, result, status, Subsystem.this.getName());
                                    log.debug((Object)((Object)((Object)type) + " reply will be sent  " + reply), new String[]{"CMD"});
                                    Subsystem.this.fac.reply((CommandAckOrReply)reply);
                                }
                            };
                            Thread actionThread = this.createThread(cmd, runnable, threadName);
                            this.activeThreads.getAndIncrement();
                            this.currentActionThread = actionThread;
                            actionThread.start();
                            break block56;
                        }
                    }
                    case ABORT: {
                        NegativeAck nack;
                        Object expectedMaxDelay;
                        long dueTime;
                        long currentTime = dueTime = System.currentTimeMillis();
                        DictionaryArgument[] arguments = realCommand.getArguments();
                        if (arguments.length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                            String argAsString = String.valueOf(parms[0]);
                            expectedMaxDelay = new Long(argAsString);
                            dueTime = currentTime + (Long)expectedMaxDelay;
                        }
                        boolean timeOverdue = false;
                        expectedMaxDelay = this.signalsMonitor;
                        synchronized (expectedMaxDelay) {
                            long registeredDueTime = Long.MAX_VALUE;
                            for (SignalThread interruptThread : this.signalThreadsIterable) {
                                long max = interruptThread.getMaxDueTime();
                                if (max >= registeredDueTime) continue;
                                registeredDueTime = max;
                            }
                            if (dueTime > registeredDueTime) {
                                timeOverdue = true;
                            }
                        }
                        if (timeOverdue) {
                            nack = new NegativeAck(cmd, this.getName(), " interruption with shorter time span running");
                            log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                        if (notTopCommand && !this.checkLevelRights(realCommand, cmd)) {
                            nack = new NegativeAck(cmd, this.getName(), "insufficient Level privilege");
                            log.debug((Object)((Object)((Object)type) + " sending nack " + nack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)nack);
                            return;
                        }
                        if (this.isVetoed(cmd, realDestination, method.getName(), parms)) {
                            log.debug((Object)((Object)((Object)type) + " veto " + cmd), new String[]{"CMD"});
                            return;
                        }
                        Object object = this.signalsMonitor;
                        synchronized (object) {
                            this.switchToRunningSignalsState();
                            PositiveAck ack = new PositiveAck(cmd, this.getName());
                            log.debug((Object)((Object)((Object)type) + " sending ack " + ack), new String[]{"CMD"});
                            this.fac.reply((CommandAckOrReply)ack);
                            String threadName = this.nameThread(cmd.getOrigin(), cmd.getCorrelId(), String.valueOf((Object)type), commandName, parms);
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    Object result;
                                    CommandReply.CommandStatus status;
                                    block2: {
                                        LOCAL_EXECUTION_INFO.set(execInfo);
                                        status = CommandReply.CommandStatus.OK;
                                        result = null;
                                        try {
                                            result = method.isVarArgs() ? Subsystem.this.virtualMethodInvocation(method, realDestination, parms) : method.invoke(realDestination, parms);
                                        }
                                        catch (Throwable e) {
                                            Throwable th;
                                            log.debug((Object)((Object)((Object)type) + " exception:" + commandName + Arrays.toString(parms)), e, new String[]{"CMD"});
                                            status = CommandReply.CommandStatus.ERROR;
                                            result = e;
                                            if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block2;
                                            result = th;
                                        }
                                    }
                                    Subsystem.this.backFromRunningSignal(Thread.currentThread());
                                    Subsystem.this.endOfCommand(cmd, type);
                                    CommandReply reply = new CommandReply(cmd, result, status, Subsystem.this.getName());
                                    log.debug((Object)((Object)((Object)type) + "  reply will be sent  " + reply), new String[]{"CMD"});
                                    Subsystem.this.fac.reply((CommandAckOrReply)reply);
                                }
                            };
                            SignalThread signalThread = new SignalThread(this.commandGroup, runnable, threadName, dueTime);
                            this.activeThreads.getAndIncrement();
                            this.listSignalThreads.add(signalThread);
                            signalThread.start();
                            break block56;
                        }
                    }
                    default: {
                        assert (false) : "command with unlikely type :" + (Object)((Object)type);
                        break block56;
                    }
                }
            }
            if (this.innerState.getMode().compareTo(Mode.ENGINEERING_OK) < 0) {
                NegativeAck nack = new NegativeAck(cmd, this.getName(), String.valueOf(cmd.getCommand()) + " not registered as a normal mode Command (some commands are available only in Engineering mode)");
                log.debug((Object)("direct method call: sending nack " + nack), new String[]{"CMD"});
                this.fac.reply((CommandAckOrReply)nack);
                return;
            }
            CommandState commandProcessing = this.innerState.commandProcessing;
            if (!commandProcessing.equals((Object)CommandState.READY)) {
                NegativeAck nack = null;
                Thread thread = this.getCurrentActionThread();
                if (thread != null) {
                    nack = new NegativeAck(cmd, this.getName(), String.valueOf(thread.getName()) + " still running");
                }
                if (nack == null) {
                    Object dueTime = this.signalsMonitor;
                    synchronized (dueTime) {
                        if (this.listSignalThreads.size() != 0) {
                            nack = new NegativeAck(cmd, this.getName(), "method calls are accepted only if no interruption is running -> " + this.listSignalThreads);
                        }
                    }
                    if (nack == null) {
                        nack = new NegativeAck(cmd, this.getName(), "method calls are accepted only if no other such command is running");
                    }
                }
                log.debug((Object)(" direct method call : sending nack " + nack), new String[]{"CMD"});
                this.fac.reply((CommandAckOrReply)nack);
                return;
            }
            if (this.isVetoed(cmd, realDestination, commandName, parms)) {
                log.debug((Object)("direct method call: veto " + cmd), new String[]{"CMD"});
                return;
            }
            Object object = this.actionMonitor;
            synchronized (object) {
                if (!this.testAndSetReadyToActive()) {
                    NegativeAck nack = new NegativeAck(cmd, this.getName(), " not ready");
                    log.debug((Object)("direct method call sending nack " + nack), new String[]{"CMD"});
                    this.fac.reply((CommandAckOrReply)nack);
                    return;
                }
                PositiveAck ack = new PositiveAck(cmd, this.getName());
                log.debug((Object)("direct method call: sending ack " + ack), new String[]{"CMD"});
                this.fac.reply((CommandAckOrReply)ack);
                String threadName = this.nameThread(cmd.getOrigin(), cmd.getCorrelId(), "method call", commandName, parms);
                final Object goal = realDestination;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object result;
                        CommandReply.CommandStatus status;
                        block5: {
                            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext(cmd.getOrigin(), commandName, null, parms));
                            status = CommandReply.CommandStatus.OK;
                            result = null;
                            try {
                                result = MethodUtils.invokeMethod((Object)goal, (String)commandName, (Object[])parms);
                            }
                            catch (Exception e) {
                                Throwable th;
                                log.debug((Object)("direct method call: exception:" + commandName + Arrays.toString(parms)), (Throwable)e, new String[]{"CMD"});
                                status = CommandReply.CommandStatus.ERROR;
                                result = e;
                                if (!(e instanceof InvocationTargetException) || (th = e.getCause()) == null) break block5;
                                result = th;
                            }
                        }
                        Object e = Subsystem.this.actionMonitor;
                        synchronized (e) {
                            Subsystem.this.currentActionThread = null;
                            Subsystem.this.backToReadyFromActive();
                            Subsystem.this.endOfCommand(cmd, null);
                        }
                        CommandReply reply = new CommandReply(cmd, result, status, Subsystem.this.getName());
                        log.debug((Object)("direct method call:  reply will be sent  " + reply), new String[]{"CMD"});
                        Subsystem.this.fac.reply((CommandAckOrReply)reply);
                    }
                };
                Thread queryThread = this.createThread(cmd, runnable, threadName);
                this.activeThreads.getAndIncrement();
                this.currentActionThread = queryThread;
                queryThread.start();
            }
        }
    }

    Object virtualMethodInvocation(Method meth, Object goal, Object ... parms) throws Throwable {
        Class<?>[] types = meth.getParameterTypes();
        Class<?> lastType = types[types.length - 1];
        Class<?> arrayComponent = lastType.getComponentType();
        ArrayList<Object> list = new ArrayList<Object>();
        int index = 0;
        while (index < types.length - 1) {
            list.add(parms[index]);
            ++index;
        }
        int size = parms.length - index;
        Object array = Array.newInstance(arrayComponent, size);
        int ix = 0;
        while (ix < size) {
            Array.set(array, ix, parms[index + ix]);
            ++ix;
        }
        list.add(array);
        return meth.invoke(goal, list.toArray());
    }

    String nameThread(String commandOriginator, String correlID, String commandType, String commandName, Object[] parameters) {
        String threadName = String.format("%s [%s] -> %s: %s %s", commandOriginator, correlID, commandType, commandName, Arrays.toString(parameters));
        return threadName;
    }

    Thread createThread(final org.lsst.ccs.bus.Command cmd, Runnable runnable, String threadName) {
        Thread res = new Thread(this.commandGroup, runnable, threadName);
        res.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CommandReply reply = new CommandReply(cmd, (Object)e, CommandReply.CommandStatus.ERROR, Subsystem.this.getName());
                try {
                    Subsystem.this.fac.reply((CommandAckOrReply)reply);
                }
                catch (Throwable th) {
                    log.error((Object)("uncaught exception Handler of " + cmd + "can't reply"), th, new String[0]);
                }
            }
        });
        return res;
    }

    boolean checkLevelRights(DictionaryCommand commandDescribed, org.lsst.ccs.bus.Command command) {
        command.getLevel();
        return true;
    }

    boolean isVetoed(org.lsst.ccs.bus.Command cmd, Object component, String realCommandName, Object[] arguments) {
        if (component instanceof InvocationListener) {
            InvocationListener vetoer = (InvocationListener)component;
            try {
                vetoer.beforeInvocation(cmd.getOrigin(), realCommandName, arguments);
            }
            catch (InvocationVetoException ex) {
                NegativeAck nack = new NegativeAck(cmd, this.getName(), ex.toString());
                this.fac.reply((CommandAckOrReply)nack);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForCommandExecution(long timeOut) {
        Object object = this.commandMonitor;
        synchronized (object) {
            while (this.waitingForCommandTermination) {
                try {
                    this.commandMonitor.wait(timeOut);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endOfCommand(org.lsst.ccs.bus.Command cmd, Command.CommandType type) {
        this.activeThreads.getAndDecrement();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.commandMonitor;
        synchronized (object) {
            this.waitingForCommandTermination = false;
            this.commandMonitor.notifyAll();
        }
    }

    boolean checkLock(org.lsst.ccs.bus.Command cmd) {
        return true;
    }

    @Deprecated
    protected synchronized Object executeCommandSingleThread(org.lsst.ccs.bus.Command cmd) {
        return null;
    }

    protected DictionarySearchResult searchForDictionary(org.lsst.ccs.bus.Command command) throws CommandInvocationException {
        Subsystem goal = this;
        LocalCommandDictionary localDict = this.getCommandBuilder(this);
        return this.searchForDictionary(true, command, goal, localDict);
    }

    protected DictionarySearchResult searchForDictionary(boolean fatal, org.lsst.ccs.bus.Command command, Object goal, LocalCommandDictionary localDict) throws CommandInvocationException {
        Object[] realParameters;
        String commandName;
        Method meth;
        DictionaryCommand dictCommand = null;
        CommandArgumentMatchException commandException = null;
        Dictionary dict = localDict.getCommandDictionary();
        if (goal instanceof CCSProxy) {
            goal = ((CCSProxy)goal).getDelegate();
        }
        if (command.isUnParsed()) {
            TokenizedCommand tokenized = new TokenizedCommand(command.getCommand());
            try {
                dictCommand = dict.findCommand(tokenized);
            }
            catch (CommandArgumentMatchException ex) {
                commandException = ex;
            }
            if (dictCommand == null) {
                if (fatal) {
                    throw new CommandInvocationException("unable to parse :" + command.getCommand(), commandException);
                }
                return null;
            }
            meth = localDict.getMethod(dictCommand);
            RawCommand rawCommand = RawCommand.toRawCommand(tokenized, meth);
            commandName = rawCommand.getCommand();
            realParameters = rawCommand.getArguments();
        } else {
            RawCommand rawCommand = new RawCommand(command.getCommand(), Arrays.asList(command.getParameters()));
            try {
                dictCommand = dict.findCommand(rawCommand);
            }
            catch (CommandArgumentMatchException commandArgumentMatchException) {}
            if (dictCommand == null) {
                return new DictionarySearchResult(goal, command.getCommand(), command.getParameters());
            }
            meth = localDict.getMethod(dictCommand);
            commandName = command.getCommand();
            realParameters = command.getParameters();
        }
        return new DictionarySearchResult(goal, dictCommand, commandName, meth, realParameters);
    }

    protected LocalCommandDictionary getCommandBuilder(Object obj) {
        if (this.commandBuilder == null) {
            this.commandBuilder = LocalBuilders.factory(this.getClass());
        }
        return this.commandBuilder;
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public Dictionary getSystemDictionary() {
        return this.getCommandBuilder(this).getCommandDictionary();
    }

    @Command(description="Get the CCS Versions for the current CCS Environment", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public CCSVersions getCCSVersions() {
        CCSVersions versions = this.getMessagingAccess().getAgentPresenceManager().getCCSVersions();
        versions.add(this.agent, new DistributionInfo());
        return versions;
    }

    protected Object rawCommandExecution(org.lsst.ccs.bus.Command cmd, Object obj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        log.trace((Object)("raw execution of  " + cmd + " for object " + obj), new String[0]);
        return MethodUtils.invokeMethod((Object)obj, (String)cmd.getCommand(), (Object[])cmd.getParameters());
    }

    public void onStatus(BusMessage s) {
    }

    public void onReply(CommandReply r) {
    }

    public void onAck(CommandAck a) {
    }

    public void registerAsBusMaster() {
    }

    @Deprecated
    public void publishData(String name, Object value, long tStamp) {
        ValueNotification td = new ValueNotification(name, value, tStamp);
        this.publishData(td);
    }

    @Deprecated
    public void publishData(String name, Serializable value, long tStamp) {
        DataValueNotification td = new DataValueNotification(name, value, tStamp);
        this.publishData(td);
    }

    @Deprecated
    public void publishData(String name, Object value) {
        ValueNotification td = new ValueNotification(name, value);
        this.publishData(td);
    }

    @Deprecated
    public void publishData(String name, Serializable value) {
        DataValueNotification td = new DataValueNotification(name, value);
        this.publishData(td);
    }

    @Deprecated
    public void publishData(List<? extends ValueNotification> tdl) {
        TrendingStatus ts = new TrendingStatus(tdl);
        this.publishTrendingStatus(ts);
    }

    @Deprecated
    public void publishData(ValueNotification td) {
        TrendingStatus ts = new TrendingStatus((Object)td);
        this.publishTrendingStatus(ts);
    }

    @Deprecated
    public void publishData(DataValueNotification td) {
        TrendingStatus ts = new TrendingStatus(td);
        this.publishTrendingStatus(ts);
    }

    protected void publishTrendingStatus(TrendingStatus ts) {
        ts = (TrendingStatus)this.fillStatus((Status)ts);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)ts);
    }

    public void publishMetaData(String dataname, String metadataname, String value) {
        MetadataStatus mst = new MetadataStatus(dataname, metadataname, value);
        this.updateCurrentSubsystem();
        this.fac.sendStatus((Status)mst);
    }

    protected void publishStatusData(EncodedDataStatus dataStatus) {
        Status status = this.fillStatus((Status)dataStatus);
        this.updateCurrentSubsystem();
        this.fac.sendStatus(status);
    }

    public void publishStatus(long timestamp, String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(timestamp, key, value));
    }

    public void publishStatus(String key, Object value) {
        this.publishStatusData(new EncodedDataStatus(key, value));
    }

    public void publishStatus(long timestamp, KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(timestamp, kvlist));
    }

    public void publishStatus(KVList kvlist) {
        this.publishStatusData(new EncodedDataStatus(kvlist));
    }

    public void publishStatus(String key, long[] timestamps, Object[] objects) {
        if (timestamps.length != objects.length) {
            throw new IllegalArgumentException("arrays in parameter do not have same size");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("empty publication request (empty array)");
        }
        int length = timestamps.length;
        EncodedDataStatus res = null;
        EncodedDataStatus current = null;
        int ix = length - 1;
        while (ix >= 0) {
            res = new EncodedDataStatus(timestamps[ix], key, objects[ix]);
            res.setNext(current);
            current = res;
            --ix;
        }
        this.publishStatusData(res);
    }

    public void publishStatus(List<ValueNotification> tdl) {
        EncodedDataStatus res = null;
        EncodedDataStatus current = null;
        if (tdl.size() == 0) {
            throw new IllegalArgumentException("empty publication request (list is empty)");
        }
        for (ValueNotification notification : tdl) {
            res = new EncodedDataStatus(notification.gettStamp(), notification.getName(), notification.getData());
            res.setNext(current);
            current = res;
        }
        this.publishStatusData(res);
    }

    @Deprecated
    public void publishReply(CommandReply myReply) {
        this.fac.reply((CommandAckOrReply)myReply);
    }

    public void sendRawStatus(Status status) {
        this.fillStatus(status);
        this.fac.sendStatus(status);
    }

    @Command(description="set the level of the BusLogHandler", type=Command.CommandType.QUERY)
    public void setBusLogHandlerLevel(String levelName) {
        if (this.logBusHandler != null) {
            Level level = Level.parse(levelName);
            this.logBusHandler.setLevel(level);
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandlerN, FileHandlerN, LogBusHandler) log level", type=Command.CommandType.QUERY)
    public void setLogHandlerLevel(String handler, String level) {
        if (handler.equals("LogBusHandler")) {
            if (this.logBusHandler != null) {
                Level newLevel = Level.parse(level);
                this.logBusHandler.setLevel(newLevel);
            }
        } else {
            Handler[] handlers;
            java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
            Handler[] handlerArray = handlers = rootLogger.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h.getClass().getSimpleName().equals(handler)) {
                    Level newLevel = Level.parse(level);
                    h.setLevel(newLevel);
                    break;
                }
                ++n2;
            }
        }
    }

    @Command(description="tries to stop the panic state of logmanagement", type=Command.CommandType.QUERY)
    public void removeLogPanicState() {
        if (this.logBusHandler != null) {
            this.logBusHandler.setPanicState(false);
        }
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        int res = this.activeThreads.get();
        return res - 1;
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Object[] threads = new Thread[this.commandGroup.activeCount()];
        this.commandGroup.enumerate((Thread[])threads);
        return Arrays.toString(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt for all command threads (behaviour of commands are implementation dependent)", type=Command.CommandType.ABORT)
    public synchronized void interruptAllRunningCommands() {
        Thread currentThread = Thread.currentThread();
        Object object = this.actionMonitor;
        synchronized (object) {
            Object object2 = this.signalsMonitor;
            synchronized (object2) {
                Thread[] threads = new Thread[this.commandGroup.activeCount()];
                this.commandGroup.enumerate(threads);
                Thread[] threadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    if (thread.isAlive() && !thread.equals(currentThread)) {
                        try {
                            thread.interrupt();
                        }
                        catch (Exception exc) {
                            log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    @Command(description="sends an interrupt to a running ACTION thread", type=Command.CommandType.ABORT)
    public synchronized void interruptActionThread() {
        log.debug((Object)"interrupting action thread", new String[0]);
        Thread thread = this.getCurrentActionThread();
        try {
            thread.interrupt();
        }
        catch (Exception exc) {
            log.warn((Object)(exc + "thrown during interruption"), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="sends an interrupt to all running SIGNAL  threads", type=Command.CommandType.ABORT)
    public synchronized void interruptAllSignalThreads() {
        Object object = this.signalsMonitor;
        synchronized (object) {
            for (SignalThread signalThread : this.signalThreadsIterable) {
                if (signalThread == Thread.currentThread()) continue;
                try {
                    signalThread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                }
            }
        }
    }

    @Command(description="sends an interrupt to any 'ancillary' thread whose name matches the regular expression passed as argument", type=Command.CommandType.ABORT)
    public void interruptAncillaryThreads(String expReg) {
        Thread[] threads = new Thread[this.ancillaryGroup.activeCount()];
        this.ancillaryGroup.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            String name = thread.getName();
            if (name.matches(expReg) && thread.isAlive()) {
                try {
                    thread.interrupt();
                }
                catch (Exception exc) {
                    log.warn((Object)(exc + "thrown during interruption"), new String[0]);
                }
            }
            ++n2;
        }
    }

    @Command(description="sends an interrupt to the initialization thread", type=Command.CommandType.ABORT)
    public synchronized void interruptInitThread() {
        if (this.initThread != null && this.initThread.isAlive()) {
            try {
                this.initThread.interrupt();
            }
            catch (Exception exc) {
                log.warn((Object)(exc + "thrown during interruption"), new String[0]);
            }
        }
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        PingStatus status = new PingStatus(this.isMaster(), this.isSlave());
        this.fillStatus((Status)status);
        this.fac.sendStatus((Status)status);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.fac.getAgentPresenceManager();
    }

    protected class DictionarySearchResult {
        public Object goal;
        public DictionaryCommand dictionaryCommand;
        public String commandName;
        public Method method;
        public Object[] invocationParameters;

        public DictionarySearchResult(Object goal, DictionaryCommand dictionaryCommand, String commandName, Method method, Object ... invocationParameters) {
            this.goal = goal;
            this.dictionaryCommand = dictionaryCommand;
            this.commandName = commandName;
            this.method = method;
            this.invocationParameters = invocationParameters;
        }

        public DictionarySearchResult(Object goal, String commandName, Object ... parameters) {
            this.goal = goal;
            this.commandName = commandName;
            this.invocationParameters = parameters;
            if (Subsystem.this.innerState.mode.compareTo(Mode.ENGINEERING_OK) >= 0) {
                Class[] argsTypes = new Class[parameters.length];
                int ix = 0;
                while (ix < parameters.length) {
                    argsTypes[ix] = parameters[ix].getClass();
                    ++ix;
                }
                Class<?> clazz = goal.getClass();
                try {
                    this.method = clazz.getDeclaredMethod(commandName, argsTypes);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class SignalThread
    extends Thread {
        long maxDueTime;

        public SignalThread(ThreadGroup group, Runnable target, final String name, long maxDueTime) {
            super(group, target, name);
            this.maxDueTime = maxDueTime;
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.error((Object)(String.valueOf(name) + " signal Thread"), e, new String[]{"CMD"});
                }
            });
        }

        public long getMaxDueTime() {
            return this.maxDueTime;
        }

        public void extendDuration(long millis) {
            this.maxDueTime = this.maxDueTime < Long.MAX_VALUE - millis ? (this.maxDueTime += millis) : Long.MAX_VALUE;
        }
    }

    public static class State
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -9205531738428213674L;
        private Mode mode = Mode.ENGINEERING_OK;
        private Phase phase = Phase.INITIALIZING;
        private CommandState commandProcessing = CommandState.OFF;
        private AlarmState alarmState = AlarmState.NOMINAL;
        String stateExtraInfo;

        public Phase getProcessingState() {
            return this.phase;
        }

        public Mode getMode() {
            return this.mode;
        }

        public AlarmState getAlarmState() {
            return this.alarmState;
        }

        public Phase getPhase() {
            return this.phase;
        }

        public CommandState getCommandProcessing() {
            return this.commandProcessing;
        }

        public String getStateExtraInfo() {
            return this.stateExtraInfo;
        }

        public String toString() {
            return (Object)((Object)this.phase) + ":" + (Object)((Object)this.commandProcessing) + ":" + (Object)((Object)this.mode) + ":" + (Object)((Object)this.alarmState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            if (this.alarmState != state.alarmState) {
                return false;
            }
            if (this.commandProcessing != state.commandProcessing) {
                return false;
            }
            if (this.mode != state.mode) {
                return false;
            }
            return this.phase == state.phase;
        }

        public int hashCode() {
            int result = this.mode.hashCode();
            result = 31 * result + this.phase.hashCode();
            result = 31 * result + this.commandProcessing.hashCode();
            result = 31 * result + this.alarmState.hashCode();
            return result;
        }

        public State clone() {
            State res = null;
            try {
                res = (State)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            return res;
        }
    }

    protected class StatusBroadcaster
    implements Runnable {
        protected StatusBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Subsystem.this.updateCurrentSubsystem();
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + Subsystem.this.name, "STATUS BROADCASTING"));
            try {
                try {
                    while (true) {
                        Subsystem.this.broadcastStatus(Subsystem.this.statusBroadcastPeriod);
                        int period = Subsystem.this.statusBroadcastPeriod;
                        Thread.sleep(1000L * (long)period);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = Subsystem.this.statusBroadcasterLock;
                    synchronized (object) {
                        Subsystem.this.statusBroadcasterThread = null;
                        Subsystem.this.statusBroadcasterLock.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = Subsystem.this.statusBroadcasterLock;
                synchronized (object) {
                    Subsystem.this.statusBroadcasterThread = null;
                    Subsystem.this.statusBroadcasterLock.notifyAll();
                }
                throw throwable;
            }
        }
    }
}

