/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.groups.Default;
import org.hibernate.HibernateException;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsPerOperation {
    private static final String JPA_GROUP_PREFIX = "javax.persistence.validation.group.";
    private static final String HIBERNATE_GROUP_PREFIX = "org.hibernate.validator.group.";
    private static final Class<?>[] DEFAULT_GROUPS = new Class[]{Default.class};
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private Map<Operation, Class<?>[]> groupsPerOperation = new HashMap<Operation, Class<?>[]>(4);

    public GroupsPerOperation(Properties properties) {
        this.setGroupsForOperation(Operation.INSERT, properties);
        this.setGroupsForOperation(Operation.UPDATE, properties);
        this.setGroupsForOperation(Operation.DELETE, properties);
        this.setGroupsForOperation(Operation.DDL, properties);
    }

    private void setGroupsForOperation(Operation operation, Properties properties) {
        Class<?>[] groups;
        Object property = properties.get(operation.getGroupPropertyName());
        if (property == null) {
            groups = operation == Operation.DELETE ? EMPTY_GROUPS : DEFAULT_GROUPS;
        } else if (property instanceof String) {
            String stringProperty = (String)property;
            String[] groupNames = stringProperty.split(",");
            if (groupNames.length == 1 && groupNames[0].equals("")) {
                groups = EMPTY_GROUPS;
            } else {
                ArrayList<Class> groupsList = new ArrayList<Class>(groupNames.length);
                for (String groupName : groupNames) {
                    String cleanedGroupName = groupName.trim();
                    if (cleanedGroupName.length() <= 0) continue;
                    try {
                        groupsList.add(ReflectHelper.classForName((String)cleanedGroupName));
                    }
                    catch (ClassNotFoundException e) {
                        throw new HibernateException("Unable to load class " + cleanedGroupName, (Throwable)e);
                    }
                }
                groups = groupsList.toArray(new Class[groupsList.size()]);
            }
        } else if (property instanceof Class[]) {
            groups = (Class[])property;
        } else {
            throw new HibernateException(JPA_GROUP_PREFIX + operation.getGroupPropertyName() + " is of unknown type: String or Class<?>[] only");
        }
        this.groupsPerOperation.put(operation, groups);
    }

    public Class<?>[] get(Operation operation) {
        return this.groupsPerOperation.get((Object)operation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT("persist", "javax.persistence.validation.group.pre-persist"),
        UPDATE("update", "javax.persistence.validation.group.pre-update"),
        DELETE("remove", "javax.persistence.validation.group.pre-remove"),
        DDL("ddl", "org.hibernate.validator.group.ddl");

        private String exposedName;
        private String groupPropertyName;

        private Operation(String exposedName, String groupProperty) {
            this.exposedName = exposedName;
            this.groupPropertyName = groupProperty;
        }

        public String getName() {
            return this.exposedName;
        }

        public String getGroupPropertyName() {
            return this.groupPropertyName;
        }
    }
}

