/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.TypeInfos;

@MappedSuperclass
public abstract class ParameterDescription
implements Serializable,
PathObject {
    protected String description;
    private ParameterBase parameterBase;
    private String simpleName;
    private String constraints;
    private int level = 10;
    private boolean notModifiableAtRuntime;

    protected ParameterDescription() {
    }

    protected ParameterDescription(ParameterBase parameterBase) {
        this.setParameterBase(parameterBase);
    }

    protected ParameterDescription(ParameterDescription other) {
        this.setId(other.getId());
        this.setParameterBase(other.parameterBase);
        this.description = other.description;
        this.simpleName = other.simpleName;
        this.constraints = other.constraints;
        this.level = other.level;
        this.notModifiableAtRuntime = other.notModifiableAtRuntime;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public ParameterBase getParameterBase() {
        return this.parameterBase;
    }

    protected void setParameterBase(ParameterBase parameterBase) {
        this.parameterBase = parameterBase;
        String codeName = parameterBase.getCodeName();
        if (codeName == null) {
            codeName = "";
        }
        this.simpleName = String.format("%s/%s/%s", parameterBase.getComponentName(), codeName, parameterBase.getParameterName());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("simple name read Only");
        }
        if (this.simpleName == null || "".equals(this.simpleName)) {
            this.simpleName = simpleName;
        }
    }

    public String getConstraints() {
        return this.constraints;
    }

    public void setConstraints(String constraints) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Constraints read Only");
        }
        this.constraints = constraints;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Level read Only");
        }
        this.level = level;
    }

    public boolean isNotModifiableAtRuntime() {
        return this.notModifiableAtRuntime;
    }

    public void setNotModifiableAtRuntime(boolean notModifiableAtRuntime) {
        this.notModifiableAtRuntime = notModifiableAtRuntime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathObject)) {
            return false;
        }
        PathObject that = (PathObject)o;
        return this.parameterBase.getPath().equals(that.getPath());
    }

    public int hashCode() {
        return this.parameterBase.getPath().hashCode();
    }

    public String toString() {
        return "{" + this.getId() + ": base=" + this.parameterBase + '}';
    }

    public String getComponentName() {
        return this.parameterBase.getComponentName();
    }

    public String getCodeName() {
        return this.parameterBase.getCodeName();
    }

    public String getParameterName() {
        return this.parameterBase.getParameterName();
    }

    public String getDefaultValue() {
        return this.parameterBase.getDefaultValue();
    }

    @Override
    public ParameterPath getPath() {
        return this.parameterBase.getPath();
    }

    public String getTypeName() {
        return this.parameterBase.getTypeName();
    }

    public Object checkValue(String value) {
        return Constraints.check(this.getParameterBase().getTypeName(), value, this.getConstraints());
    }

    public String toPropertyString(String value, boolean commentOutValue) {
        if (value == null) {
            value = "";
        }
        StringBuilder builder = new StringBuilder();
        String pathName = this.parameterBase.getPath().toString();
        builder.append("\n#********  ").append(pathName);
        if (this.description != null) {
            String withPounds = this.description.replaceAll("\n", "\n#");
            builder.append('\n').append("#** ").append(withPounds);
        }
        if (this.isNotModifiableAtRuntime()) {
            builder.append("\n#**  static parameter (not modifiable at runtime)");
        }
        if (this.constraints != null && !"".equals(this.constraints.trim())) {
            builder.append("\n#** constraints : ").append(this.constraints).append(" ; type : ").append(TypeInfos.get(this.parameterBase.getTypeName()));
        } else {
            builder.append("\n#** type : ").append(TypeInfos.get(this.parameterBase.getTypeName()));
        }
        String propName = this.simpleName;
        propName = propName == null || "".equals(propName.trim()) ? pathName : propName.trim().replaceAll(" ", "\\\\ ");
        builder.append("\n#**\n#********\n\n").append(commentOutValue ? "#" : "").append(propName).append(" = ").append(value).append('\n');
        return builder.toString();
    }

    public String toPropertyString() {
        return this.toPropertyString(this.getDefaultValue(), true);
    }
}

