/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.timing;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.lsst.ccs.timing.Timing;

public class UniqueMonotonicClock
extends Clock {
    Clock utcClock = Clock.systemUTC();
    private static UniqueMonotonicClock instance = new UniqueMonotonicClock();
    long lastSec = 0L;
    int lastNanos = 0;
    int extraNanos = 0;
    AtomicReference<Instant> last = new AtomicReference<Instant>(Instant.now());
    protected static boolean useSync = false;

    private UniqueMonotonicClock() {
    }

    public static Clock getInstance() {
        return instance;
    }

    @Override
    public ZoneId getZone() {
        return this.utcClock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Instant syncInstant() {
        UniqueMonotonicClock uniqueMonotonicClock = this;
        synchronized (uniqueMonotonicClock) {
            Instant baseInstant = this.utcClock.instant();
            long s = baseInstant.getEpochSecond();
            int n = baseInstant.getNano();
            if (s > this.lastSec || s == this.lastSec && n > this.lastNanos) {
                this.lastSec = s;
                this.lastNanos = n;
                this.extraNanos = 0;
                return baseInstant;
            }
            return baseInstant.plusNanos(++this.extraNanos);
        }
    }

    protected Instant atomicInstant() {
        Instant lastInstant;
        Instant baseInstant;
        while (!((baseInstant = this.utcClock.instant()).isAfter(lastInstant = this.last.get()) ? this.last.compareAndSet(lastInstant, baseInstant) : this.last.compareAndSet(lastInstant, baseInstant = lastInstant.plusNanos(1L)))) {
        }
        return baseInstant;
    }

    @Override
    public Instant instant() {
        return useSync ? this.syncInstant() : this.atomicInstant();
    }

    public static void main(String[] arg) throws InterruptedException {
        Clock c = UniqueMonotonicClock.getInstance();
        useSync = false;
        Instant.now(c);
        Instant t = Instant.now(c);
        System.out.println(t.toString());
        System.out.println("MJD " + Timing.getMJD(t));
        System.out.println("millis " + Timing.getMillis(t) + " " + System.currentTimeMillis() + " " + (Timing.getMillis(t) - System.currentTimeMillis()));
        Instant t1 = Instant.now(c);
        Instant t2 = Instant.now(c);
        System.out.println(t1.toString());
        System.out.println(t2.toString());
        System.out.println(t1.until(t2, ChronoUnit.NANOS));
        Instant t3 = Instant.now(c);
        System.out.println(t3.toString());
        System.out.println(t2.until(t3, ChronoUnit.NANOS));
        Thread.sleep(1L);
        Instant t4 = Instant.now(c);
        System.out.println(t4.toString());
        System.out.println(t3.until(t4, ChronoUnit.NANOS));
        ConcurrentHashMap keys = new ConcurrentHashMap(10000000);
        int j = 0;
        while (j < 2) {
            if (j == 0) {
                useSync = true;
                System.out.println("**** SYNC");
            } else {
                useSync = false;
                System.out.println("**** ATOMIC");
            }
            t1 = Instant.now(c);
            int nt = 1;
            while (nt < 6) {
                System.out.println("n threads " + nt);
                keys.clear();
                Thread[] th = new Thread[nt];
                int i = 0;
                while (i < nt) {
                    class R
                    implements Runnable {
                        private final /* synthetic */ Clock val$c;
                        private final /* synthetic */ ConcurrentHashMap val$keys;

                        R(Clock clock, ConcurrentHashMap concurrentHashMap) {
                            this.val$c = clock;
                            this.val$keys = concurrentHashMap;
                        }

                        @Override
                        public void run() {
                            int i = 0;
                            while (i < 1000000) {
                                Instant t = Instant.now(this.val$c);
                                int h = t.hashCode();
                                if (this.val$keys.containsKey(h)) {
                                    System.out.println("duplicate " + t.toString() + " " + h);
                                } else {
                                    this.val$keys.put(h, h);
                                }
                                ++i;
                            }
                        }
                    }
                    th[i] = new Thread(new R(c, keys));
                    ++i;
                }
                i = 0;
                while (i < nt) {
                    th[i].start();
                    ++i;
                }
                i = 0;
                while (i < nt) {
                    th[i].join();
                    ++i;
                }
                t2 = Instant.now(c);
                System.out.println("Done " + t1.until(t2, ChronoUnit.MILLIS));
                System.out.println("hashtable contains " + keys.size());
                ++nt;
            }
            ++j;
        }
    }

    static final class Generator
    implements TemporalAccessor {
        long secs;
        int nanos;

        Generator(long s, int n) {
            this.secs = s;
            this.nanos = n;
        }

        @Override
        public final boolean isSupported(TemporalField field) {
            return field == ChronoField.INSTANT_SECONDS || field == ChronoField.NANO_OF_SECOND;
        }

        @Override
        public final long getLong(TemporalField field) {
            if (field == ChronoField.INSTANT_SECONDS) {
                return this.secs;
            }
            if (field == ChronoField.NANO_OF_SECOND) {
                return this.nanos;
            }
            throw new UnsupportedTemporalTypeException("only seconds and nanos are implemented");
        }
    }
}

