/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.scripting.ScriptingTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;

public abstract class CCS {
    private static boolean throwExceptions = true;
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.scripting");
    private static final MessagingFactory fac = MessagingFactory.getInstance().forSubsystem(Names.almostUniqueAgentName((String)"CCS-script"));
    private static final HashMap<Integer, ArrayList<ScriptingSubsystemWrapper>> subsystemsForThread = new HashMap();
    private static final HashMap<Integer, ArrayList<ScriptingStatusBusListenerWrapper>> listenersForThread = new HashMap();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            Integer id = nextId.getAndIncrement();
            subsystemsForThread.put(id, new ArrayList());
            listenersForThread.put(id, new ArrayList());
            return id;
        }
    };

    private CCS() {
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        CCS.throwExceptions = throwExceptions;
    }

    public static boolean getThrowExceptions() {
        return throwExceptions;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String subsystemName) throws RuntimeException {
        ScriptingSubsystemWrapper wrapper = new ScriptingSubsystemWrapper(subsystemName);
        subsystemsForThread.get(threadId.get()).add(wrapper);
        logger.finest((Object)("Adding subsystem " + subsystemName + " to Thread " + threadId.get() + " for a total of " + subsystemsForThread.get(threadId.get()).size()), new String[0]);
        return wrapper;
    }

    public static void cleanUp() {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.remove(threadId.get());
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            CCS.cleanupListener(l);
        }
        listeners.clear();
        ArrayList<ScriptingSubsystemWrapper> subsystems = subsystemsForThread.remove(threadId.get());
        for (ScriptingSubsystemWrapper s : subsystems) {
            s.close();
        }
        subsystems.clear();
        logger.finest((Object)("**** Cleaned up on ThreadLocal " + threadId.get() + " " + listeners.size() + " " + subsystems.size()), new String[0]);
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener) {
        ScriptingStatusBusListenerWrapper busListener = new ScriptingStatusBusListenerWrapper(listener);
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        listeners.add(busListener);
        logger.finest((Object)("Adding listener to Thread " + threadId.get() + " for a total of " + listeners.size()), new String[0]);
        fac.addStatusListener((StatusListens)busListener, "");
    }

    public static void removeStatusBusListener(ScriptingStatusBusListener listener) {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        ScriptingStatusBusListenerWrapper toDelete = null;
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            if (l.getScriptingStatusBusListener() != listener) continue;
            CCS.cleanupListener(l);
            toDelete = l;
            logger.finest((Object)("Removed listener on thread " + threadId.get() + " for a total of " + listeners.size()), new String[0]);
            break;
        }
        if (toDelete != null) {
            listeners.remove(toDelete);
        } else {
            logger.warning((Object)("Could not remove listener " + listener), new String[0]);
        }
    }

    private static void cleanupListener(ScriptingStatusBusListenerWrapper listener) {
        fac.removeStatusListener((StatusListens)listener);
    }

    public static ScriptingStatusBusMessage waitForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) throws ScriptingTimeoutException {
        SynchronousQueue<ScriptingStatusBusMessage> synchQueue = new SynchronousQueue<ScriptingStatusBusMessage>();
        ScriptingStatusBusListenerImpl innerListener = new ScriptingStatusBusListenerImpl(filter, synchQueue);
        CCS.addStatusBusListener(innerListener);
        ScriptingStatusBusMessage reply = null;
        try {
            try {
                reply = synchQueue.poll(timeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
                CCS.removeStatusBusListener(innerListener);
            }
        }
        finally {
            CCS.removeStatusBusListener(innerListener);
        }
        return reply;
    }

    static class ScriptingStatusBusListenerImpl
    implements ScriptingStatusBusListener {
        private final ScriptingStatusBusMessageFilter filter;
        private final SynchronousQueue<ScriptingStatusBusMessage> queue;

        ScriptingStatusBusListenerImpl(ScriptingStatusBusMessageFilter filter, SynchronousQueue<ScriptingStatusBusMessage> queue) {
            this.filter = filter;
            this.queue = queue;
        }

        @Override
        public void onStatusBusMessage(ScriptingStatusBusMessage bm) {
            if (this.filter.accept(bm)) {
                logger.finest((Object)("Found match with " + bm), new String[0]);
                this.queue.offer(bm);
            }
        }
    }

    static class ScriptingStatusBusListenerWrapper
    implements StatusListener {
        private final ScriptingStatusBusListener scriptingListener;

        ScriptingStatusBusListenerWrapper(ScriptingStatusBusListener scriptingListener) {
            this.scriptingListener = scriptingListener;
        }

        public void onStatus(BusMessage bm) {
            this.scriptingListener.onStatusBusMessage(new ScriptingStatusBusMessage(bm));
        }

        protected ScriptingStatusBusListener getScriptingStatusBusListener() {
            return this.scriptingListener;
        }
    }
}

