/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.KeyValueStatusListener;
import org.lsst.ccs.bus.TrendingStatus;

public class Tracer
extends Subsystem
implements KeyValueStatusListener {
    public static void main(String[] args) {
        Tracer t = new Tracer();
        if (args.length > 0) {
            t.setName("statusTracer");
            t.setListenToStatus(true);
            t.setStatusBusSelector("");
            t.setCommandBusSelector("");
        } else {
            t.setListenToStatus(false);
        }
        t.start();
        t.stayAlive();
    }

    public Tracer() {
        this.setName("tracer");
    }

    public void onStatus(BusMessage s) {
        Object o;
        System.out.println(s);
        if (s instanceof TrendingStatus && (o = ((TrendingStatus)s).getValue()) instanceof DataValueNotification) {
            DataValueNotification dv = (DataValueNotification)o;
            Map map = dv.getTrendingMap();
            if (map == null) {
                System.out.println("  null trendingMap");
            } else {
                for (String k : map.keySet()) {
                    System.out.println("   >>> " + k + " " + map.get(k));
                }
            }
            try {
                Object payload = dv.getRealData();
                if (payload == null) {
                    System.out.println("  null payload");
                } else {
                    System.out.println("  payload: " + payload);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("   payload throws class not found");
            }
        }
    }

    public void onKeyValueStatusDecomposition(String source, long timeStamp, String key, Object value, int commonID) {
        System.out.println("KV from " + source + " @" + timeStamp + " : " + key + " -> " + value);
    }

    public void onCommand(Command cmd) {
        System.out.println("Command " + cmd + " cmd correl(" + cmd.getCorrelId() + ")");
    }

    public void onReply(CommandReply cmd) {
        System.out.println("CommandReply " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }

    public void onAck(CommandAck cmd) {
        System.out.println("CommandAck " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }
}

