/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.LogListener;

public class LogTracer
extends Subsystem
implements LogListener {
    public static void main(String[] args) {
        LogTracer t = new LogTracer();
        if (args.length > 0) {
            t.setName("statusTracer");
            t.setListenToStatus(true);
            t.setStatusBusSelector("");
            t.setCommandBusSelector("");
        } else {
            t.setListenToStatus(false);
        }
        t.start();
        t.stayAlive();
    }

    public LogTracer() {
        this.setName("logtracer");
        this.fac.addLogListener((LogListener)this);
    }

    public void onStatus(BusMessage s) {
        System.out.println(s);
    }

    public void onCommand(Command cmd) {
        System.out.println("Command " + cmd + " cmd correl(" + cmd.getCorrelId() + ")");
    }

    public void onReply(CommandReply cmd) {
        System.out.println("CommandReply " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }

    public void onAck(CommandAck cmd) {
        System.out.println("CommandAck " + cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }

    public void onLog(LogEvent logEvent) {
        System.out.println("Log from " + logEvent.getOrigin() + ":" + logEvent);
    }
}

