/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.PingCommand;
import org.lsst.ccs.bus.PingStatus;
import org.lsst.ccs.bus.StatusForEnd;
import org.lsst.ccs.bus.StatusForStart;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.SubsystemToken;

public class CommandPresenceAgent
implements StatusListener,
BusMembershipListener {
    private LinkedHashMap<String, MasterSlave> map = new LinkedHashMap();
    private MessagingFactory fac;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatus(BusMessage s) {
        if (s instanceof SubsystemToken) {
            String subsystem = s.getOrigin();
            SubsystemToken token = (SubsystemToken)s;
            CommandPresenceAgent commandPresenceAgent = this;
            synchronized (commandPresenceAgent) {
                if (s instanceof PingStatus) {
                    this.map.put(subsystem, new MasterSlave(token.isMaster(), token.isSlave()));
                } else if (s instanceof StatusForEnd) {
                    this.map.remove(subsystem);
                } else if (s instanceof StatusForStart) {
                    this.map.put(subsystem, new MasterSlave(token.isMaster(), token.isSlave()));
                }
            }
        }
    }

    public void connecting(String agentName, String otherInfos) {
    }

    public synchronized void disconnecting(String agentName, String otherInfos) {
        this.map.remove(agentName);
    }

    public void anormalEvent(Exception exc) {
    }

    public CommandPresenceAgent(MessagingFactory fac) {
        this.fac = fac;
        fac.addStatusListener((StatusListens)this);
        fac.addMembershipListener((BusMembershipListener)this);
        fac.sendCommand((Command)new PingCommand());
    }

    public synchronized void reset() {
        this.map.clear();
        this.fac.sendCommand((Command)new PingCommand());
    }

    public synchronized List<String> list(boolean masters, boolean slaves) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, MasterSlave> entry : this.map.entrySet()) {
            MasterSlave masterSlave = entry.getValue();
            if (masters != masterSlave.master || slaves != masterSlave.slave) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public synchronized List<String> listMasters() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, MasterSlave> entry : this.map.entrySet()) {
            MasterSlave masterSlave = entry.getValue();
            if (!masterSlave.master) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public synchronized List<String> listSlaves() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, MasterSlave> entry : this.map.entrySet()) {
            MasterSlave masterSlave = entry.getValue();
            if (!masterSlave.slave) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public synchronized List<String> listAll() {
        return this.fac.connectedToCommand();
    }

    static class MasterSlave {
        boolean master;
        boolean slave;

        MasterSlave(boolean master, boolean slave) {
            this.master = master;
            this.slave = slave;
        }
    }
}

