/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.gruth.jutils.DescriptiveNode;

public class LocalDescriptionToConfigurationText {
    public static void main(String[] args) throws Exception {
        SubsystemDescription description;
        if (args.length < 1) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalDescriptionToConfigurationText pathName\n where filename is  xx.ser or xx.groovy or xx.groo\n pathName could be file (with '/' file separator) or resource path");
            System.exit(1);
        }
        String pathName = args[0];
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath((String)pathName);
        InputStream is = CommonResources.getInput(LocalDescriptionToConfigurationText.class, (String)pathName);
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(is);
            DescriptiveNode componentNode = (DescriptiveNode)ois.readObject();
            description = Factories.createRawSubsystemDescription((String)namesAndTag.getSubsystemName(), (String)namesAndTag.getTag(), (String)"", (String)"", (Serializable)componentNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE);
            ois.close();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            description = Factories.createRawSubsystemDescription((String)namesAndTag.getSubsystemName(), (String)namesAndTag.getTag(), (String)"", (String)"", (InputStream)is, (String)"ISO-8859-1");
        } else {
            throw new IllegalArgumentException(" not supported : " + pathName);
        }
        Collection descriptions = description.getPossibleDescriptions(10);
        description.addParameterDescriptions(descriptions);
        namesAndTag.setConfigName("XXXXX");
        String baseName = ConfigUtils.baseNameFromNames((NamesAndTag)namesAndTag);
        PrintWriter printWriter = new PrintWriter(String.valueOf(baseName) + ".properties", "ISO-8859-1");
        description.generateConfigProperties(printWriter, 10);
        printWriter.flush();
        printWriter.close();
    }
}

