/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.MemoryDAO;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.EffectiveNode;
import org.lsst.gruth.nodes.ComponentFactory;
import org.lsst.gruth.nodes.Utils;

public class BootUtils {
    static String userName;
    static String version;
    static int level;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !BootUtils.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", BootUtils.class, (String)"org-lsst-ccs-startup")) {
            throw new AssertionError();
        }
        Logger.configure();
        userName = "";
        version = "1.0";
        level = 10;
    }

    public static DescriptiveNode getDescriptiveNode(String pathName) throws Exception {
        DescriptiveNode componentNode = null;
        InputStream is = CommonResources.getInput(BootUtils.class, (String)pathName);
        if (is == null) {
            throw new IOException(String.valueOf(pathName) + " not found through CommonResources");
        }
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (DescriptiveNode)ois.readObject();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
        }
        return componentNode;
    }

    public static EffectiveNode getEffectiveNode(DescriptiveNode descriptionNode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ComponentFactory fact = new ComponentFactory(descriptionNode);
        EffectiveNode top = fact.build();
        top.doCallsFromTop();
        return top;
    }

    public static EffectiveNode getEffectiveNodeFromFile(String pathName) throws Exception {
        DescriptiveNode descriptiveNode = BootUtils.getDescriptiveNode(pathName);
        return BootUtils.getEffectiveNode(descriptiveNode);
    }

    public static Subsystem getRawSubsystemFromEffectiveNode(EffectiveNode effectiveNode, ConfigProfile profile, String subsystemName, String configName, String tag, ConfigurationProxy confProxy) {
        CCSCst.LOG_TODO.fine((Object)"TODO: Configuration proxy should also be able to interact with remote database (switch between local and remote?)", new String[0]);
        NodeModularSubsystem system = new NodeModularSubsystem(subsystemName, confProxy, effectiveNode);
        return system;
    }

    public static Subsystem rawSubsystemFromDescriptionNode(DescriptiveNode descriptionNode, ConfigProfile profile, String subsystemName, String configName, String tag, ConfigurationProxy confProxy) throws Exception {
        EffectiveNode top = BootUtils.getEffectiveNode(descriptionNode);
        return BootUtils.getRawSubsystemFromEffectiveNode(top, profile, subsystemName, configName, tag, confProxy);
    }

    public static Subsystem getSubsystemFromFile(String pathName) throws Exception {
        return BootUtils.getSubsystemFromFile(pathName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName) throws Exception {
        LocalBootObject localBootObject = propertiesFileName == null ? new LocalBootObject(pathName) : new LocalBootObject(pathName, propertiesFileName);
        return localBootObject.getSubsystem();
    }

    public static void saveInCache(DescriptiveNode node, String subsystemName, String configName, String tag) {
    }

    public static DescriptiveNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static class LocalBootObject {
        DescriptiveNode descriptiveNode;
        DescriptiveNode modifiedDescriptiveNode;
        EffectiveNode effectiveNode;
        Subsystem subsystem;
        String subsystemName;
        String configurationName;
        String tagName;

        public LocalBootObject(String pathName) throws Exception {
            this.setNames(pathName, null);
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            this.subsystemFromDescriptionNode(this.descriptiveNode, this.subsystemName, this.configurationName, this.tagName, null);
        }

        public LocalBootObject(String pathName, String configFileName) throws Exception {
            this.setNames(pathName, configFileName);
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            Properties configProps = null;
            if (configFileName != null) {
                configProps = new Properties();
                InputStream propsIs = BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)configFileName, BootUtils.class);
                configProps.load(propsIs);
            }
            this.subsystemFromDescriptionNode(this.descriptiveNode, this.subsystemName, this.configurationName, this.tagName, configProps);
        }

        private void setNames(String pathName, String configFileName) {
            NamesAndTag namesAndTag = ConfigUtils.namesFromPath((String)pathName);
            this.subsystemName = namesAndTag.getSubsystemName();
            this.configurationName = namesAndTag.getConfigName();
            this.tagName = namesAndTag.getTag();
            if (configFileName != null) {
                namesAndTag = ConfigUtils.namesFromPath((String)configFileName);
                if (!this.subsystemName.equals(namesAndTag.getSubsystemName())) {
                    throw new IllegalArgumentException(" subsystem names differs :" + this.subsystemName + " <> " + namesAndTag.getSubsystemName());
                }
                String newConfigName = namesAndTag.getConfigName();
                String newTagName = namesAndTag.getTag();
                if (this.configurationName.length() != 0 && newConfigName.length() != 0 && !this.configurationName.equals(newConfigName)) {
                    throw new IllegalArgumentException(" configuration name clash :" + this.configurationName + " <> " + newConfigName);
                }
                if (this.tagName.length() != 0 && newTagName.length() != 0 && !this.tagName.equals(newTagName)) {
                    throw new IllegalArgumentException(" tag name clash :" + this.tagName + " <> " + newTagName);
                }
                if (newConfigName.length() != 0) {
                    this.configurationName = newConfigName;
                }
                if (newTagName.length() != 0) {
                    this.tagName = newTagName;
                }
            }
        }

        public DescriptiveNode getDescriptiveNode() {
            return this.descriptiveNode;
        }

        public DescriptiveNode getModifiedDescriptiveNode() {
            return this.modifiedDescriptiveNode;
        }

        public EffectiveNode getEffectiveNode() {
            return this.effectiveNode;
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getConfigurationName() {
            return this.configurationName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Object getRunningObject(String key) {
            return this.effectiveNode.getIndirect((Object)key);
        }

        private void subsystemFromDescriptionNode(DescriptiveNode componentNode, String subsystemName, String configName, String tag, Properties configProps) throws Exception {
            this.modifiedDescriptiveNode = componentNode;
            SubsystemDescription description = Factories.createSubsystemDescription((String)subsystemName, (String)tag, (String)userName, (String)version, (Serializable)componentNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE, (ParameterFilter)SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
            CCSCst.LOG_TODO.fine((Object)"TODO: DAO at creation of SubsystemDescription should also be able to interact with remote database (switch between local and remote?)", new String[0]);
            MemoryDAO dao = new MemoryDAO();
            dao.saveAbstractDescription(description);
            ConfigProfile configProfile = Factories.createConfigProfile((SubsystemDescription)description, (String)configName, (String)tag, (String)userName, (int)level);
            if (configProps != null) {
                configProfile.mergeProperties(configProps);
                this.modifiedDescriptiveNode = configProfile.getModifiedConfigurationData();
            }
            dao.saveAbstractConfig(configProfile);
            this.effectiveNode = BootUtils.getEffectiveNode(this.modifiedDescriptiveNode);
            LocalConfigurationProxy configurationAccess = new LocalConfigurationProxy(configProfile);
            this.subsystem = BootUtils.getRawSubsystemFromEffectiveNode(this.effectiveNode, configProfile, subsystemName, configName, tag, (ConfigurationProxy)configurationAccess);
        }
    }
}

