/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.AgentPresenceListener;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystem.shell.SynchronousCommandInvoker;
import org.lsst.ccs.utilities.structs.TreeBranch;

public final class ConsoleBusMaster
extends BusMaster
implements AgentPresenceListener {
    private final MessagingFactory localMessagingFactory;
    private final RouteSelectionCommandSet rsc;
    private final CompositeCommandSet ccs;
    private final SynchronousCommandInvoker sci;
    private static final int timeoutMillis = 10000;
    private final Map<String, RoutingCommandSet> routes = new LinkedHashMap<String, RoutingCommandSet>();

    ConsoleBusMaster() {
        super("console");
        this.localMessagingFactory = MessagingFactory.getInstance().forSubsystem(this.getName());
        this.sci = new SynchronousCommandInvoker(new SynchronousCommandAgent(this.localMessagingFactory), 10000);
        CommandSetBuilder builder = new CommandSetBuilder();
        this.ccs = new CompositeCommandSet();
        this.ccs.add(builder.buildCommandSet((Object)new BusMasterCommands()));
        this.rsc = new RouteSelectionCommandSet(this.ccs);
    }

    private void init() {
        this.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        List agents = this.getAgentPresenceManager().listAgent(0);
        for (Agent agent : agents) {
            this.connecting(agent);
        }
    }

    private List<String> availableSubsystems() {
        return this.localMessagingFactory.connectedToCommand();
    }

    CompositeCommandSet getCommandSet() {
        return this.rsc;
    }

    private synchronized void addDictionary(String name, Dictionary dictionary) {
        if (this.routes.containsKey(name)) {
            throw new RuntimeException("Error: Route " + name + " already exist");
        }
        RoutingCommandSet crcs = new RoutingCommandSet(name, (CommandSet)new BusCommandSet(this.sci, name, dictionary));
        this.ccs.add((CommandSet)crcs);
        this.routes.put(name, crcs);
    }

    private synchronized void removeDictionaryForSubsystem(String agentName) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String routeName : this.routes.keySet()) {
            if (!routeName.equals(agentName) && !routeName.startsWith(String.valueOf(agentName) + "/")) continue;
            this.ccs.remove((CommandSet)this.routes.get(routeName));
            toRemove.add(routeName);
        }
        for (String routeName : toRemove) {
            this.routes.remove(routeName);
        }
    }

    public static void main(String[] argv) throws Exception {
        ConsoleBusMaster busMaster = new ConsoleBusMaster();
        busMaster.init();
        JLineShell shell = new JLineShell((CommandSet)busMaster.getCommandSet(), "${target} ccs>");
        shell.run();
        System.exit(0);
    }

    public void connecting(Agent agent) {
        if (!(agent.getType().equals((Object)Agent.AgentType.LISTENER) || agent.getType().equals((Object)Agent.AgentType.CONSOLE) || this.routes.containsKey(agent.getName()))) {
            AddSubsystem add = new AddSubsystem(agent.getName());
            Thread t = new Thread(add);
            t.start();
        }
    }

    public void disconnecting(Agent agent) {
        this.removeDictionaryForSubsystem(agent.getName());
    }

    private class AddSubsystem
    implements Runnable {
        private final String agentName;

        AddSubsystem(String name) {
            this.agentName = name;
        }

        @Override
        public void run() {
            try {
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getSystemDictionary", new Object[0]);
                cmd.setDestination(this.agentName);
                Object subsystemDictionary = ConsoleBusMaster.this.sci.invoke(cmd, 10000);
                if (subsystemDictionary instanceof Dictionary) {
                    ConsoleBusMaster.this.addDictionary(this.agentName, (Dictionary)subsystemDictionary);
                }
                cmd = new ModuleInvokerCommand("getComponentDictionariesTree", new Object[0]);
                cmd.setDestination(this.agentName);
                Object componentDictionariesTree = ConsoleBusMaster.this.sci.invoke(cmd, 10000);
                if (componentDictionariesTree instanceof TreeBranch) {
                    TreeBranch tree = (TreeBranch)componentDictionariesTree;
                    for (DictionaryContext dc : tree) {
                        ConsoleBusMaster.this.addDictionary(String.valueOf(this.agentName) + "/" + dc.getName(), dc.getDictionary());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class BusMasterCommands {
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses", alias="ls")
        public List<String> listSubsystems() {
            return ConsoleBusMaster.this.availableSubsystems();
        }

        @Command(description="Set timeout for future command sent on CCS bus")
        public void set(@Argument(name="item") TimeoutEnum what, @Argument(name="value", defaultValue="10000") int timeoutMillis) {
            ConsoleBusMaster.this.sci.setTimeoutMillis(timeoutMillis);
        }
    }

    public static enum TimeoutEnum {
        TIMEOUT;

    }
}

