/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.subsystem.shell.SynchronousCommandInvoker;

class BusCommandSet
implements CommandSet {
    private final String dictionaryPath;
    private final Dictionary dict;
    private final SynchronousCommandInvoker sci;

    BusCommandSet(SynchronousCommandInvoker sci, String dictionaryPath, Dictionary dict) {
        this.sci = sci;
        this.dictionaryPath = dictionaryPath;
        this.dict = dict;
    }

    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    public Object invoke(BasicCommand bc) throws CommandInvocationException {
        int i;
        Object[] args;
        DictionaryCommand findCommand = this.dict.findCommand(bc);
        if (findCommand == null) {
            throw new CommandInvocationException("No handler found for command %s with %d arguments", new Object[]{bc.getCommand(), bc.getArgumentCount()});
        }
        String command = bc.getCommand();
        if (bc instanceof TokenizedCommand) {
            args = new String[]{};
            TokenizedCommand tc = (TokenizedCommand)bc;
            i = 0;
            while (i < tc.getArgumentCount()) {
                command = String.valueOf(command) + " " + tc.getArgument(i);
                ++i;
            }
        } else if (bc instanceof RawCommand) {
            args = new String[bc.getArgumentCount()];
            RawCommand rc = (RawCommand)bc;
            i = 0;
            while (i < rc.getArgumentCount()) {
                args[i] = rc.getArgument(i);
                ++i;
            }
        } else {
            throw new CommandInvocationException("Unknown subclass of BasicCommand: " + bc.getClass(), new Object[0]);
        }
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, args);
        cmd.setUnParsed(bc instanceof TokenizedCommand);
        cmd.setDestination(this.dictionaryPath);
        try {
            return this.sci.invoke(cmd);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command", (Throwable)ex);
        }
    }
}

