/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.utils;

import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.utilities.logging.IsLoggableDelegate;
import org.lsst.ccs.utilities.logging.LogManagement;
import org.lsst.ccs.utilities.logging.LogPropertiesLoader;
import org.lsst.ccs.utilities.logging.TextFormatter;
import org.lsst.ccs.utilities.tracers.Tracer;

public class LogBusHandler
extends Handler
implements Closeable {
    protected static IsLoggableDelegate isLoggableDelegate = new IsLoggableDelegate();
    protected MessagingFactory fac;
    protected boolean panicState = false;
    protected boolean closed = false;
    protected String subSystemName;
    protected ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread res = new Thread(r, "logbusHandlerExecutor");
            res.setDaemon(true);
            return res;
        }
    });
    protected volatile boolean logBusInitialized = false;

    public LogBusHandler(String subsystemName, MessagingFactory fac) {
        this.fac = fac;
        this.subSystemName = subsystemName;
        this.init();
    }

    public LogBusHandler() {
        this.init();
    }

    public void setMessagingFactory(MessagingFactory fact) {
        if (this.fac == null) {
            this.fac = fact;
            this.subSystemName = fact.getSubsystemName();
        }
    }

    private void init() {
        this.setLevel(Level.WARNING);
        String className = this.getClass().getCanonicalName();
        Formatter formatter = LogPropertiesLoader.loaderGetFormatterProperty((String)(String.valueOf(className) + ".formatter"), (Formatter)new TextFormatter());
        this.setFormatter(formatter);
        Level level = LogPropertiesLoader.loaderGetLevelProperty((String)(String.valueOf(className) + ".level"), (Level)Level.WARNING);
        this.setLevel(level);
    }

    public boolean inPanicState() {
        return this.panicState;
    }

    public void setPanicState(boolean panicState) {
        this.panicState = panicState;
    }

    public String getSubSystemName() {
        return this.subSystemName;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Object object;
        Object[] objects;
        assert (Tracer.trace((String)(" busHandler publish request : [" + this.getLevel() + "] " + this.getFormatter().format(record))));
        if (this.closed) {
            return;
        }
        Level curLevel = record.getLevel();
        if (curLevel == null) {
            curLevel = Level.SEVERE;
            record.setLevel(curLevel);
        }
        if (curLevel.equals(Level.SEVERE) && (objects = record.getParameters()) != null && objects.length > 0 && (object = objects[0]) instanceof LogEvent) {
            Throwable th = record.getThrown();
            LogManagement.ERROR_MANAGER.error("suspected panic for: " + object, th instanceof Exception ? (Exception)th : null, 1);
            return;
        }
        if (!this.inPanicState() && this.isLoggable(record)) {
            try {
                assert (Tracer.trace((String)(" busHandler publishing: [" + this.getLevel() + "] " + record)));
                final LogEvent event = this.generateLogEvent(record);
                this.executor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (!$assertionsDisabled && !Tracer.trace((String)(" busHandler sending log: " + event))) {
                            throw new AssertionError();
                        }
                        LogBusHandler.this.sendLogEvent(event);
                        return null;
                    }
                });
            }
            catch (Throwable th) {
                this.setPanicState(true);
                LogManagement.ERROR_MANAGER.error("suspected panic for: " + th.toString(), th instanceof Exception ? (Exception)th : null, 1);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.closed = true;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record) && isLoggableDelegate.isLoggable(record);
    }

    @Override
    public void setLevel(Level level) {
        if (!this.logBusInitialized) {
            if (level.equals(Level.OFF)) {
                super.setLevel(level);
                return;
            }
            LogRecord record = new LogRecord(Level.INFO, "starting log bus");
            this.sendLogEvent(this.generateLogEvent(record));
            this.logBusInitialized = true;
        }
        super.setLevel(level);
    }

    void sendLogEvent(LogEvent event) {
        if (this.fac != null) {
            this.fac.sendLogEvent(event);
        }
    }

    LogEvent generateLogEvent(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String loggerName = record.getLoggerName();
        String sourceName = String.valueOf(record.getSourceClassName()) + "#" + record.getSourceMethodName();
        Formatter formatter = this.getFormatter();
        String formattedDetail = formatter != null ? this.getFormatter().format(record) : String.valueOf(record);
        String levelString = String.valueOf(record.getLevel());
        return new LogEvent(threadName, loggerName, sourceName, formattedDetail, levelString);
    }
}

