/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourceDirectory;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public abstract class BootstrapUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    protected static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = String.valueOf(DISTRIBUTION_LIB_DIRECTORY) + "jni" + FILE_SEPARATOR;
    protected static final String APPLICATION_MAINCLASS_PROPERTY = "org.lsst.ccs.application.mainClass";
    protected static final String OBSOLETE_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static List<String> listOfApplications = null;
    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(".*(\\$\\[env\\.(.*)\\]).*");
    private static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    private static final String CCS_DISTRIBUTION_PATH_ENV_VAR = "CCS_DISTRIBUTION_PATH";
    private static String ccsDistributionRootDirectory = null;
    private static ResourcesTree resourcesTree = null;

    protected static void reset() {
        resourcesTree = null;
        ccsDistributionRootDirectory = null;
        listOfApplications = null;
    }

    public static synchronized ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getUserProvidedResourceDirectories(), null, true);
            for (String resourceDirectory : resourceDirectories) {
                File resourceDir = new File(resourceDirectory);
                if (resourceDir.exists()) {
                    if (additionalResourceDirectories.contains(resourceDirectory)) {
                        resourcesTree.addUserResourceDirectory(resourceDirectory);
                        continue;
                    }
                    resourcesTree.addDistributionResourceDirectory(resourceDirectory);
                    continue;
                }
                if (!Bootstrap.isBootstrapEnvironment()) continue;
                System.out.println("***** WARNING: resource directory " + resourceDirectory + " does not exist.");
            }
        }
        return resourcesTree;
    }

    protected static String getUserProvidedResourceDirectories() {
        String userProvidedResourceDirectories = null;
        if ("true".equals(System.getProperty("org.lsst.ccs.bootstrap.test")) && (userProvidedResourceDirectories = System.getProperty("org.lsst." + CCS_RESOURCE_PATH_ENV_VAR.replace("_", ".").toLowerCase())) != null) {
            return userProvidedResourceDirectories;
        }
        return System.getenv(CCS_RESOURCE_PATH_ENV_VAR);
    }

    protected static String getUserProvidedDistributionDirectories() {
        String userProvidedDistributionDirectories = null;
        if ("true".equals(System.getProperty("org.lsst.ccs.bootstrap.test")) && (userProvidedDistributionDirectories = System.getProperty("org.lsst." + CCS_DISTRIBUTION_PATH_ENV_VAR.replace("_", ".").toLowerCase())) != null) {
            return userProvidedDistributionDirectories;
        }
        return System.getenv(CCS_DISTRIBUTION_PATH_ENV_VAR);
    }

    static List<String> getOrderedListOfResourceDirectories() {
        String userProvidedResourceDirs = BootstrapUtils.getUserProvidedResourceDirectories();
        String userProvidedDistributionDirs = BootstrapUtils.getUserProvidedDistributionDirectories();
        return BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, userProvidedDistributionDirs, true);
    }

    static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, String userProvidedDistributions, boolean checkExistance) {
        String distributionResourceDirectoriy = BootstrapUtils.getDistributionResourcesDirectory();
        List<String> additionaDistributionResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributions, DISTRIBUTION_RESOURCES_DIRECTORY, checkExistance);
        List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedResourceDirs, null, checkExistance);
        ArrayList<String> orderedListOfResourceDirectories = new ArrayList<String>();
        for (String dir : additionalResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        orderedListOfResourceDirectories.add(distributionResourceDirectoriy);
        for (String dir : additionaDistributionResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        return orderedListOfResourceDirectories;
    }

    protected static List<String> extractDirectoriesFromPath(String directoryPath, String appendDirectory, boolean checkExistance) {
        ArrayList<String> extractedDirectories = new ArrayList<String>();
        if (directoryPath != null && !"".equals(directoryPath)) {
            StringTokenizer dirsToken = new StringTokenizer(directoryPath, PATH_SEPARATOR);
            while (dirsToken.hasMoreTokens()) {
                String resourceDir = dirsToken.nextToken().trim();
                if (!resourceDir.endsWith(FILE_SEPARATOR)) {
                    resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
                }
                if (appendDirectory != null && !"".equals(appendDirectory)) {
                    if (!appendDirectory.endsWith(FILE_SEPARATOR)) {
                        appendDirectory = String.valueOf(appendDirectory) + FILE_SEPARATOR;
                    }
                    resourceDir = String.valueOf(resourceDir) + appendDirectory;
                }
                Path p = Paths.get(BootstrapUtils.getCCSDistributionRootDirectory(), new String[0]);
                resourceDir = resourceDir.replace("~", System.getProperty("user.home"));
                if (!(resourceDir = p.resolve(resourceDir).normalize().toString()).endsWith(FILE_SEPARATOR)) {
                    resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
                }
                File dir = new File(resourceDir);
                if (checkExistance && !dir.exists()) {
                    if (!Bootstrap.isBootstrapEnvironment()) continue;
                    System.out.println("** Ignoring resource directory " + resourceDir + " as it does not exist.");
                    System.out.println("** Please update the environment variable CCS_RESOURCE_PATH or CCS_DISTRIBUTION_PATH");
                    continue;
                }
                extractedDirectories.add(resourceDir);
            }
        }
        return extractedDirectories;
    }

    public static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_LIB_DIRECTORY;
    }

    static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JNI_DIRECTORY;
    }

    static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JARS_DIRECTORY;
    }

    public static String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getCCSDistributionRootDirectory(Bootstrap.getLoaderClass());
        }
        return ccsDistributionRootDirectory;
    }

    private static String getCCSDistributionRootDirectory(Class clazz) {
        block5: {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            try {
                Path path = Paths.get(location.toURI());
                String sourceCodeLocation = path.toString();
                if (sourceCodeLocation.endsWith(".jar")) {
                    ccsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
                    break block5;
                }
                if (path.toFile().isDirectory()) {
                    ccsDistributionRootDirectory = String.valueOf(sourceCodeLocation) + FILE_SEPARATOR;
                    break block5;
                }
                throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Could not process souce code location ", x);
            }
        }
        if (ccsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            ccsDistributionRootDirectory = ccsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return ccsDistributionRootDirectory;
    }

    public static synchronized List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            ArrayList<String> allPropertiesInResources = new ArrayList<String>();
            for (ResourceDirectory dir : BootstrapUtils.getBootstrapResourcesTree().getResourceDirectoryList()) {
                String[] listOfResources;
                File resourceDirectoryFile = new File(dir.getResouceDirectoryPath());
                if (!resourceDirectoryFile.exists() || !resourceDirectoryFile.isDirectory()) continue;
                String[] stringArray = listOfResources = resourceDirectoryFile.list();
                int n = listOfResources.length;
                int n2 = 0;
                while (n2 < n) {
                    String resource = stringArray[n2];
                    if (resource.endsWith(".properties")) {
                        allPropertiesInResources.add(resource);
                    }
                    ++n2;
                }
            }
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String mainClass = props.getProperty(APPLICATION_MAINCLASS_PROPERTY);
                String applicationName = propertyFile.replace(".properties", "");
                if (mainClass == null || mainClass.isEmpty() || listOfApplications.contains(applicationName)) continue;
                listOfApplications.add(applicationName);
            }
        }
        return listOfApplications;
    }

    static Properties getApplicationDefinitionProperties(String application) {
        if (!application.endsWith(".properties")) {
            application = String.valueOf(application) + ".properties";
        }
        return BootstrapResourceUtils.getBootstrapProperties(application);
    }

    static String getBootstrapLibraryPath() {
        String libraryPath = String.valueOf(BootstrapUtils.getDistributionJniDirectory()) + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = String.valueOf(libraryPath) + File.pathSeparator + existingLibraryPath;
        }
        return libraryPath;
    }

    public static String parseProperty(String inputProperty) {
        String outProperty = inputProperty;
        Matcher m = envVar_pattern.matcher(outProperty);
        if (m.matches()) {
            String envVarValue = System.getenv(m.group(2));
            if (envVarValue != null) {
                outProperty = outProperty.replace(m.group(1), envVarValue);
            } else if (Bootstrap.isBootstrapEnvironment()) {
                System.out.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
            }
        }
        return outProperty;
    }
}

