/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.types.TypeUtils;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    private ASubsystemDescription subsystemDescription;
    private AConfigProfile baseProfile;
    private AConfigProfile currentProfile;
    private volatile boolean inEngineeringMode;
    private MessagingFactory fac;
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");

    public LocalConfigurationProxy(ConfigProfile configProfile) {
        this.baseProfile = (AConfigProfile)configProfile;
        this.subsystemDescription = this.baseProfile.getSubsystemDesc();
    }

    public synchronized String getConfigurationName() {
        return this.currentProfile.getName();
    }

    public synchronized String getTagName() {
        return this.currentProfile.getTag();
    }

    public synchronized void startNewConfigurationContext() {
        if (this.inEngineeringMode) {
            throw new IllegalStateException("already in engineering mode");
        }
        this.inEngineeringMode = true;
        this.currentProfile = new AConfigProfile(this.baseProfile, this.baseProfile.getName(), this.baseProfile.getTag(), "", 10, true);
    }

    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path;
        ParameterDescription parameterDescription;
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        if (!this.inEngineeringMode) {
            this.startNewConfigurationContext();
        }
        if ((parameterDescription = this.subsystemDescription.fetch(path = new ParameterPath(componentName, "", parameterName))) == null) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.subsystemDescription.getSubsystemName());
        }
        if (parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
        Object res = parameterDescription.checkValue(strValue);
        return new ViewValue(strValue, res);
    }

    public synchronized void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), value);
    }

    public synchronized void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), strValue);
    }

    public synchronized void registerConfiguration(String configurationName, String tagName) throws IOException {
        if (!this.inEngineeringMode) {
            return;
        }
        NamesAndTag namesAndTag = new NamesAndTag(this.subsystemDescription.getSubsystemName(), configurationName, tagName);
        this.baseProfile = new AConfigProfile(this.currentProfile, this.currentProfile.getName(), this.currentProfile.getTag(), "", 10, false);
        this.currentProfile = this.baseProfile.clone();
        String baseName = ConfigUtils.baseNameFromNames(namesAndTag);
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)baseName);
        if (pathInBootstrap == null) {
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            if (topMostUserDirectory == null) {
                String workdir = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.workdir", "");
                if (!workdir.isEmpty() && !workdir.endsWith(BootstrapUtils.FILE_SEPARATOR)) {
                    workdir = String.valueOf(workdir) + BootstrapUtils.FILE_SEPARATOR;
                }
                baseName = String.valueOf(workdir) + baseName;
            } else {
                baseName = String.valueOf(topMostUserDirectory) + baseName;
            }
        } else {
            baseName = pathInBootstrap;
        }
        if (!baseName.endsWith(".properties")) {
            baseName = String.valueOf(baseName) + ".properties";
        }
        this.logger.info((Object)("Saving configuration tag " + tagName + " to " + baseName), new String[0]);
        PrintWriter printWriter = new PrintWriter(baseName, "ISO-8859-1");
        this.currentProfile.generateConfigProperties(printWriter);
        this.inEngineeringMode = false;
        printWriter.flush();
        printWriter.close();
    }

    public synchronized void dropModifications() {
        this.currentProfile = this.baseProfile.clone();
        this.inEngineeringMode = false;
    }

    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName();
        Object res = Constraints.check(type, strValue, null);
        return res;
    }

    public void setMessagingFactory(MessagingFactory factory) {
        this.fac = factory;
    }
}

