/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;

@Table(name="ASubsystemDescription", uniqueConstraints={@UniqueConstraint(columnNames={"subsystemName", "tag"})})
@Entity
@Immutable
class ASubsystemDescription
extends SubsystemDescription
implements Cloneable {
    private static final long serialVersionUID = 7518445583831244327L;
    @Id
    @GeneratedValue
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    protected Set<AParameterDescription> paramDescriptions = new HashSet<AParameterDescription>();
    @Transient
    private Set<AParameterDescription> unModifiableParams = Collections.unmodifiableSet(this.paramDescriptions);

    ASubsystemDescription() {
    }

    public ASubsystemDescription(String subsystemName, String tag, String user, String version, Serializable configurationData, DataFlavour dataFlavour) {
        super(subsystemName, tag, user, version, configurationData, dataFlavour);
    }

    public ASubsystemDescription(SubsystemDescription other) {
        super(other);
        for (ParameterDescription parameterDescription : other.getParamDescriptionSet()) {
            this.paramDescriptions.add(new AParameterDescription(parameterDescription));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    void setId(long id) {
        this.id = id;
    }

    @Override
    public Set<? extends ParameterDescription> getParamDescriptionSet() {
        return this.getParamDescriptions();
    }

    @Override
    public long getStartTimestamp() {
        return super.getStartTimestamp();
    }

    public Set<AParameterDescription> getParamDescriptions() {
        return this.unModifiableParams;
    }

    void setParamDescriptions(Set<AParameterDescription> paramDescriptions) {
        this.paramDescriptions = paramDescriptions;
        this.unModifiableParams = Collections.unmodifiableSet(paramDescriptions);
    }

    public ASubsystemDescription clone() {
        ASubsystemDescription res = null;
        try {
            res = (ASubsystemDescription)super.clone();
            HashSet<AParameterDescription> newSet = new HashSet<AParameterDescription>();
            for (AParameterDescription description : this.paramDescriptions) {
                newSet.add(description.clone());
            }
            res.setParamDescriptions(newSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return res;
    }

    @Override
    public void addParameterDescriptions(ParameterDescription ... descriptions) {
        this.addParameterDescriptions(this.buildSafeArray(descriptions));
    }

    @Override
    public void addParameterDescriptions(Collection<ParameterDescription> descriptions) {
        for (ParameterDescription parm : descriptions) {
            if (!(parm instanceof AParameterDescription)) {
                this.addParameterDescriptions(new AParameterDescription(parm));
                continue;
            }
            this.addParameterDescriptions((AParameterDescription)parm);
        }
    }

    private AParameterDescription[] buildSafeArray(ParameterDescription ... descriptions) {
        List<ParameterDescription> list = Arrays.asList(descriptions);
        AParameterDescription[] parms = new AParameterDescription[descriptions.length];
        int ix = 0;
        for (ParameterDescription description : list) {
            parms[ix] = !(description instanceof AParameterDescription) ? new AParameterDescription(description) : (AParameterDescription)description;
            ++ix;
        }
        return parms;
    }

    public void addParameterDescriptions(AParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        AParameterDescription[] aParameterDescriptionArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            AParameterDescription description = aParameterDescriptionArray[n2];
            this.paramDescriptions.add(description);
            ++n2;
        }
    }

    @Override
    public void removeParameterDescriptions(ParameterDescription ... descriptions) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("parameter description list");
        }
        ParameterDescription[] parameterDescriptionArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterDescription description = parameterDescriptionArray[n2];
            this.paramDescriptions.remove(description);
            ++n2;
        }
    }
}

