/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.lsst.ccs.framework.AbstractMethodConstraint;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

public class PropertyValueMethodConstraint
extends AbstractMethodConstraint {
    private String targetModuleName;
    private String targetProperty;
    private String targetValue;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.framework.contraints");

    public String getTargetModuleName() {
        return this.targetModuleName;
    }

    public void setTargetModuleName(String targetModuleName) {
        this.targetModuleName = targetModuleName;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    @Override
    public boolean isVerified(Context ctx) {
        Module targetModule = ctx.getModule(this.targetModuleName);
        try {
            String val = BeanUtils.getProperty((Object)targetModule, (String)this.targetProperty);
            return val.equals(this.targetValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.error((Object)("illegal access while checking " + this.targetProperty + " on " + this.targetModuleName), new String[0]);
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            log.error((Object)("InvocationTargetException while checking " + this.targetProperty + " on " + this.targetModuleName), new String[0]);
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.error((Object)("NoSuchMethodException while checking " + this.targetProperty + " on " + this.targetModuleName), new String[0]);
            return false;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("propertyConstraint[guardedModule=\"");
        s.append(this.guardedModuleName);
        s.append("\",guardedMethod=\"");
        s.append(this.guardedMethod);
        s.append("\",targetModule=\"");
        s.append(this.targetModuleName);
        s.append("\",targetProp=\"");
        s.append(this.targetProperty);
        s.append("\",value=\"");
        s.append(this.targetValue);
        s.append("\"]");
        return s.toString();
    }
}

